/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef AUDIODRIVERSDL_H
#define AUDIODRIVERSDL_H

#include <qstring.h>
#include <SDL/SDL_audio.h>
#include <SDL/SDL_timer.h>
#include <deque>

#include "AudioBase.h"

class AudioDriverSDL : public AudioBase
{
 public:
    AudioDriverSDL();
    ~AudioDriverSDL();

    bool open(const AudioConfig&);
	
    void close();

    // Free and close opened audio device and reset any variables that
    // reflect the current state of the driver.
    void unload();
	
    void play(void* buffer, unsigned long int bufferSize);

    bool reset();

    const char* getName() const
    {
        return "SDL";
    }

 protected:
    //SDL_AudioSpec sdl_spec;

    //static void sdl_callback(void *userdata, Uint8 *stream, int len);
    Uint32 sdlTime;
    
 private:
    bool haveStream;
	
    void outOfOrder();

    // Check device availability and write permissions.
    bool isThere();

    bool swapEndian;
};

static std::deque<Uint8> memoryDeque;
static SDL_AudioSpec sdl_spec;
static void sdl_callback(void *userdata, Uint8 *stream, int len);

#endif  // AUDIODRIVERSDL_H
