/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "LEDButton.h"

#include <qpainter.h>
#include <qpixmap.h>

#include "images/ledoff.xpm"
#include "images/greenledon.xpm"
#include "images/greenledoff.xpm"
#include "images/redledon.xpm"
#include "images/redledoff.xpm"

LEDButton::LEDButton(QWidget* parent, const char* name) : QButton(parent,name)
{
    if (parent!=0)
        backgCol = parent->backgroundColor();
    else
        backgCol = backgroundColor();
    colour = green;
    bChecked = false;
    bEnabled = true;

    // Get pixmap space.
    onPixmap = new QPixmap(size());
    offPixmap = new QPixmap(size());
    disabledPixmap = new QPixmap(size());
    
    createPixmaps();
}

LEDButton::~LEDButton()
{
    delete onPixmap;
    delete offPixmap;
    delete disabledPixmap;
}

void LEDButton::createPixmaps()
{
    onPixmap->resize(size().width(),size().height());
    offPixmap->resize(size().width(),size().height());
    disabledPixmap->resize(size().width(),size().height());
    
    QPainter paint;

    // Create pixmaps for ``on'' state.
    paint.begin(onPixmap);
    paint.setBackgroundColor(backgCol);
    paint.eraseRect(0,0,size().width(),size().height());
    switch (colour)
    {
     case red:
        {
            QPixmap tmp((const char**)redledon_xpm);
            paint.drawPixmap(0,0,tmp);
            break;
        }
     default:
     case green:
        {
            QPixmap tmp((const char**)greenledon_xpm);
            paint.drawPixmap(0,0,tmp);
            break;
        }
    }
    if (text() != 0)
    {
        QColor myPenColor(black);
        paint.setPen(myPenColor);
        paint.drawText(20,12,text());
    }
    paint.end();

    // Create pixmaps for ``off'' state.
    paint.begin(offPixmap);
    paint.setBackgroundColor(backgCol);
    paint.eraseRect(0,0,size().width(),size().height());
    switch (colour)
    {
     case red:
        {
            QPixmap tmp((const char**)redledoff_xpm);
            paint.drawPixmap(0,0,tmp);
            break;
        }
     default:
     case green:
        {
            QPixmap tmp((const char**)greenledoff_xpm);
            paint.drawPixmap(0,0,tmp);
            break;
        }
    }
    if (text() != 0)
    {
        QColor myPenColor(black);
        paint.setPen(myPenColor);
        paint.drawText(20,12,text());
    }
    paint.end();

    // Create pixmap for ``disabled'' state.
    paint.begin(disabledPixmap);
    paint.setBackgroundColor(backgCol);
    paint.eraseRect(0,0,size().width(),size().height());
    QPixmap tmp((const char**)ledoff_xpm);
    paint.drawPixmap(0,0,tmp);
    if (text() != 0)
    {
        QColor myPenColor(black);
        paint.setPen(myPenColor);
        paint.drawText(20,12,text());
    }
    paint.end();
}

void LEDButton::setColour(LEDColour inColour)
{
    colour = inColour;
}

void LEDButton::setText(const char* newText)
{
    QButton::setText(newText);
    createPixmaps();
}

void LEDButton::setChecked(bool val)
{
    bChecked = val;
    repaint(false);
}

bool LEDButton::isChecked() const
{
    return bChecked;
}

void LEDButton::setEnabled(bool val)
{
    bEnabled = val;
    repaint(false);
    QWidget::setEnabled(val);
}

bool LEDButton::isEnabled() const
{
    return bEnabled;
}

void LEDButton::toggle()
{
    bChecked = !bChecked;
    repaint(false);
}

void LEDButton::drawButton(QPainter* painter)
{
    if (!bEnabled)
        painter->drawPixmap(0,0,*disabledPixmap);
    else if (bChecked)
        painter->drawPixmap(0,0,*onPixmap);
    else
        painter->drawPixmap(0,0,*offPixmap);
}
