/* $Header: /fridge/cvs/xscorch/sutil/shash.c,v 1.5 2001/04/07 19:49:00 justins Exp $ */
/*

   xscorch - shash.c          Copyright(c) 2001 Jacob Luna Lundberg
   jacob(at)chaos2.org        http://chaos2.org/~jacob

   A very slim hash list implementation for xscorch.


   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <math.h>
#include <stdlib.h>
#include "shash.h"



int shash(int bits, unsigned int item) {
/* shash
   Hash item to a list of 2^bits elements. */

   /* rationale -
      The below is a basic multiplication hash.
      (1 << (8 * sizeof(int) - 1)) should be 2^(number of bits in an int) / 2
      We divide by 2 there to avoid overflow and because the magic number
      we are using is actually (sqrt(5) - 1) / 2 so all is well. */

   item *= (1 << (8 * sizeof(int) - 1)) * (sqrt(5) - 1);
   bits = item >> (8 * sizeof(int) - bits);
   return(bits);

}
