/*
   
   libj - _reg.h              Copyright(c) 2001-2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   File reader/writer/parser, variable registry
       

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
   
   This file is part of LIBJ.

*/
#ifndef __reg_int_h_included
#define __reg_int_h_included


/* Includes */
#include <sreg.h>
#include <sstr.h>


/* Useful macros */
#ifndef MIN
   #define MIN(a,b)  ((a) < (b) ? (a) : (b))
#endif /* MIN defined? */

#ifndef MAX
   #define MAX(a,b)  ((a) > (b) ? (a) : (b))
#endif /* MAX defined? */


/* Error reporting assistance */
#define reg_error_line(f, fmt, arg...) if(f != NULL) fprintf(stderr, "%s:%d: error: " fmt "\n", f->filename, f->line, arg)
#define reg_error(f, fmt, arg...)      if(f != NULL) fprintf(stderr, "%s: error: " fmt "\n", f->filename, arg)


/* Variable registry */
reg_var_info *reg_var_info_new(reg_var_info **varlist, const char *name, reg_type type, const reg_class *klass);
reg_type     reg_var_info_lookup(const reg_class *bc, const char *name);
void         reg_var_info_release(reg_var_info **reg);


/* Variables */
void    reg_var_free(reg_var **v);
bool    reg_var_set_integer(const reg *r,  reg_var *v, const char *name, int value);
bool    reg_var_set_doublev(const reg *r,  reg_var *v, const char *name, double value);
bool    reg_var_set_boolean(const reg *r,  reg_var *v, const char *name, bool value, reg_format_bool format);
bool    reg_var_set_string(const reg *r,   reg_var *v, const char *name, const char *value);
bool    reg_var_set_block(const reg *r,    reg_var *v, const char *name, reg_var **block);
bool    reg_var_set_by_value(const reg *r, reg_var *v, const char *name, char *value);
bool    reg_var_merge_block(const reg *r,  reg_var *v, const char *name, reg_var **block);
reg_var *reg_var_new_block(const reg *r, const char *name, const reg_class *klass);
reg_var *reg_var_lookup(reg_var *v, const char *name);


/* Block classes */
reg_class *reg_class_lookup(reg_class *classes, const char *name);
void       reg_class_release(reg_class **classes);


/* Blocks */
reg_block *reg_block_new(const reg *r, const char *name, const reg_class *klass);
void       reg_block_free(reg_block **block);


/* Variable resolution */
reg_var *  reg_block_resolve(reg *r, reg_var *v, const char *path);
reg_var *  reg_block_resolve_container(reg *r, reg_var *v, const char *path, char *varname);


#endif /* __reg_int_h_included */
