/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slinkspin.c,v 1.2 2001/04/07 19:46:50 justins Exp $ */
/*
   
   xscorch - slinkspin.c      Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Scorched label widgets
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <slinkspin.h>
#include <gdk/gdkkeysyms.h>



static GtkSpinButton *parent_class;



enum _ScLinkSpinSignals {
   MODIFIED_SIGNAL,
   LAST_SIGNAL
};
static gint _sc_link_spin_signals[LAST_SIGNAL] = { 0 };
static gint _sc_link_spinf_signals[LAST_SIGNAL] = { 0 };



static void _sc_link_spin_set(GtkEditable *ed) {

   ScLinkSpin *spin = SC_LINK_SPIN(ed);
   
   if(GTK_EDITABLE_CLASS(parent_class)->changed != NULL) {
      GTK_EDITABLE_CLASS(parent_class)->changed(ed);
   }
   
   if(spin->value != NULL) *spin->value = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(ed));
   gtk_signal_emit(GTK_OBJECT(spin), _sc_link_spin_signals[MODIFIED_SIGNAL]);

}
 
 
 
static void _sc_link_spin_class_init(ScLinkSpinClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;
   
   parent_class = gtk_type_class(gtk_spin_button_get_type());
   
   _sc_link_spin_signals[MODIFIED_SIGNAL] =
      gtk_signal_new("modified", 
                     GTK_RUN_LAST,
                     object_class->type,
                     GTK_SIGNAL_OFFSET(ScLinkSpinClass, modified),
                     gtk_marshal_NONE__NONE,
                     GTK_TYPE_NONE, 0);

   gtk_object_class_add_signals(object_class, _sc_link_spin_signals, LAST_SIGNAL);
   klass->modified = NULL;

}



static void _sc_link_spin_init_obj(ScLinkSpin *spin) {
   
   spin->value = NULL;
   gtk_signal_connect(GTK_OBJECT(spin), "changed", GTK_SIGNAL_FUNC(_sc_link_spin_set), NULL);
   
}



GtkType sc_link_spin_get_type(void) {

   static GtkType sc_link_spin_type = 0;
   
   if(sc_link_spin_type == 0) {
      static const GtkTypeInfo sc_link_spin_info = {
         (char *)"ScLinkSpin",
         sizeof(ScLinkSpin),
         sizeof(ScLinkSpinClass),
         (GtkClassInitFunc)_sc_link_spin_class_init,
         (GtkObjectInitFunc)_sc_link_spin_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_link_spin_type = gtk_type_unique(gtk_spin_button_get_type(), &sc_link_spin_info);
   }
    
   return(sc_link_spin_type);

}  



GtkWidget *sc_link_spin_new(int *value, int min, int max, int step) {

   GtkAdjustment *spinadjust;
   ScLinkSpin *spin;
   
   spin = gtk_type_new(sc_link_spin_get_type());
   g_return_val_if_fail(spin != NULL, NULL);

   spinadjust = (GtkAdjustment *)gtk_adjustment_new(*value, min, max, step, step, step);
   gtk_spin_button_configure(GTK_SPIN_BUTTON(spin), spinadjust, 1, 0);
   gtk_widget_set_usize(GTK_WIDGET(spin), 80, 0);
   gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(spin), TRUE);
   spin->value = value;

   return(GTK_WIDGET(spin));

}



static void _sc_link_spinf_set(GtkEditable *ed) {

   ScLinkSpinF *spin = SC_LINK_SPINF(ed);
   
   if(GTK_EDITABLE_CLASS(parent_class)->changed != NULL) {
      GTK_EDITABLE_CLASS(parent_class)->changed(ed);
   }
   
   if(spin->value != NULL) *spin->value = gtk_spin_button_get_value_as_float(GTK_SPIN_BUTTON(spin));
   gtk_signal_emit(GTK_OBJECT(spin), _sc_link_spinf_signals[MODIFIED_SIGNAL]);

}
 
 
 
static void _sc_link_spinf_class_init(ScLinkSpinFClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;
   
   parent_class = gtk_type_class(gtk_spin_button_get_type());
   
   _sc_link_spinf_signals[MODIFIED_SIGNAL] =
      gtk_signal_new("modified", 
                     GTK_RUN_LAST,
                     object_class->type,
                     GTK_SIGNAL_OFFSET(ScLinkSpinFClass, modified),
                     gtk_marshal_NONE__NONE,
                     GTK_TYPE_NONE, 0);

   gtk_object_class_add_signals(object_class, _sc_link_spinf_signals, LAST_SIGNAL);
   klass->modified = NULL;

}



static void _sc_link_spinf_init_obj(ScLinkSpinF *spin) {
   
   spin->value = NULL;
   gtk_signal_connect(GTK_OBJECT(spin), "changed", GTK_SIGNAL_FUNC(_sc_link_spinf_set), NULL);
      
}



GtkType sc_link_spinf_get_type(void) {

   static GtkType sc_link_spinf_type = 0;
   
   if(sc_link_spinf_type == 0) {
      static const GtkTypeInfo sc_link_spinf_info = {
         (char *)"ScLinkSpinF",
         sizeof(ScLinkSpinF),
         sizeof(ScLinkSpinFClass),
         (GtkClassInitFunc)_sc_link_spinf_class_init,
         (GtkObjectInitFunc)_sc_link_spinf_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_link_spinf_type = gtk_type_unique(gtk_spin_button_get_type(), &sc_link_spinf_info);
   }
    
   return(sc_link_spinf_type);

}  



GtkWidget *sc_link_spinf_new(double *value, double min, double max, double step) {

   GtkAdjustment *spinadjust;
   ScLinkSpinF *spin;
   
   spin = gtk_type_new(sc_link_spinf_get_type());
   g_return_val_if_fail(spin != NULL, NULL);

   spinadjust = (GtkAdjustment *)gtk_adjustment_new(*value, min, max, step, step, step);
   gtk_spin_button_configure(GTK_SPIN_BUTTON(spin), spinadjust, 1, 3);
   gtk_widget_set_usize(GTK_WIDGET(spin), 80, 0);
   gtk_spin_button_set_snap_to_ticks(GTK_SPIN_BUTTON(spin), FALSE);
   spin->value = value;
   
   return(GTK_WIDGET(spin));

}



