/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/slinkentry.c,v 1.3 2001/04/12 17:02:38 justins Exp $ */
/*
   
   xscorch - slinkentry.c     Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   Scorched entrybox widgets
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <stdlib.h>
#include <slinkentry.h>
#include <gdk/gdkkeysyms.h>



static GtkEntryClass *parent_class;



enum _ScLinkEntrySignals {
   MODIFIED_SIGNAL,
   LAST_SIGNAL
};
static gint _sc_link_entry_signals[LAST_SIGNAL] = { 0 };



static void _sc_link_entry_set(GtkEditable *ed) {

   ScLinkEntry *entry = SC_LINK_ENTRY(ed);

   if(GTK_EDITABLE_CLASS(parent_class)->changed != NULL) {
      GTK_EDITABLE_CLASS(parent_class)->changed(ed);
   }

   if(entry->value != NULL) strcpy(entry->value, gtk_entry_get_text(GTK_ENTRY(ed)));
   gtk_signal_emit(GTK_OBJECT(entry), _sc_link_entry_signals[MODIFIED_SIGNAL]);

}
 
 
 
static void _sc_link_entry_class_init(ScLinkEntryClass *klass) {

   GtkObjectClass *object_class = (GtkObjectClass *)klass;
   
   parent_class = gtk_type_class(gtk_entry_get_type());
   
   _sc_link_entry_signals[MODIFIED_SIGNAL] =
      gtk_signal_new("modified", 
                     GTK_RUN_LAST,
                     object_class->type,
                     GTK_SIGNAL_OFFSET(ScLinkEntryClass, modified),
                     gtk_marshal_NONE__NONE,
                     GTK_TYPE_NONE, 0);

   gtk_object_class_add_signals(object_class, _sc_link_entry_signals, LAST_SIGNAL);

   klass->modified = NULL;
   GTK_EDITABLE_CLASS(klass)->changed = _sc_link_entry_set;

}



static void _sc_link_entry_init_obj(ScLinkEntry *entry) {
   
   entry->value = NULL;
   
}



GtkType sc_link_entry_get_type(void) {

   static GtkType sc_link_entry_type = 0;
   
   if(sc_link_entry_type == 0) {
      static const GtkTypeInfo sc_link_entry_info = {
         (char *)"ScLinkEntry",
         sizeof(ScLinkEntry),
         sizeof(ScLinkEntryClass),
         (GtkClassInitFunc)_sc_link_entry_class_init,
         (GtkObjectInitFunc)_sc_link_entry_init_obj,
         (GtkArgSetFunc)NULL,
         (GtkArgGetFunc)NULL
      };
      sc_link_entry_type = gtk_type_unique(gtk_entry_get_type(), &sc_link_entry_info);
   }
    
   return(sc_link_entry_type);

}  



GtkWidget *sc_link_entry_new(char *value, int maxlen) {

   ScLinkEntry *entry;
   
   entry = gtk_type_new(sc_link_entry_get_type());
   g_return_val_if_fail(entry != NULL, NULL);

   gtk_widget_set_usize(GTK_WIDGET(entry), 200, 0);
   gtk_entry_set_max_length(GTK_ENTRY(entry), maxlen - 1);
   gtk_entry_set_text(GTK_ENTRY(entry), value);
   entry->value = value;

   return(GTK_WIDGET(entry));

}



