/* $Header: /fridge/cvs/xscorch/sgtk/swidgets/sactoggle.h,v 1.3 2001/08/07 22:26:37 jacob Exp $ */
/*

   xscorch - sactoggle.h      Copyright(c) 2001 Jacob Luna Lundberg
                              Copyright(c) 2001 Justin David Smith
   jacob(at)chaos2.org        http://chaos2.org/~jacob
   justins(at)chaos2.org      http://chaos2.org/~justins

   Header for scorched toggle button widgets.


   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef __sactoggle_h_included
#define __sactoggle_h_included


/* Some definitions are needed. */
#include <sactiveconsole.h>
#include <gtk/gtk.h>


#define  SC_AC_TOGGLE(obj)         GTK_CHECK_CAST(obj, sc_ac_toggle_get_type(), ScACToggle)
#define  SC_AC_TOGGLE_CLASS(klass) GTK_CHECK_CLASS_CAST(klass, sc_ac_toggle_get_type(), ScACToggleClass)
#define  IS_SC_AC_TOGGLE(obj)      GTK_CHECK_TYPE(obj, sc_ac_toggle_get_type())


typedef struct _ScACToggle {
   ScGadget gadget;
   gboolean state;
} ScACToggle;


typedef struct _ScACToggleClass {
   ScGadgetClass parent_class;
} ScACToggleClass;


/* Functions for toggle instantiation. */
GtkType sc_ac_toggle_get_type(void);
ScGadget *sc_ac_toggle_new(gint x, gint y, gint width, gint height);


/* Functions for toggle state. */
void sc_ac_toggle_set(ScACToggle *toggle, gboolean newstate);
gboolean sc_ac_toggle_get(const ScACToggle *toggle);


#endif /* __sactoggle_h_included */
