/* $Header: /fridge/cvs/xscorch/sgtk/smenu-gtk.c,v 1.4 2001/04/07 22:12:46 justins Exp $ */
/*
   
   xscorch - smenu-gtk.c      Copyright(c) 2001,2000 Justin David Smith
   justins(at)chaos2.org      http://chaos2.org/
    
   GTK menus for xscorch
    

   This program is free software; you can redistribute it and/or modify 
   it under the terms of the GNU General Public License as published by 
   the Free Software Foundation; either version 2 of the License, or 
   (at your option) any later version.

   This program is distributed in the hope that it will be useful, 
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation, 
   Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#include <sgame/sconfig.h>
#include <sgame/scffile.h>
#include <stdio.h>
#include <stdlib.h>
#include <xscorch.h>
#include <smenu-gtk.h>
#include <ssystem-gtk.h>
#include <ssetup-gtk.h>
#include <snet-gtk.h>
#include <sdialog.h>
#include <sgame/sgame.h>
#include <sgame/sinfo.h>
#include <sgame/splayer.h>
#include <sutil/sstr.h>



static void _sc_action_game_restart_gtk(sc_window_gtk *w) {

   sc_game_pause(w->c, w->c->game);
   if(sc_dialog_query("Resign Game?", "Are you sure you want to RESIGN this game?")) {
      sc_config_init_game(w->c);
   }
   sc_game_unpause(w->c, w->c->game);

}



static void _sc_action_game_pause_gtk(sc_window_gtk *w) {

   sc_game_pause(w->c, w->c->game);
   sc_dialog_message("Game Paused", "Game paused.  Click `Ok' to unpause the game");
   sc_game_unpause(w->c, w->c->game);

}



static void _sc_action_game_exit_gtk(sc_window_gtk *w) {

   gtk_main_quit();
     
}



static void _sc_action_help_manual_gtk(sc_window_gtk *w) {

   sc_dialog_text(SC_GLOBAL_DIR "/" SC_MANUAL_FILE);

}



static void _sc_action_help_license_gtk(sc_window_gtk *w) {

   sc_dialog_text(SC_GLOBAL_DIR "/" SC_LICENSE_FILE);

}



static void _sc_action_help_about_gtk(sc_window_gtk *w) {

   sc_dialog_message("About XScorch", "XScorch version " VERSION "\n" 
                     SC_COPYRIGHT_NOTICE "\nContributors:\n" SC_CONTRIBUTORS_NOTICE);

}



#if USE_NETWORK

static void _sc_action_network_server_gtk(sc_window_gtk *w) {

   sc_network_server_gtk(w);
   sc_window_update_menus_gtk(w);

}



static void _sc_action_network_client_gtk(sc_window_gtk *w) {

   sc_network_client_gtk(w);
   sc_window_update_menus_gtk(w);

}



static void _sc_action_network_disconnect_gtk(sc_window_gtk *w) {

   if(w->c->client != NULL) sc_net_client_free(&w->c->client, "User disconnected");
   if(w->c->server != NULL) sc_net_server_free(&w->c->server, "User disconnected");
   sc_window_update_menus_gtk(w);

}



static void _sc_action_network_status_gtk(sc_window_gtk *w) {

   char buf[SC_GTK_STRING_BUFFER];
   char line[SC_GTK_STRING_BUFFER];
   const char *title;
   sc_connection *conn;
   sc_net_status *status;
   sc_player *p;
   int i;

   if(w->c->client != NULL) {
      /* we have a connection; is it client or server? */
      if(w->c->server != NULL) {
         snprintfn(buf, sizeof(buf), "Running as server.  Other players:\n");
         for(i = 0; i < w->c->server->connections; ++i) {
            p = w->c->players[i];
            conn = &w->c->server->clients[i];
            snprintfn(line, sizeof(line), "   %s (%s, %08x, %d, %d)\n", 
                      p->name, inet_ntoa(conn->address.sin_addr), conn->flags, p->turret, p->power);
            strncatn(buf, line, sizeof(buf));
         }
         title = "Server";
      } else {
         conn = &w->c->client->server;
         snprintfn(buf, sizeof(buf), "Connected to server %s as %s\n", 
                   inet_ntoa(conn->address.sin_addr), w->c->client->name);
         title = "Client";
      }
      
      /* dump the status information from the client */
      strncatn(buf, "\nPlayer Status:\n", sizeof(buf));
      for(i = 0; i < w->c->numplayers; ++i) {
         p = w->c->players[i];
         status = &w->c->client->status[i];
         snprintfn(line, sizeof(line), "   %s (%s, %08x, %08x, %08x, %08x)\n", 
                   p->name, inet_ntoa(status->address.sin_addr), 
                   status->cli_flags, status->cli_syncarg, 
                   status->srv_flags, status->srv_syncarg);
         strncatn(buf, line, sizeof(buf));
      }
      
      /* display the messagebox */
      sc_dialog_message(title, buf);
   } else {
      /* no connection is currently active. */
      sc_dialog_message("No connection", "No network connection\n");
   }

}

#endif /* USE_NETWORK */



void sc_window_update_menus_gtk(sc_window_gtk *w) {

   #if USE_NETWORK
      sc_config *c = w->c;

      gtk_widget_set_sensitive(w->net_server, TRUE);
      gtk_widget_set_sensitive(w->net_client, TRUE);
      gtk_widget_set_sensitive(w->net_disconnect, c->client != NULL || c->server != NULL);
      gtk_widget_set_sensitive(w->net_chat,       c->client != NULL || c->server != NULL);
      gtk_widget_set_sensitive(w->net_status,     c->client != NULL || c->server != NULL);
   #endif /* Network? */

}



void sc_window_create_menus_gtk(sc_window_gtk *w) {

   static GtkItemFactoryEntry menu_items[] = {
    { "/_Game",                        NULL,             NULL, 0, "<Branch>" },
    { "/_Game/_Pause",                 "<control>Z",     _sc_action_game_pause_gtk, 0, NULL },
    { "/_Game/_Restart Game",          "<control>R",     _sc_action_game_restart_gtk, 0, NULL },
    { "/_Game/sep1",                   NULL,             NULL, 0, "<Separator>" },
    { "/_Game/S_ystem Menu ...",       "<control>Y",     sc_system_menu_gtk, 0, NULL },
    { "/_Game/S_ound Setup ...",       "<control>S",     sc_sound_setup_gtk, 0, NULL },
    { "/_Game/Sa_ve Configuration",    NULL,             sc_config_file_save_gtk, 0, NULL },
    { "/_Game/sep2",                   NULL,             NULL, 0, "<Separator>" },
    { "/_Game/E_xit",                  "<control>X",     _sc_action_game_exit_gtk, 0, NULL },
   #if USE_NETWORK
    { "/_Network",                     NULL,             NULL, 0, "<Branch>" },
    { "/_Network/Create _Server ...",      NULL,         _sc_action_network_server_gtk, 0, NULL },
    { "/_Network/Connect as _Client ...",  NULL,         _sc_action_network_client_gtk, 0, NULL },
    { "/_Network/_Disconnect",         NULL,             _sc_action_network_disconnect_gtk, 0, NULL },
    { "/_Network/sep1",                NULL,             NULL, 0, "<Separator>" },
    { "/_Network/C_hat ...",           NULL,             sc_chat_window_gtk, 0, NULL },
    { "/_Network/S_tatus ...",         NULL,             _sc_action_network_status_gtk, 0, NULL },
   #endif /* Networking? */
    { "/_Help",                        NULL,             NULL, 0, "<Branch>" },
    { "/_Help/_Manual page ...",       "F1",             _sc_action_help_manual_gtk, 0, NULL },
    { "/_Help/_License ...",           NULL,             _sc_action_help_license_gtk, 0, NULL },
    { "/_Help/_About ...",             NULL,             _sc_action_help_about_gtk, 0, NULL }
   };
   GtkItemFactory *menu_factory;
   GtkAccelGroup *menu_accel;
   gint num_menu_items = sizeof(menu_items) / sizeof(menu_items[0]);

   /* Create menus */   
   menu_accel = gtk_accel_group_new();
   menu_factory = gtk_item_factory_new(GTK_TYPE_MENU_BAR, "<main>", menu_accel);
   gtk_item_factory_create_items(menu_factory, num_menu_items, menu_items, w);
   gtk_accel_group_attach(menu_accel, GTK_OBJECT(w->app));

   while(gtk_events_pending()) gtk_main_iteration();

   w->mainmenu       = gtk_item_factory_get_widget(menu_factory, "<main>");
   #if USE_NETWORK
      w->net_server     = gtk_item_factory_get_widget(menu_factory, "/Network/Create Server ...");
      w->net_client     = gtk_item_factory_get_widget(menu_factory, "/Network/Connect as Client ...");
      w->net_disconnect = gtk_item_factory_get_widget(menu_factory, "/Network/Disconnect");
      w->net_chat       = gtk_item_factory_get_widget(menu_factory, "/Network/Chat ...");
      w->net_status     = gtk_item_factory_get_widget(menu_factory, "/Network/Status ...");
   #endif /* Network? */

   sc_window_update_menus_gtk(w);

}


