/*

    xpuyopuyo - psnprintf.h   Copyright(c) 1999,2000 Justin David Smith
    justins(at)chaos2.org     http://chaos2.org/

    Implementation of snprintf
    

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __psnprintf_h_included
#define __psnprintf_h_included


#include <config.h>


#define p_termnull(buf, n)          ((buf)[(n) - 1] = '\0')


#if HAVE_SNPRINTF
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#define  int_snprintf(buf, n, format, args...)  snprintf((buf), (n), (format), args)
#else /* Need to create snprintf() */
int int_snprintf(char *buf, size_t n, const char *format, ...);
#endif /* Have snprintf() ? */


#define  p_snprintf(buf, n, format, args...)    (int_snprintf((buf), (n), (format), args), p_termnull((buf), (n))) 


#define p_strncpy(d, s, n)          p_termnull(strncpy((d), (s), (n)), (n))
#define p_strncat(d, s, n)          p_termnull(strncat((d), (s), (n)), (n))


#endif
