import gtk
import gobject 
import cPickle
import os
from xpn_src.UserDir import get_wdir
from xpn_src.Dialogs import Shortcut_Dialog, Shortcut_Error_Warning_Dialog, Dialog_OK

def escape(data):
    """Escape &, <, and > in a string of data.
    """

    # must do ampersand first
    data = data.replace("&", "&amp;")
    data = data.replace(">", "&gt;")
    data = data.replace("<", "&lt;")
    return data

def load_actions():
    main_actions=[
        ("File",_("_File")),
        ("groups",_("_Groups List..."),"<Control>G"),
        ("rules",_("_Scoring and Action Rules..."),"<Alt>S"),
        ("logs",_("Server _Logs..."),"<Alt>L"),
        ("exp_newsrc",_("Export _Newsrc..."),None),
        ("imp_newsrc",_("_Import Newsrc..."),None),
        ("accelerator",_("_Modify Keyboard Shortcuts..."),None),
        ("conf",_("_Preferences..."),"<Alt>P"),
        ("exit",_("_Exit"),"<Control>E"),
        ("Subscribed",_("Subscribed _Groups")),
        ("gethdrs",_("_Get New Headers in Subscribed Groups"),"<Control>H"),
        ("gethdrssel",_("_Get New Headers in Selected Groups"),"<Control><Shift>H"),
        ("getbodies",_("Get Marked Article _Bodies in Subscribed Groups"),"<Control>B"),
        ("getbodiessel",_("Get Marked Article _Bodies in Selected Groups"),"<Control><Shift>B"),
        ("expand",_("_Expand All Threads"),None),
        ("collapse",_("_Collapse All Threads"),None),
        ("expand_row",_("_Expand Selected SubThread"),None),
        ("collapse_row",_("_Collapse Selected SubThread"),None),
        ("group",_("_View Next Group"),"G"),
        ("mark_group",_("Mark Group ...")),
        ("mark",_("_Mark Selected Groups as Read"),None),
        ("mark_unread_group",_("Mark Selected Groups as Unread"),None),
        ("mark_download_group",_("Mark Group for Retrieving"),"<Control><Shift>M"),
        ("keepall",_("Keep Articles in Selected Groups"),None),
        ("markall",_("Mark _All Groups as Read"),None),
        ("markall_unread",_("Mark All Groups as Unread"),None),
        ("view_group_opts",_("View Options")),
        ("show_threads",_("_Show Threads"),"<Shift><Alt>T"),
        ("show_all_read_threads",_("_Show All Read Threads"),None),
        ("show_read_articles",_("_Show Read Articles"),"<Shift><Alt>R"),
        ("show_unread_articles",_("_Show UnRead Articles"),"<Control><Shift>R"),
        ("show_kept_articles",_("_Show Kept Articles"),"<Shift><Alt>k"),
        ("show_unkept_articles",_("_Show UnKept Articles"),"<Control><Shift>k"),
        ("show_watched_articles",_("_Show Watched Articles"),"<Shift><Alt>W"),
        ("show_ignored_articles",_("_Show Ignored Articles"),"<Shift><Alt>I"),
        ("show_unwatchedignored_articles",_("_Show UnWatched/UnIgnored Articles"),"<Control><Shift>W"),
        ("show_score_neg_articles",_("_Show Articles with Score<0"),"<Shift><Alt>S"),
        ("show_score_zero_articles",_("_Show Articles with Score=0"),"<Control><Alt>S"),
        ("show_score_pos_articles",_("_Show Articles with Score>0"),"<Control><Shift>S"),
        ("raw",_("_View Raw Article"),"H"),
        ("spoiler",_("Show Spoilered Text"),"<Control>L"),
        ("show_quote",_("Show Quoted Text"),"<Control>Q"),
        ("show_sign",_("Show Signatures"),"<Control>S"),
        ("fixed",_("Fixed Pitch Font"),"<Control>F"),
        ("find",_("_Find Article..."),"<Shift>F"),
        ("global",_("Global _Search ..."),"<Control><Shift>G"),
        ("apply_score",_("Apply Scoring and Action Rules"),None),
        ("groups_vs_id",_("Assign Identities to Groups"),None),        
        ("Articles",_("_Articles")),
        ("previous",_("Read Previous Article"),"B"),
        ("next",_("Read Next Article"),"<Alt>N"),
        ("next_unread",_("Read _Next Unread Article"),"N"),
        ("parent",_("Read Parent Article"),"U"),
        ("one_key",_("One-Key Reading"),"space"),
        ("move_up",_("One-Key Scroll Up"),"<Control>space"),
        ("search",_("_Search in the Body..."),"<Shift>S"),
        ("view_articles_opts",_("View Options")),
        ("show_hide_headers",_("Show/Hide _Headers"),"<Alt>H"),
        ("rot13",_("_ROT13 Selected Text"),"<Control>R"),
        ("flags",_("Flags & Score")),
        ("mark_read",_("Mark Article as Read"),"<Shift>R"),
        ("mark_unread",_("Mark Article as UnRead"),"<Shift>U"),
        ("mark_download",_("Mark Article for Retrieving"),"M"),
        ("keep",_("Keep Article"),"<Shift>K"),
        ("mark_unread_sub",_("Mark SubThread as UnRead"),None),
        ("mark_read_sub",_("Mark SubThread as Read"),None),
        ("mark_download_sub",_("Mark SubThread for Retrieving"),"<Control>M"),
        ("keep_sub",_("Keep SubThread"),None),
        ("watch",_("Watch SubThread"),"<Shift>W"),
        ("ignore",_("Ignore SubThread"),"<Shift>I"),
        ("raise_score",_("Raise Author Score"),None),
        ("lower_score",_("Lower Author Score"),None),
        ("set_score",_("Set Author Score"),None),
        ("post",_("_Post New Article..."),"P"),
        ("outbox_manager",_("_Open Outbox Manager"),"<Shift>O"),
        ("followup",_("_Follow-Up To Newsgroup..."),"F"),
        ("reply",_("Reply By _Mail..."),"<Shift>M"),
        ("supersede",_("Supersede Article..."),None),
        ("cancel",_("Cancel Article..."),None),
        ("Help",_("Help")),
        ("about",_("_About..."),None)]

    edit_actions=[
        ("Article",_("_Article")),
        ("send",_("_Send Article"),"<Control>S"),
        ("send_later",_("Send Article _Later"),"<Control><Shift>S"),
        ("save_draft",_("Save Article as Draft"),"<Alt>D"),
        ("discard",_("_Discard Article"),"<Control>D"),
        ("rot13",_("_ROT13 Selected Text"),"<Control>R"),
        ("editor",_("Launch External _Editor"),"<Alt>E"),
        ("spoiler",_("_Insert Spoiler Char"),"<Control>L")]

    outbox_actions=[
        ("Outbox",_("_Outbox")),
        ("send_article",_("_Send Queued Articles"),"<Control>S"),
        ("send_mail",_("Send Queued _Mails"),"<Control><Shift>S"),
        ("edit",_("_Edit Article/Mail"),"E"),
        ("delete",_("_Delete Article/Mail"),"Delete"),
        ("exit",_("_Exit"),"<Control>E")]

    return main_actions,edit_actions,outbox_actions

def load_shortcuts(win):
    main_actions,edit_actions,outbox_actions=load_actions()
    main_shortcuts=dict()
    edit_shortcuts=dict()
    outbox_shortcuts=dict()
    try:
        f=open(os.path.join(get_wdir(),"dats/shortcuts.dat"),"rb")
    except IOError:
        file_found=False
    else:
        file_found=True
        shortcuts=cPickle.load(f)
        f.close()
        if not shortcuts:
            file_found=False

    if win=="main":
        for action in main_actions:
            if len(action)>2:
                if file_found:
                    try:
                        main_shortcuts[action[0]]=shortcuts["main"][action[0]]
                    except:
                        main_shortcuts[action[0]]=action[2]
                else:
                    main_shortcuts[action[0]]=action[2]
        return main_shortcuts

    if win=="edit":
        for action in edit_actions:
            if len(action)>2:
                if file_found:
                    try:
                        edit_shortcuts[action[0]]=shortcuts["edit"][action[0]]
                    except:
                        edit_shortcuts[action[0]]=action[2] 
                else:
                    edit_shortcuts[action[0]]=action[2] 
        return edit_shortcuts
    
    if win=="outbox":
        for action in outbox_actions:
            if len(action)>2:
                if file_found:
                    try:
                        outbox_shortcuts[action[0]]=shortcuts["outbox"][action[0]]
                    except:
                        edit_shortcuts[action[0]]=action[2] 
                else:
                    outbox_shortcuts[action[0]]=action[2]
        return outbox_shortcuts
    else:
        return dict()
    

class KeyBindings:

    def delete_event(self,widget,event,data=None):
        return False  

    def destroy(self,widget):
        self.window.destroy()
        if __name__=="__main__":
            gtk.main_quit()

    def close_ok(self,obj): 
        self.dump_tree()
        #self.main_win.create_ui()
        self.destroy(None)
    
    def close_cancel(self,obj):
        self.destroy(None)

    def get_shortcuts_from_tree(self):
        #0:Short Name 1:Long Name 2:Accelerator 3:Dump
        model=self.treeview.get_model()
        iter_current=model.get_iter_first()
        shortcuts=dict()
        shortcuts["main"]=dict()
        shortcuts["edit"]=dict()
        shortcuts["outbox"]=dict()
        while iter_current:
            sname=model.get_value(iter_current,0)
            accel=model.get_value(iter_current,2)
            to_dump=model.get_value(iter_current,3)
            if to_dump:
                parent_path=tuple([model.get_path(iter_current)[0],])
                parent_iter=model.get_iter(parent_path)
                win=model.get_value(parent_iter,0)
                shortcuts[win][sname]=accel

            #let's cycle the tree
            if model.iter_has_child(iter_current):
                iter_current=model.iter_children(iter_current)
            else:
                iter_next=model.iter_next(iter_current)
                while not iter_next:
                    prev_iter=model.iter_parent(iter_current)
                    iter_current=prev_iter
                    if not prev_iter:
                        break
                    iter_next=model.iter_next(iter_current)
                iter_current=iter_next
        return shortcuts

    def dump_tree(self):
        shortcuts=self.get_shortcuts_from_tree()
        f=open(os.path.join(get_wdir(),"dats/shortcuts.dat"),"wb")
        cPickle.dump(shortcuts,f,1)
        f.close()

    def change_shortcut(self,obj):
        model,iter_selected=self.treeview.get_selection().get_selected()
        if iter_selected:
            to_dump=model.get_value(iter_selected,3)
            if to_dump:
                dialog=Shortcut_Dialog()
                if dialog.resp==gtk.RESPONSE_OK:
                    model.set_value(iter_selected,2,dialog.shortcut)


    def check_duplicates_warnings(self,obj):
        shortcuts=self.get_shortcuts_from_tree()
        main_values=shortcuts["main"].values()
        edit_values=shortcuts["edit"].values()
        outbox_values=shortcuts["outbox"].values()
        main_actions,edit_actions,outbox_actions=load_actions()

        def get_desc(value_to_find,win):
            dic=shortcuts[win]
            if win=="main":
                actions=main_actions
            elif win=="edit":
                actions=edit_actions
            else:
                actions=outbox_actions
            for key,value in dic.iteritems():
                if value_to_find==value:
                    for action in actions:
                        if action[0]==key:
                            return action[1]
            return "" 
        
        warnings=[]
        main_actions,edit_actions,outbox_actions=load_actions()
        for value in edit_values:
            if value in main_values:
                warnings.append([_("Edit Window"),value,get_desc(value,"edit")])
                warnings.append([_("Main Window"),value,get_desc(value,"main")])
                warnings.append(["","",""])

        for value in edit_values:
            if value in outbox_values:
                warnings.append([_("Edit Window"),value,get_desc(value,"edit")])
                warnings.append([_("Outbox Window"),value,get_desc(value,"outbox")])
                warnings.append(["","",""])


        for value in outbox_values:
            if value in main_values:
                warnings.append([_("Outbox Window"),value,get_desc(value,"outbox")])
                warnings.append([_("Main Window"),value,get_desc(value,"main")])
                warnings.append(["","",""])

        if len(warnings)>0:
            self.dialog3=Shortcut_Error_Warning_Dialog(True,warnings,"<b>"+_("Found duplicated shortcuts on different windows")+"</b>\n"+_("That's not a problem, the shortcut will work only on the active window "))
        else:
            self.dialog3=Dialog_OK(_("No Errors"))
            

    def check_duplicates_errors(self,obj):
        shortcuts=self.get_shortcuts_from_tree()
        main_values=[value.lower() for value in shortcuts["main"].values() if value]
        edit_values=[value.lower() for value in shortcuts["edit"].values() if value]
        outbox_values=[value.lower() for value in shortcuts["outbox"].values() if value]
        main_actions,edit_actions,outbox_actions=load_actions()
        
        def get_desc(value_to_find,win):
            dic=shortcuts[win]
            if win=="main":
                actions=main_actions
            elif win=="edit":
                actions=edit_actions
            else:
                actions=outbox_actions
            for key,value in dic.iteritems():
                if value:
                    if value_to_find.lower()==value.lower():
                        for action in actions:
                            if action[0]==key:
                                dic.pop(action[0])
                                return action[1]
            return "" 
        
        errors=[]
        main_actions,edit_actions,outbox_actions=load_actions()
        main_values_shown=[]
        edit_values_shown=[]
        outbox_values_shown=[]

        for value in main_values:
            count=main_values.count(value)
            if count>1:
                if value and not (value in main_values_shown):
                    main_values_shown.append(value)
                    for i in range(count):
                        errors.append([_("Main Window"),value,get_desc(value,"main")])



        for value in edit_values:
            count=edit_values.count(value)
            if count>1:
                if value and not (value in edit_values_shown):
                    edit_values_shown.append(value)
                    for i in range(count):
                        errors.append([_("Edit Window"),value,get_desc(value,"edit")])


        for value in outbox_values:
            count=outbox_values.count(value)
            if count>1:
                if value and not (value in outbox_values_shown):
                    outbox_values_shown.append(value)
                    for i in range(count):
                        errors.append([_("Outbox Window"),value,get_desc(value,"outbox")])
        if len(errors)>0:
            self.dialog3=Shortcut_Error_Warning_Dialog(False,errors,"<b>"+_("Found duplicated shortcuts on the same windows")+"</b>")
        else:
            self.dialog3=Dialog_OK(_("No Errors"))
            
        

    def load_list(self):
        iter_root_mainwin=self.model.append(None,["main",_("Main Window"),"",False])
        main_actions,edit_actions,outbox_actions=load_actions()
        main_shortcuts=load_shortcuts("main")
        edit_shortcuts=load_shortcuts("edit")
        outbox_shortcuts=load_shortcuts("outbox")

        for action in main_actions:
            if len(action)>2:
                self.model.append(iter_root_mainwin,[action[0],action[1],main_shortcuts[action[0]],True])
        iter_root_editwin=self.model.append(None,["edit",_("Edit Window"),"",False])
        for action in edit_actions:
            if len(action)>2:
                self.model.append(iter_root_editwin,[action[0],action[1],edit_shortcuts[action[0]],True])
        iter_root_outboxwin=self.model.append(None,["outbox",_("Outbox Window"),"",False])
        for action in outbox_actions:
            if len(action)>2:
                self.model.append(iter_root_outboxwin,[action[0],action[1],outbox_shortcuts[action[0]],True])
        
    def __init__(self,main_win):
        self.main_win=main_win
        self.window=gtk.Window(gtk.WINDOW_TOPLEVEL)
        self.window.connect("delete_event",self.delete_event)
        self.window.connect("destroy",self.destroy)
        self.window.set_title(_("Keyboard Shortcuts"))
        self.window.set_position(gtk.WIN_POS_CENTER)
        vbox=gtk.VBox()
        vbox.set_border_width(4)
        self.window.set_size_request(500,400)
        scrolledwin=gtk.ScrolledWindow()
        scrolledwin.set_border_width(4)
        scrolledwin.set_policy(gtk.POLICY_AUTOMATIC,gtk.POLICY_AUTOMATIC)
        scrolledwin.set_shadow_type(gtk.SHADOW_ETCHED_IN)
        self.treeview=gtk.TreeView() 
        self.treeview.set_border_width(4)
        #0:Short Name 1:Long Name 2:Accelerator 3:Dump
        self.model=gtk.TreeStore(gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_BOOLEAN)
        scrolledwin.add(self.treeview)
        self.treeview.set_model(self.model)
        text_renderer=gtk.CellRendererText()
        column1=gtk.TreeViewColumn(_("Action"),text_renderer,text=1)
        column2=gtk.TreeViewColumn(_("Shortcut"),text_renderer,text=2)
        self.treeview.append_column(column1)
        self.treeview.append_column(column2)
        self.treeview.set_rules_hint(True)
        
        self.button_change=gtk.Button(_("Change Shortcut"))
        self.button_change.connect("clicked",self.change_shortcut)

        self.button_duplicates_warnings=gtk.Button(_("Duplicates Warnings"))
        self.button_duplicates_warnings.connect("clicked",self.check_duplicates_warnings)

        self.button_duplicates_errors=gtk.Button(_("Duplicates Errors"))
        self.button_duplicates_errors.connect("clicked",self.check_duplicates_errors)
        bhbox=gtk.HBox()
        bhbox.pack_start(self.button_duplicates_warnings,True,True)
        bhbox.pack_start(self.button_duplicates_errors,True,True)
        vbox.pack_start(scrolledwin,True,True,4)
        vbox.pack_start(self.button_change,False,True,4)
        vbox.pack_start(bhbox,False,True,4)
        
        hbox=gtk.HBox()
        self.ok_button=gtk.Button(None,gtk.STOCK_OK)
        self.ok_button.connect("clicked",self.close_ok)
        self.cancel_button=gtk.Button(None,gtk.STOCK_CANCEL)
        self.cancel_button.connect("clicked",self.close_cancel)
        hbox.pack_start(self.cancel_button,True,True,2)
        hbox.pack_start(self.ok_button,True,True,2)
        vbox.pack_start(hbox,False,True,6)
        self.load_list()
        self.window.add(vbox)
        self.window.show_all()
