Name: xplc
Version: 0.3.13
Release: 1
Summary: Cross-platform lightweight component system
Group: System Environment/Libraries
License: LGPL
Source: xplc-%{version}.tar.gz
URL: http://xplc.sourceforge.net/
Prefix: /usr
BuildRoot: %{_tmppath}/%{name}-root
Requires: /sbin/ldconfig

%package devel
Summary: Cross-platform lightweight component system (development)
Group: Development/Libraries
Requires: xplc = %{version}

%package uuidgen
Summary: Cross-platform lightweight component system (uuidgen)
Group: Development/Libraries

%package doc
Summary: Cross-platform lightweight component system (documentation)
Group: Development/Libraries

%description
XPLC (cross-platform lightweight components) is a component system
that provide extensibility and reusability both inside and between
applications, being portable across platforms and languages, easy to
use and having the lowest possible overhead.

%description devel
This is the parts of XPLC needed for development.

%description uuidgen
This is a UUID generator. It is not strictly needed, as there are other
tools available to generate UUIDs.

%description doc
This package contains documentation and examples for XPLC.

%prep
%setup -q

%build
%configure
make
make tests

%install
rm -rf %{buildroot}
%makeinstall
rm -rf $(find examples -name CVS -type d -o -name .cvsignore)

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root)
/usr/lib/libxplc.so.%{version}

%files devel
%defattr(-,root,root)
/usr/include/xplc-%{version}
/usr/lib/xplc-%{version}
/usr/lib/pkgconfig/xplc-%{version}.pc

%files uuidgen
%defattr(-,root,root)
/usr/bin/uuidgen
%doc /usr/share/man/man1/uuidgen.1.gz

%files doc
%defattr(-,root,root)
%doc README CREDITS NEWS LICENSE ChangeLog
%doc examples

%changelog
 * Wed Oct  6 2004  Pierre Phaneuf <pp@ludusdesign.com>
 - Updated for the new parallel installation support.

 * Wed Apr  7 2004  Pierre Phaneuf <pp@ludusdesign.com>
 - Fixed the ownership of the documentation files.
 - Runs the unit tests while packaging.

 * Fri Jan 17 2003  Pierre Phaneuf <pp@ludusdesign.com>
 - Minor fix to the permission of the header files.

 * Sat Nov 30 2002  Pierre Phaneuf <pp@ludusdesign.com>
 - Added libxplc-cxx.a to the devel package.

 * Fri Sep 27 2002  Pierre Phaneuf <pp@ludusdesign.com>
 - Initial RPM release.

