/* -*- Mode: c++ -*-
 *
 *  $Id: s.xotcl.h 1.5 01/02/22 20:34:35-00:00 neumann $
 *  
 *  Extended Object Tcl (XOTcl)
 *
 *  Copyright (C) 1999-2000 Gustaf Neumann, Uwe Zdun
 *
 *  This software is based upon MIT Object Tcl by David Wetherall and
 *  Christopher J. Lindblad, that contains the following copyright message:
 * 
 *  Copyright 1993 Massachusetts Institute of Technology
 * 
 *  Permission to use, copy, modify, distribute, and sell this software and its
 *  documentation for any purpose is hereby granted without fee, provided that
 *  the above copyright notice appear in all copies and that both that
 *  copyright notice and this permission notice appear in supporting
 *  documentation, and that the name of M.I.T. not be used in advertising or
 *  publicity pertaining to distribution of the software without specific,
 *  written prior permission.  M.I.T. makes no representations about the
 *  suitability of this software for any purpose.  It is provided "as is"
 *  without express or implied warranty.
 * 
 */

#ifndef _xotcl_h_
#define _xotcl_h_

#include <tcl.h>

/* activate/deacticate assert 
#define NDEBUG
*/
#define NDEBUG

/* activate/deacticate profiling information at the end
   of running the program
#define PROFILE
*/


/* make self, proc and class in instproc and procs
#define AUTOVARS
*/

/* turn automatic tracing output on/off
#define STACK_TRACE 1
#define CALLSTACK_TRACE 1
#define DISPATCH_TRACE 1
#define OBJDELETION_TRACE 1
*/

/* turn reference information tracing on/off 
#define OBJ_REFERENCES 1
*/
#ifdef AOL_SERVER
# ifndef TCL_THREADS
#  define TCL_THREADS
# endif
#endif

#ifdef __cplusplus
extern "C" {
#endif

struct XOTclObject;
struct XOTclClass;

extern struct XOTclClass*
XOTclIsClass(Tcl_Interp* in, ClientData cd);

extern struct XOTclObject*
XOTclIsObject(Tcl_Interp* in, ClientData cd);

extern struct XOTclObject*
XOTclGetObject(Tcl_Interp* in, char* name);

extern struct XOTclClass*
XOTclGetClass(Tcl_Interp* in, char* name);

extern int
XOTclCreateObject(Tcl_Interp* in, Tcl_Obj* name, struct XOTclClass* cl);

extern int
XOTclCreateClass(Tcl_Interp* in, Tcl_Obj* name, struct XOTclClass* cl);

extern int
XOTclDeleteObject(Tcl_Interp* in, struct XOTclObject* obj);

extern int
XOTclDeleteClass(Tcl_Interp* in, struct XOTclClass* cl);

extern void
XOTclAddPMethod(Tcl_Interp* in, struct XOTclObject* obj, char* nm, Tcl_ObjCmdProc* proc,
	       ClientData cd, Tcl_CmdDeleteProc* dp);

extern void
XOTclAddIMethod(Tcl_Interp* in, struct XOTclClass* cl, char* nm, Tcl_ObjCmdProc* proc,
	       ClientData cd, Tcl_CmdDeleteProc* dp);

extern int
XOTclRemovePMethod(Tcl_Interp* in,struct XOTclObject* obj, char* nm);

extern int
XOTclRemoveIMethod(Tcl_Interp* in, struct XOTclClass* cl, char* nm);

extern Tcl_Obj*
XOTclOSetInstVar(struct XOTclObject* obj, Tcl_Interp* in,
	       Tcl_Obj* name, Tcl_Obj* value, int flgs);

extern Tcl_Obj*
XOTclOGetInstVar(struct XOTclObject* obj, Tcl_Interp* in,
	       Tcl_Obj* name, int flgs);

extern int
XOTclUnsetInstVar(struct XOTclObject* obj, Tcl_Interp* in,
		 char* name, int flgs);
		 
extern void
XOTclSetObjectData(struct XOTclObject* obj, struct XOTclClass* cl,
		  ClientData data);

extern int
XOTclGetObjectData(struct XOTclObject* obj, struct XOTclClass* cl,
		  ClientData* data);

extern int
XOTclUnsetObjectData(struct XOTclObject* obj, struct XOTclClass* cl);

extern int
Xotcl_Init(Tcl_Interp* in);
/*
 * Added by Martin Andrews
 *
 * changed for XOTcl to Tcl_Obj
 */

extern int		
XOTclInstVar(struct XOTclObject* obj, Tcl_Interp* in,
	     char* name, char* destName);
extern int		
XOTclInstVar2(struct XOTclObject* obj, Tcl_Interp* in,
	      char* name1, char* name2, char* destName);

extern Tcl_Obj*
XOTclOSetInstVar2(struct XOTclObject* obj,Tcl_Interp* in,Tcl_Obj* name1,Tcl_Obj* name2,
		 Tcl_Obj* value,int flgs);
extern Tcl_Obj*
XOTclOGetInstVar2(struct XOTclObject* obj, Tcl_Interp* in,Tcl_Obj* name1,Tcl_Obj* name2,
		 int flgs);

extern int		
XOTclUnsetInstVar2(struct XOTclObject* obj, Tcl_Interp* in, char* name1, char* name2, 
		  int flgs);


/*
 * C function to use the "xotcltrace" tcl command
 */
extern int
XOTcl_TraceObjCmd(ClientData cd, Tcl_Interp *in, int objc, Tcl_Obj *CONST objv[]);

#ifdef __cplusplus
}
#endif

#endif /* _xotcl_h_ */
