// -*- c-basic-offset: 4; tab-width: 8; indent-tabs-mode: t -*-

// Copyright (c) 2001-2009 XORP, Inc.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License, Version 2, June
// 1991 as published by the Free Software Foundation. Redistribution
// and/or modification of this program under the terms of any other
// version of the GNU General Public License is not permitted.
// 
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. For more details,
// see the GNU General Public License, Version 2, a copy of which can be
// found in the XORP LICENSE.gpl file.
// 
// XORP Inc, 2953 Bunker Hill Lane, Suite 204, Santa Clara, CA 95054, USA;
// http://xorp.net

#ident "$XORP: xorp/mibs/ospf_mib_1850.cc,v 1.12 2009/01/05 18:31:00 jtc Exp $"

/*
 * Note: this file originally auto-generated by mib2c using
 *        : mib2c.int_watch.conf,v 5.0 2002/04/20 07:30:13 hardaker Exp $
 */

#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>
#include "fixconfigs.h"

#include "libxorp/xorp.h"

#include "xorpevents.hh"
#include "ospf_mib_1850.hh"

// Local variables
static const char * mib_mod_name="ospf_mib_1850";
static PeriodicTimerCallback ptcb;
static XorpTimer * pXtospf = NULL;
SnmpEventLoop& eventloop = SnmpEventLoop::the_instance(); 

// Local functions
static bool ospf_mib_callback() {
    static int i;
    DEBUGMSGTL((mib_mod_name, "Counting...%d\n", i));
    if (-1 == ++i) return false;
    return true;
}


void
init_ospf_mib_1850 (void)
{
    DEBUGMSGTL((mib_mod_name, "Initializing...\n"));
    DEBUGMSGTL((mib_mod_name, "Creating periodic event...\n"));
    ptcb = callback(ospf_mib_callback);
    pXtospf = new XorpTimer;
    *pXtospf = eventloop.new_periodic_ms(1000, ptcb);
    DEBUGMSGTL((mib_mod_name, "Exporting events...\n"));
}

void 
deinit_ospf_mib_1850 (void) 
{
    DEBUGMSGTL((mib_mod_name, "Unloading...\n"));
    delete pXtospf;
    pXtospf= NULL;
}
