#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif


#include <gmodule.h>

#include "libply.h"

#include "bind.h"

//int (*render_ply_)(GdkDrawable *window,GdkGC *gc);
int (*read_ply_)(char *filename, PlySurface *p);


GModule* libply_gmodule=NULL;

#define CRIT     libply_gmodule=g_module_open(l_p,0); if(! libply_gmodule  )    {g_warning("dynamic loading of %s failed:  %s", l_p,	g_module_error()); };

int bind_libply(char *argv[])
{

  if(!   g_module_supported())
    {
      g_critical("dynamic loading is not supported");
      return FALSE;
    };

  //first, try the command line version
#ifdef HAVE_CONFIG_H
#ifdef LIBPLY
 {  
   gchar*   l_p=   g_strdup_printf("%s/libply",LIBPLY);
   CRIT
   g_free(l_p);
 }
 if(!libply_gmodule) {  
   gchar*   l_p=   g_strdup_printf("%s/.libs/libply.so",LIBPLY);
   CRIT
   g_free(l_p);
 }
#endif
#endif
 // maybe in windows it was dropped right by the executable
 if(!libply_gmodule) {
  gchar*  insta_dir=    g_path_get_dirname (argv[0]);
  gchar*   l_p=   g_strdup_printf("%s/libply",insta_dir);
  CRIT 
  g_free(insta_dir);
  g_free(l_p);
 }

 if(! libply_gmodule  ) {
   gchar*   l_p="libply";
   CRIT
      }
 if(! libply_gmodule)
   return FALSE;
  if (!g_module_symbol(libply_gmodule,"read_ply",&read_ply_) 
      //!g_module_symbol(libply_gmodule,"render_ply",&render_ply_)
      )
    {g_critical("cannot bind to libply");return FALSE;};
  return TRUE;
}
