/* Speex Xmms plugin
 * (c) Jens Burkal, license: GPL
 * 
 * config.c: Configuration setup file
 * note: callbacks are defined in gui/callbacks.c
 *
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <xmms/configfile.h>
#include <xmms/plugin.h>
#include <gtk/gtk.h>

#include "libspeex.h"
#include "config.h"
#include "gui/interface.h"
#include "gui/support.h"


// static void spx_config_save (GtkButton *);
static void spx_config_cleanup (void);

void spx_config (void) {

	char *text;
	GtkWidget *configbox, *configitem;

	configbox = create_configbox();

	// Enhancer
	configitem = lookup_widget(configbox, "config_enhancer");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(configitem), speex_cfg->use_enhancer);

	// Buffersize
	configitem = lookup_widget(configbox, "config_buffersize");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(configitem), speex_cfg->buffersize);

	// Prebuffer size
	configitem = lookup_widget(configbox, "config_prebuffersize");
	gtk_spin_button_set_value(GTK_SPIN_BUTTON(configitem), speex_cfg->prebuffer);

	// Use proxy
	configitem = lookup_widget(configbox, "config_useproxy");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(configitem), speex_cfg->use_proxy);

	// Proxy host
	if (speex_cfg->proxy_host)
	{
		configitem = lookup_widget(configbox, "config_proxyhost");
		gtk_entry_set_text(GTK_ENTRY(configitem), speex_cfg->proxy_host);
	}

	// Proxy port
	if (speex_cfg->proxy_port)
	{
		configitem = lookup_widget(configbox, "config_proxyport");
		text = g_strdup_printf("%d", speex_cfg->proxy_port);
		gtk_entry_set_text(GTK_ENTRY(configitem), text);
		g_free(text);
	}

	// Proxy authentication
	configitem = lookup_widget(configbox, "config_proxyauth");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(configitem), speex_cfg->use_auth);

	// Proxy username
	if (speex_cfg->proxy_user)
	{
		configitem = lookup_widget(configbox, "config_proxyuser");
		gtk_entry_set_text(GTK_ENTRY(configitem), speex_cfg->proxy_user);
	}

	// Proxy password
	if (speex_cfg->proxy_passwd)
	{
		configitem = lookup_widget(configbox, "config_proxypass");
		gtk_entry_set_text(GTK_ENTRY(configitem), speex_cfg->proxy_passwd);
	}

	// Use title
	configitem = lookup_widget(configbox, "config_usetitle");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(configitem), speex_cfg->use_title);

	// Title string
	if (speex_cfg->title_format)
	{
		configitem = lookup_widget(configbox, "config_title");
		gtk_entry_set_text(GTK_ENTRY(configitem), speex_cfg->title_format);
	}

	// Disable widgets when toggle-button-parents are unchecked
	if (!speex_cfg->use_proxy)
	{
		configitem = lookup_widget(configbox, "config_proxypanel");
		gtk_widget_set_sensitive(configitem, FALSE);

		configitem = lookup_widget(configbox, "config_proxyauth");
		gtk_widget_set_sensitive(configitem, FALSE);
	}

	if (!speex_cfg->use_proxy || !speex_cfg->use_auth)
	{
		configitem = lookup_widget(configbox, "config_authpanel");
		gtk_widget_set_sensitive(configitem, FALSE);
	}

	if (!speex_cfg->save_stream)
	{
		configitem = lookup_widget(configbox, "config_savepanel");
		gtk_widget_set_sensitive(configitem, FALSE);
	}

	if (!speex_cfg->use_title)
	{
		configitem = lookup_widget(configbox, "config_titlepanel");
		gtk_widget_set_sensitive(configitem, FALSE);
	}
	
	
	// Finally
	gtk_widget_show(configbox);
	
	return;
}



void spx_config_save(GtkButton *button)
{
	ConfigFile *config;
	char *tmp;
	GtkWidget *widget;


	//Enhancer
	widget = lookup_widget(GTK_WIDGET(button), "config_enhancer");
	speex_cfg->use_enhancer = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

	//Buffersize
	widget = lookup_widget(GTK_WIDGET(button), "config_buffersize");
	speex_cfg->buffersize = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

	// Prebuffer
	widget = lookup_widget(GTK_WIDGET(button), "config_prebuffersize");
	speex_cfg->prebuffer = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(widget));

	// Proxy
	widget = lookup_widget(GTK_WIDGET(button), "config_useproxy");
	speex_cfg->use_proxy = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

	// Proxy host
	if (speex_cfg->proxy_host) g_free(speex_cfg->proxy_host);
	widget = lookup_widget(GTK_WIDGET(button), "config_proxyhost");
	speex_cfg->proxy_host = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);

	// Proxy port
	widget = lookup_widget(GTK_WIDGET(button), "config_proxyport");
	tmp = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
	speex_cfg->proxy_port = atoi(tmp);
	g_free(tmp);

	// Proxy auth
	widget = lookup_widget(GTK_WIDGET(button), "config_proxyauth");
	speex_cfg->use_auth = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

	// Proxy user
	if (speex_cfg->proxy_user) g_free(speex_cfg->proxy_user);
	widget = lookup_widget(GTK_WIDGET(button), "config_proxyuser");
	speex_cfg->proxy_user = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
	
	// Proxy pass
	if (speex_cfg->proxy_passwd) g_free(speex_cfg->proxy_passwd);
	widget = lookup_widget(GTK_WIDGET(button), "config_proxypass");
	speex_cfg->proxy_passwd = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);

	// Save stream
	widget = lookup_widget(GTK_WIDGET(button), "config_savestream");
	speex_cfg->save_stream = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

	// Save path
	if (speex_cfg->save_path) g_free(speex_cfg->save_path);
	widget = lookup_widget(GTK_WIDGET(button), "config_streampath");
	speex_cfg->save_path = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
	
	// Use title
	widget = lookup_widget(GTK_WIDGET(button), "config_usetitle");
	speex_cfg->use_title = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(widget));

	// Title format
	if (speex_cfg->title_format) g_free(speex_cfg->title_format);
	widget = lookup_widget(GTK_WIDGET(button), "config_title");
	speex_cfg->title_format = gtk_editable_get_chars(GTK_EDITABLE(widget), 0, -1);
	

	config = xmms_cfg_open_default_file();

	if (config) {
	
		xmms_cfg_write_boolean(config, "speex", "use_enhancer", speex_cfg->use_enhancer);

		xmms_cfg_write_int(config, "speex", "buffersize", speex_cfg->buffersize);
		xmms_cfg_write_int(config, "speex", "prebuffer", speex_cfg->prebuffer);

		xmms_cfg_write_boolean(config, "speex", "use_proxy", speex_cfg->use_proxy);
		xmms_cfg_write_boolean(config, "speex", "proxy_auth", speex_cfg->use_auth);
		
		xmms_cfg_write_string(config, "speex", "proxy_host", speex_cfg->proxy_host);
		xmms_cfg_write_int(config, "speex", "proxy_port", speex_cfg->proxy_port);
		
		xmms_cfg_write_string(config, "speex", "proxy_user", speex_cfg->proxy_user);
		xmms_cfg_write_string(config, "speex", "proxy_pass", speex_cfg->proxy_passwd);
		
		xmms_cfg_write_boolean(config, "speex", "save_stream", speex_cfg->save_stream);
		xmms_cfg_write_string(config, "speex", "save_path", speex_cfg->save_path);

		xmms_cfg_write_boolean(config, "speex", "use_title", speex_cfg->use_title);
		xmms_cfg_write_string(config, "speex", "title_format", speex_cfg->title_format);

		
		if (!(xmms_cfg_write_default_file(config)))
			fprintf(stderr, PACKAGE ": Error writing default configuration file.\n");
	}
	else
		fprintf(stderr, PACKAGE ": Error opening default configuration file.\n");


	spx_config_cleanup();
	
	return;
}

static void spx_config_cleanup (void) {
	return;
	
}

void spx_config_load (void) {

	ConfigFile *config;

	config = xmms_cfg_open_default_file();

	if (speex_cfg == NULL)
		speex_cfg = malloc(sizeof(Speex_Configuration));

	memset(speex_cfg, 0, sizeof(Speex_Configuration));
	
	
	if (config) {

		xmms_cfg_read_boolean(config, "speex", "use_enhancer", &speex_cfg->use_enhancer);
		
		xmms_cfg_read_int(config, "speex", "buffersize", &speex_cfg->buffersize);
		xmms_cfg_read_int(config, "speex", "prebuffer", &speex_cfg->prebuffer);

		xmms_cfg_read_boolean(config, "speex", "use_proxy", &speex_cfg->use_proxy);
		xmms_cfg_read_string(config, "speex", "proxy_host", &speex_cfg->proxy_host);
		xmms_cfg_read_int(config, "speex", "proxy_port", &speex_cfg->proxy_port);
		xmms_cfg_read_boolean(config, "speex", "proxy_auth", &speex_cfg->use_auth);
		xmms_cfg_read_string(config, "speex", "proxy_user", &speex_cfg->proxy_user);
		xmms_cfg_read_string(config, "speex", "proxy_pass", &speex_cfg->proxy_passwd);

		xmms_cfg_read_boolean(config, "speex", "save_stream", &speex_cfg->save_stream);
		xmms_cfg_read_string(config, "speex", "save_path", &speex_cfg->save_path);

		xmms_cfg_read_boolean(config, "speex", "use_title", &speex_cfg->use_title);
		xmms_cfg_read_string(config, "speex", "title_format", &speex_cfg->title_format);
		
	}
	else
	{
		fprintf(stderr, PACKAGE ": Error reading default configuration file.\n");
	}

}


