/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __SINGIT_FRAME_RATE_COUNTER_H__
#define __SINGIT_FRAME_RATE_COUNTER_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <gtk/gtkobject.h>

typedef enum {
	SDL_TICKS,
	GLIB_TICKS
}
TickType;
	
#define TYPE_SINGIT_FRAMERATE_COUNTER            (singit_framerate_counter_get_type ())
#define SINGIT_FRAMERATE_COUNTER(obj)            (GTK_CHECK_CAST ((obj), TYPE_SINGIT_FRAMERATE_COUNTER, SingitFramerateCounter))
#define SINGIT_FRAMERATE_COUNTER_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), TYPE_SINGIT_FRAMERATE_COUNTER, SingitFramerateCounter))
#define IS_SINGIT_FRAMERATE_COUNTER(obj)         (GTK_CHECK_TYPE ((obj), TYPE_SINGIT_FRAMERATE_COUNTER))
#define IS_SINGIT_FRAMERATE_COUNTER_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), TYPE_SINGIT_FRAMERATE_COUNTER))


typedef struct _SingitFramerateCounter      SingitFramerateCounter;
typedef struct _SingitFramerateCounterClass SingitFramerateCounterClass;

struct _SingitFramerateCounter
{
	GtkObject   object;

	guint32    *ringTable;

	guint       table_size;
	guint       table_pos;

	guint       frame_limit;

	guint32     next_ticks;

	TickType    tick_type;
};

struct _SingitFramerateCounterClass
{
	GtkObjectClass parent_class;
};

GtkType    singit_framerate_counter_get_type(void);

// Create a new framerate counter object (freeable using gtk_object_destroy)
GtkObject* singit_framerate_counter_new(guint table_size);

// Sets a framerate limit, so *_new_frame will sleep on high framerates
void       singit_framerate_counter_set_limit(SingitFramerateCounter *sfc, guint limit);

// Start and reset the framerate counter
void       singit_framerate_counter_start(SingitFramerateCounter *sfc);
void       singit_framerate_counter_reset(SingitFramerateCounter *sfc);
// Acknowledge the counter that a new frame has been drawn
void       singit_framerate_counter_new_frame(SingitFramerateCounter *sfc);

// Get the framerate
gfloat     singit_framerate_counter_get_value(SingitFramerateCounter *sfc);

// Set the type of funtion used to determinate the current time / ticks
void       singit_framerate_counter_set_ticktype(SingitFramerateCounter *sfc, TickType type);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif // __SINGIT_FRAME_RATE_COUNTER_H__
