
#ifndef __GFORCE_H__
#define __GFORCE_H__

#define GFORCE_COMPAT_VERSION  116
#define	TRANSITION_ALPHA       1.45

#include "ConsolePixPort.h"
#include "FileSpecList.h"
#include "ArgList.h"
#include "Expression.h"
#include "GF_WaveShape.h"
#include "DeltaField.h"
#include "GF_Palette.h"
#include "XLongList.h"
#include "XStrList.h"
#include "PluginGlue.h"

#include "Prefs.h"

enum {
	cGetConfigInfo		= cPluginSpecific,
	cSpawnNewParticle	= cPluginSpecific + 4,
	cToggleNormalize	= cPluginSpecific + 7,
	cStartSlideshowAll	= cPluginSpecific + 8,
	cStopSlideshowAll	= cPluginSpecific + 9,
	cPrevDeltaField		= cPluginSpecific + 10,
	cNextDeltaField		= cPluginSpecific + 11,
	cToggleFieldShow	= cPluginSpecific + 12,
	cPrevColorMap		= cPluginSpecific + 13,
	cNextColorMap		= cPluginSpecific + 14,
	cToggleColorShow	= cPluginSpecific + 15,
	cPrevWaveShape		= cPluginSpecific + 16,
	cNextWaveShape		= cPluginSpecific + 17,
	cToggleShapeShow	= cPluginSpecific + 18,
	cDecMagScale		= cPluginSpecific + 19,
	cIncMagScale		= cPluginSpecific + 20,
	cDecNumSSteps		= cPluginSpecific + 21,
	cIncNumSSteps		= cPluginSpecific + 22,
	cToggleParticles	= cPluginSpecific + 23,
	cSetPreset0		= cPluginSpecific + 30,
	cSetPreset1		= cPluginSpecific + 31,
	cSetPreset2		= cPluginSpecific + 32,
	cSetPreset3		= cPluginSpecific + 33,
	cSetPreset4		= cPluginSpecific + 34,
	cSetPreset5		= cPluginSpecific + 35,
	cSetPreset6		= cPluginSpecific + 36,
	cSetPreset7		= cPluginSpecific + 37,
	cSetPreset8		= cPluginSpecific + 38,
	cSetPreset9		= cPluginSpecific + 39,
	cPreset0		= cPluginSpecific + 40,
	cPreset1		= cPluginSpecific + 41,
	cPreset2		= cPluginSpecific + 42,
	cPreset3		= cPluginSpecific + 43,
	cPreset4		= cPluginSpecific + 44,
	cPreset5		= cPluginSpecific + 45,
	cPreset6		= cPluginSpecific + 46,
	cPreset7		= cPluginSpecific + 47,
	cPreset8		= cPluginSpecific + 48,
	cPreset9		= cPluginSpecific + 49
};
/*
class PortPage {

	PixPort*	mPort;
};
*/

class GForce : public PluginGlue
{
public:
	GForce( long inHostVers, void* inRefCon = NULL );
	~GForce();

	bool			HandleKey( long inChar );
	bool			HandleCommand( long command );

	long			DefaultNum_S_Steps()			{ return mNum_S_Steps; }

	PixPalEntry		GetPaletteColor(const int index);

	void			SetActiveSongLine(const char* line);

protected:
	virtual void		SetPrefsFactory();
	virtual void		LoadPrefs( Prefs& inPrefs );
	virtual void		SavePrefs( Prefs& inPrefs );

	ConsolePixPort		mPort;

	// Palette stuff
	PixPalEntry		mPalette[ 256 ];
	GF_Palette		mPal1, mPal2, *mGF_Palette, *mNextPal;
	float			mNextPaletteUpdate;
	float			mIntensityParam;

	// Plugin prefs
	long			mTransitionLo;
	long			mTransitionHi;
	long			mHandleKeys;
	long			mNum_S_Steps;
	bool			mNewConfigNotify;
	bool			mParticlesOn;
	UtilStr			mKeyMap;
	UtilStr			mParticleDuration;		// Num secs a particle will stay around
	UtilStr			mParticleProbability;		// Probability a new sausage will start

	// Particle stuff
	float			mNextParticleCheck;
	float			mLastParticleStart;		// LAST_PARTICLE_START
	float			mNumRunningParticles;		// NUM_PARTICLES
	Expression		mParticleProbabilityFcn;	// mParticleProbability compiled
	Expression		mParticleDurationFcn;		// mParticleDuration compiles
	ExpressionDict		mDict;
	nodeClass		mStoppedParticlePool;
	nodeClass		mRunningParticlePool;

	bool 			loadSpecs(char *type, long &specNum,
					char *defaults, ArgList &args,
					FileSysIDList &specList,
					UtilStr &mapName);

	FileSysIDList		mDeltaFields,		mColorMaps,		mWaveShapes,		mParticles;
	long			mCurFieldNum,		mCurColorMapNum,	mCurShapeNum,		mCurParticleNum;
	float			mNextFieldChange, 	mNextColorChange,	mNextShapeChange;
	XLongList		mFieldPlayList,		mColorPlayList,		mShapePlayList,		mParticlePlayList;
	UtilStr			mFieldIntervalStr,	mColorIntervalStr,	mShapeIntervalStr;
	long			mColorTransEnd,		mShapeTransEnd;
	long			mColorTransTime,	mShapeTransTime;	// When > 0, transition is in progress
	float			mColorTrans;
	bool			mFieldSlideShow,	mColorSlideShow,	mShapeSlideShow;
	UtilStr			mColorMapName,		mWaveShapeName;
	Expression		mFieldInterval,		mColorInterval,		mShapeInterval;

	// Field stuff
	DeltaField*		mField, *mNextField;
	DeltaField		mField1, mField2;

	// WaveShape stuff
	float			mWaveXScale;
	float			mWaveYScale;
	GF_WaveShape		mWave1, mWave2, *mWave, *mNextWave;
	UtilStr			mSamplesBuf;
	UtilStr			mSineBuf;
	float*			mSine;

	ExprUserFcn*		mSampleFcn;

	void			loadDeltaField( long inFieldNum );
	void			loadWaveShape( long inShapeNum, bool inAllowMorph );
	void			loadColorMap( long inColorMapNum, bool inAllowMorph );
	void			loadParticle( long inParticleNum );

	void			DrawWave( PixPort& inDest );

	void			StoreConfigState( long inParamName );
	bool			RestoreConfigState( long inParamName );

	// Track text related
	UtilStr			mTrackText;
	Rect			mTrackTextRect;
	int			mTrackTextDur;			// (Pref)
	float			mTrackTextEndT;
	virtual void		StartTrackText();
	void			ManageTrackText();

	void			DrawParticles( PixPort& inPort );

	void			SetNumSampleBins( long inNumBins );

	void			ManageColorChanges();
	void			ManageShapeChanges();
	void			ManageFieldChanges();
	void			ManageParticleChanges();

	void			SpawnNewParticle();

	virtual void		ShowHelp();
	virtual void		MakeStateCmdLine( UtilStr& outCmdList );
	virtual void		DoFrame();
	virtual void		PortResized( long inX, long inY );
	virtual PixPort*	Screenshot_PixPort()			{ return &mPort; }
	virtual void		TimeIndexHasChanged( long inOldBase_MS );
};

#endif // __GFORCE_H__
