
#ifndef __VFRAME_BUFFER_H__
#define __VFRAME_BUFFER_H__

#include "RectUtils.h"

class PixPort;

class VFrameBuffer {

public:
	// Available Depths are 1 and any multiple of 8
	VFrameBuffer();

	// How many bits per pixel?
	int			GetDepth() const					{ return mDepth;							}

	// Basic pixel access
	unsigned char*		Pixel( int inX, int inY ) const		{ return (unsigned char*) mBits + inY * mBytesPerRow + ( ( inX * mDepth ) >> 3 );	}
	inline unsigned char*	GetRow( int inY ) const				{ return (unsigned char*) mBits + inY * mBytesPerRow;								}
	inline unsigned char*	Bits() const						{ return (unsigned char*) mBits;													}

	// How much memory is the pixel data taking up?
	inline long		GetPixelMemSize() const				{ return mBounds.bottom * mBytesPerRow;		}
	inline int		BytesPerRow() const					{ return mBytesPerRow;						}

	// Dimensions access
	inline long		GetX() const						{ return mBounds.right; 					}
	inline long		GetY() const						{ return mBounds.bottom; 					}

	const Rect*		GetBounds() const					{ return &mBounds;							}

	// Typically used before a rect of bits from <inSrceRect> is copied to this VFrameBuffer (where the top-left of the source rect
	// will line up with the point (inX,inY) in this VFrameBuffer).
	// Note:  You may use the same Rect address for <inSrceRect> and <outSrceRect>
	void			ClipSourceRect( const Rect& inSrceRect, int inX, int inY, Rect& outSrceRect ) const;

	// Copies the given rect from the given frame buffer to this frame buffer
	void			CopyBits( PixPort* inSrceBuf, Rect& inSrce, int inX, int inY );

	// Copies the given rect from the given frame buffer to this frame buffer
	// If inSrceBuf is 8 bit and the dest depth is 16 or 32, inPal is used to map pixel values into color.
	void			CopyBits( const VFrameBuffer* inSrceBuf, Rect& inSrce, int inX, int inY, void* inPal );

	// Inverts the intensities of the given rect.  If inRect is nil, the entire frame buffer is inverted.
	void			InvertRect( const Rect* inRect = nil );

	void			Assign( char* inBits, int inWidth, int inHeight, int inBytesPerRow, int inDepth );

	bool			ImageFlipped() const				{ return mImageFlipped;						}

protected:
	int			mDepth;
	int			mBytesPerRow;
	Rect			mBounds;
	char*			mBits;
	bool			mImageFlipped;
};

#endif // __VFRAME_BUFFER_H__
