/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2003 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

// An improved version of the linux kernel tool bin2c

#undef VERSION
#define VERSION  "0.1"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>	// * isatty() *
#include <string.h>

static int *argc_p;
static char ***argv_p;

static int bin2csource(FILE *infile, FILE *outfile)
{
	int ch, total = 0;

	fprintf(outfile, "const char *%s %s=\n",
		(*argv_p)[1], ((*argc_p) > 2) ? (*argv_p)[2] : "");

	do {
		fprintf(outfile, "\t\"");

		do {
			ch = fgetc(infile);
			if (!ferror(infile) && !feof(infile)) {
				total++;
				fprintf(outfile, "\\x%02x", ch);

				if (total % 16 == 0)
					break;
			}
			else { break; }
		}
		while (!ferror(outfile));

		fprintf(outfile, "\"\n");
	}
	while (!feof(infile));

	fprintf(outfile, "\t;\n\nconst int %s_size = %d;\n", (*argv_p)[1], total);

	return 0;
}

static void print_blurb(FILE *bout)
{
	fprintf(bout, "%s version %s, by Jan-Marek Glogowski.\n",
		(*argv_p)[0], VERSION);
	fprintf(bout, "usage:  %s [options] <PNG_FILE>... > "
		"c-source.h\n", (*argv_p)[0]);
	fprintf(bout, "   or:  ... | %s > c-source.h\n", (*argv_p)[0]);
}

static int parse_args()
{
	int argc = *argc_p;
	char **argv = *argv_p;
	int i = 1;

	while (i < argc) {
		if (strcmp ("-h", argv[i]) == 0 ||
			 strcmp ("--help", argv[i]) == 0)
		{
			print_blurb (stderr);
			argv[i] = NULL;
			exit (0);
		}
		else if (strcmp ("-v", argv[i]) == 0 ||
			 strcmp ("--version", argv[i]) == 0)
		{
			print_blurb (stderr);
			argv[i] = NULL;
			exit (0);
		}
		else { break; }
		i++;
	}

	return i;
}

int main(int argc, char *argv[])
{
	FILE *infile, *outfile;
	int error = 0;
	int files;
//	int c;

	// Set global arg pointers
	argv_p = &argv;
	argc_p = &argc;

	files = parse_args();

#ifdef RISCOS
	outfile = stdout;
#else
	if ((outfile = fdopen(1, "w")) == (FILE *)NULL) {
		fprintf(stderr, "%s error:  cannot write to stdout\n", argv[0]);
		return 5;
	}
#endif

	if ((argc - files) == 0) {
		if (isatty(0)
			// || ((c = getc(stdin)) == EOF)
			)
		{
			print_blurb(stderr);
			return 0;
		}

		// ungetc(c, stdin);

		// setmode/fdopen code borrowed from Info-ZIP's funzip.c (Mark Adler)
		// [HAVE_SETMODE is same macro used by NetPBM 9.x for Cygwin, etc.]

#ifdef HAVE_SETMODE   // DOS, FLEXOS, Human68k, NetWare, OS/2, Win32
# if (defined(__HIGHC__) && !defined(FLEXOS))
		setmode(stdin, _BINARY);
# else
		setmode(0, O_BINARY);   /* some buggy C libs require BOTH setmode() */
# endif          //  call AND fdopen() in binary mode :-(
#endif

#ifdef RISCOS
		infile = stdin;
#else
		if ((infile = fdopen(0, "rb")) == (FILE *)NULL) {
			fprintf(stderr, "%s error:  cannot find stdin\n", argv[0]);
			return 5;
		}
#endif
		goto process_font;
	}

	while (files < argc) {
		if ((infile = fopen(argv[files], "rb")) == (FILE *)NULL) {
			fprintf(stderr,
				"%s error: cannot open %s for reading\n",
				argv[0], argv[files]);
			return 5;
		}

process_font:
		// output always goes to stdout (text mode, not binary)
		error = bin2csource(infile, outfile);

		fclose(infile);

		files++;
	}

	fclose(outfile);

	return error;
}
