/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "singit_macros.h"
#include "singit_macros_private.h"
#include "singit_plugin_data.h"

DisplayerPluginData* dp_data_new()
{
	DisplayerPluginData* result;

	#ifdef CODEDEBUG
	DEBUG(("singit_plugin_data.c [dp_data_new]\n"), 9);
	#endif

	result = g_malloc(sizeof(DisplayerPluginData));

	result->dis_list = NULL;
	result->enabled_list = NULL;
	result->playback_started = FALSE;
	result->attachments = 1;
	result->initialized = FALSE;

	return result;
}

void dp_data_free(DisplayerPluginData* dp_data)
{
	if (!dp_data) { return; }

	#ifdef CODEDEBUG
	DEBUG(("singit_plugin_data.c [dp_data_free]\n"), 9);
	#endif

	g_list_free(dp_data->enabled_list);
	g_list_free(dp_data->dis_list);

	g_free(dp_data);
}

gboolean dp_data_attach(DisplayerPluginData *dp_data)
{
	#ifdef CODEDEBUG
	DEBUG(("singit_plugin_data.c [dp_data_attach] : "), 9);
	#endif

	if (dp_data != NULL) {
		dp_data->attachments++;
		#ifdef CODEDEBUG
		DEBUG(("Attached\n"), 9);
		#endif
		return TRUE;
	}
	#ifdef CODEDEBUG
	DEBUG(("Failed\n"), 9);
	#endif
	return FALSE;
}

gboolean dp_data_detach(DisplayerPluginData *dp_data, gboolean free)
{
	#ifdef CODEDEBUG
	DEBUG(("singit_plugin_data.c [dp_data_detach] : "), 9);
	#endif

	if (!dp_data) { return TRUE; }
	dp_data->attachments--;
	if (dp_data->attachments == 0) {
		if (free) {
			#ifdef CODEDEBUG
			DEBUG(("Freed\n"), 9);
			#endif
			dp_data_free(dp_data);
		}
		return TRUE;
	}
	#ifdef CODEDEBUG
	DEBUG(("Detached\n"), 9);
	#endif
	return FALSE;
}
