/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Based on GtkItemFactory form the gtk+ - toolkit
 */


#ifndef __GTK_ITEM_TREE_FACTORY_H__
#define	__GTK_ITEM_TREE_FACTORY_H__


#include <gtk/gtkwidget.h>
#include <gtk/gtkmenufactory.h>	/* for GtkMenuEntry */
#include <gtk/gtkbindings.h>	/* for GtkPatternSpec */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


typedef void	(*GtkPrintFunc)		   (gpointer		 func_data,
					    gchar		*str);
typedef gchar * (*GtkTranslateFunc)	   (const gchar		*path,
					    gpointer             func_data);
typedef	void	(*GtkItemTreeFactoryCallback)  ();
typedef	void	(*GtkItemTreeFactoryCallback1) (gpointer		 callback_data,
					    guint		 callback_action,
					    GtkWidget		*widget);

#define	GTK_TYPE_ITEM_FACTORY		 (gtk_item_tree_factory_get_type ())
#define	GTK_ITEM_TREE_FACTORY(object)	 (GTK_CHECK_CAST (object, GTK_TYPE_ITEM_FACTORY, GtkItemTreeFactory))
#define	GTK_ITEM_TREE_FACTORY_CLASS(klass)	 (GTK_CHECK_CLASS_CAST (klass, GTK_TYPE_ITEM_FACTORY, GtkItemTreeFactoryClass))
#define	GTK_IS_ITEM_FACTORY(object)	 (GTK_CHECK_TYPE (object, GTK_TYPE_ITEM_FACTORY))
#define	GTK_IS_ITEM_FACTORY_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_ITEM_FACTORY))


typedef	struct	_GtkItemTreeFactory			GtkItemTreeFactory;
typedef	struct	_GtkItemTreeFactoryClass		GtkItemTreeFactoryClass;
typedef	struct	_GtkItemTreeFactoryEntry		GtkItemTreeFactoryEntry;
typedef	struct	_GtkItemTreeFactoryItem		GtkItemTreeFactoryItem;

struct _GtkItemTreeFactory
{
	GtkObject		 object;

	gchar			*path;
  GtkAccelGroup		*accel_group;
  GtkWidget		*widget;
  GSList		*items;

  GtkTranslateFunc       translate_func;
  gpointer               translate_data;
  GtkDestroyNotify       translate_notify;
};

struct _GtkItemTreeFactoryClass
{
  GtkObjectClass	 object_class;

  gchar			*cpair_comment_single;

  GHashTable		*item_ht;

  gpointer               dummy;
};

struct _GtkItemTreeFactoryEntry
{
  gchar *path;
  gchar *accelerator;

  GtkItemTreeFactoryCallback callback;
  guint			 callback_action;

  /* possible values:
   * NULL		-> "<Item>"
   * ""			-> "<Item>"
   * "<Title>"		-> create a title item
   * "<Item>"		-> create a simple item
   * "<CheckItem>"	-> create a check item
   * "<ToggleItem>"	-> create a toggle item
   * "<RadioItem>"	-> create a radio item
   * <path>		-> path of a radio item to link against
   * "<Separator>"	-> create a separator
   * "<Branch>"		-> create an item to hold sub items
   * "<LastBranch>"	-> create a right justified item to hold sub items
   */
  gchar		 *item_type;
};

struct _GtkItemTreeFactoryItem
{
  gchar *path;
  guint  accelerator_key;
  guint  accelerator_mods;
  guint	 modified : 1;
  guint  in_propagation : 1;
  gchar *dummy;

  GSList *widgets;
};


GtkType		gtk_item_tree_factory_get_type	    (void);

/* `container_type' must be of GTK_TYPE_MENU_BAR, GTK_TYPE_MENU,
 * or GTK_TYPE_OPTION_MENU.
 */
GtkItemTreeFactory*	gtk_item_tree_factory_new	   (GtkType		 container_type,
					    const gchar		*path,
					    GtkAccelGroup       *accel_group);
void		gtk_item_tree_factory_construct (GtkItemTreeFactory	*ifactory,
					    GtkType		 container_type,
					    const gchar		*path,
					    GtkAccelGroup       *accel_group);

/* These functions operate on GtkItemTreeFactoryClass basis.
 */
void		gtk_item_tree_factory_parse_rc	    (const gchar    *file_name);
void		gtk_item_tree_factory_parse_rc_string    (const gchar    *rc_string);
void		gtk_item_tree_factory_parse_rc_scanner   (GScanner	    *scanner);
void		gtk_item_tree_factory_add_foreign        (GtkWidget	    *accel_widget,
						     const gchar    *full_path,
						     GtkAccelGroup  *accel_group,
						     guint	     keyval,
						     GdkModifierType modifiers);

GtkItemTreeFactory*	gtk_item_tree_factory_from_widget	    (GtkWidget	      *widget);
gchar*		gtk_item_tree_factory_path_from_widget   (GtkWidget	      *widget);

GtkWidget*	gtk_item_tree_factory_get_item	      (GtkItemTreeFactory *ifactory,
						       const gchar    *path);
GtkWidget*	gtk_item_tree_factory_get_widget	      (GtkItemTreeFactory *ifactory,
						       const gchar    *path);
GtkWidget*	gtk_item_tree_factory_get_widget_by_action (GtkItemTreeFactory *ifactory,
						       guint	       action);
GtkWidget*	gtk_item_tree_factory_get_item_by_action   (GtkItemTreeFactory *ifactory,
						       guint	       action);

/* If `path_pspec' is passed as `NULL', this function will iterate over
 * all hash entries. otherwise only those entries will be dumped for which
 * the pattern matches, e.g. "<Image>*...".
 */
void	gtk_item_tree_factory_dump_items	(GtkPatternSpec		*path_pspec,
					 gboolean		 modified_only,
					 GtkPrintFunc		 print_func,
					 gpointer		 func_data);
void	gtk_item_tree_factory_dump_rc	(const gchar		*file_name,
					 GtkPatternSpec		*path_pspec,
					 gboolean		 modified_only);
void	gtk_item_tree_factory_print_func	(gpointer		 FILE_pointer,
					 gchar			*string);
void	gtk_item_tree_factory_create_item	(GtkItemTreeFactory		*ifactory,
					 GtkItemTreeFactoryEntry	*entry,
					 gpointer		 callback_data,
					 guint			 callback_type);
void	gtk_item_tree_factory_create_items	(GtkItemTreeFactory		*ifactory,
					 guint			 n_entries,
					 GtkItemTreeFactoryEntry	*entries,
					 gpointer		 callback_data);
void	gtk_item_tree_factory_delete_item	(GtkItemTreeFactory		*ifactory,
					 const gchar		*path);
void	gtk_item_tree_factory_delete_entry	(GtkItemTreeFactory		*ifactory,
					 GtkItemTreeFactoryEntry	*entry);
void	gtk_item_tree_factory_delete_entries	(GtkItemTreeFactory		*ifactory,
					 guint			 n_entries,
					 GtkItemTreeFactoryEntry	*entries);
void	gtk_item_tree_factory_popup		(GtkItemTreeFactory		*ifactory,
					 guint			 x,
					 guint			 y,
					 guint			 mouse_button,
					 guint32		 time);
void	gtk_item_tree_factory_popup_with_data(GtkItemTreeFactory		*ifactory,
					 gpointer		 popup_data,
					 GtkDestroyNotify	 destroy,
					 guint			 x,
					 guint			 y,
					 guint			 mouse_button,
					 guint32		 time);
gpointer gtk_item_tree_factory_popup_data	(GtkItemTreeFactory		*ifactory);
gpointer gtk_item_tree_factory_popup_data_from_widget (GtkWidget	*widget);
void   gtk_item_tree_factory_set_translate_func (GtkItemTreeFactory      *ifactory,
					    GtkTranslateFunc     func,
					    gpointer             data,
					    GtkDestroyNotify     notify);

/* Compatibility functions for deprecated GtkMenuFactory code
 */
GtkItemTreeFactory*	gtk_item_tree_factory_from_path   (const gchar       *path);
void	gtk_item_tree_factory_create_menu_entries (guint		 n_entries,
					      GtkMenuEntry      *entries);
void	gtk_item_factories_path_delete	   (const gchar		*ifactory_path,
					    const gchar		*path);
typedef	void	(*GtkItemTreeFactoryCallback2) (GtkWidget		*widget,
					    gpointer		 callback_data,
					    guint		 callback_action);
void	gtk_item_tree_factory_create_items_ac (GtkItemTreeFactory	*ifactory,
					  guint			 n_entries,
					  GtkItemTreeFactoryEntry	*entries,
					  gpointer		 callback_data,
					  guint			 callback_type);



#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif	/* __GTK_ITEM_TREE_FACTORY_H__ */
