/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __DLG_OPENGL_CONFIG_H__
#define __DLG_OPENGL_CONFIG_H__

#ifdef __cplusplus
extern "C" {
#endif // __cplusplus

typedef struct _OpenGLConfig {

	gint sensitivity_bass_low;
	gint sensitivity_bass_high;
	gboolean direct_apply;
	gboolean display_particles;

	gboolean isLoaded;
	guint attachments;
}
OpenGLConfig;

/* creates new config data includes attachment */
void opengl_config_new();
/* frees config data even if there are attachments */
void opengl_config_free();

void opengl_config_show();
void opengl_config_hide();

/* save config data */
gboolean opengl_config_save();
/* load config data */
gboolean opengl_config_load();

gboolean opengl_config_attach();
gboolean opengl_config_detach(gboolean free);

#ifdef __cplusplus
}
#endif // __cplusplus

#endif  // __DLG_OPENGL_CONFIG_H__
