/*
 *  SingIt Lyrics Displayer
 *  Copyright (C) 2000 - 2002 Jan-Marek Glogowski <glogow@stud.fbi.fh-darmstadt.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gdk/gdkx.h>
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "singit_macros.h"
#include "singit_macros_private.h"

#include "singit_config_gen.h"
#include "singit_tools.h"

/*
	gtk_marshaller to marshal a pointer result
*/
typedef gpointer (*GtkSignal_POINTER__NONE)(GtkObject *object, gpointer user_data);

void gtk_marshal_POINTER__NONE(GtkObject* object, GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_POINTER__NONE rfunc;
	gpointer *return_val;
	return_val = GTK_RETLOC_POINTER(args[0]);
	rfunc = (GtkSignal_POINTER__NONE) func;
	*return_val = (*rfunc)(object, func_data);
}

/*
	gtk_marshaller to marshal two pointer and an integer argument
*/

typedef void (*GtkSignal_NONE__POINTER_POINTER_INT)
	(GtkObject *object, gpointer arg1, gpointer arg2, gint arg3, gpointer user_data);

void gtk_marshal_NONE__POINTER_POINTER_INT
	(GtkObject* object, GtkSignalFunc func, gpointer func_data, GtkArg* args)
{
	GtkSignal_NONE__POINTER_POINTER_INT rfunc;
	rfunc = (GtkSignal_NONE__POINTER_POINTER_INT) func;
	(*rfunc)(object, GTK_VALUE_POINTER(args[0]), GTK_VALUE_POINTER(args[1]), GTK_VALUE_INT(args[2]), func_data);
}

enum {
	INIT,
	FREE,
	LOAD,
	SAVE,
	SAVE_PART,
	UPDATE,
	LAST_SIGNAL
};
/*
enum {
	ARG_0,
};
*/
#define CONFIG_FILENAME g_strconcat(g_get_home_dir(), "/.xmms/config-singit", NULL)

static GtkObjectClass *parent_class = NULL;
static guint scg_signals[LAST_SIGNAL] = { 0 };

static void singit_config_gen_class_init (SingitConfigGenClass *klass);
static void singit_config_gen_init (SingitConfigGen *scg);

// static void singit_config_gen_set_arg(GtkObject *object, GtkArg *arg, guint arg_id);
// static void singit_config_gen_get_arg(GtkObject *object, GtkArg *arg, guint arg_id);
static void singit_config_gen_destroy(GtkObject *object);

GtkType singit_config_gen_get_type (void)
{
	static GtkType singit_config_gen_type = 0;

	if (!singit_config_gen_type) {

		static const GtkTypeInfo singit_config_gen_info =
		{
			"SingitConfigGen",
			sizeof (SingitConfigGen),
			sizeof (SingitConfigGenClass),
			(GtkClassInitFunc) singit_config_gen_class_init,
			(GtkObjectInitFunc) singit_config_gen_init,
			/* reserved_1 */ NULL,
			/* reserved_2 */ NULL,
			(GtkClassInitFunc) NULL,
		};

		singit_config_gen_type = gtk_type_unique(GTK_TYPE_OBJECT, &singit_config_gen_info);
	}

	return singit_config_gen_type;
}

static void singit_config_gen_class_init (SingitConfigGenClass *klass)
{
	GtkObjectClass *object_class = (GtkObjectClass*) klass;
	parent_class = gtk_type_class(GTK_TYPE_OBJECT);
/*
	object_class->set_arg = singit_config_gen_set_arg;
	object_class->get_arg = singit_config_gen_get_arg;
*/
	object_class->destroy = singit_config_gen_destroy;

//	gtk_object_add_arg_type ("SingitConfigGen::attachments", GTK_TYPE_UINT, GTK_ARG_READABLE, ARG_ATTACHMENTS);

	scg_signals[INIT] =
		gtk_signal_new("init",
			GTK_RUN_LAST,
			object_class->type,
			GTK_SIGNAL_OFFSET (SingitConfigGenClass, init),
			gtk_marshal_POINTER__NONE,
			GTK_TYPE_POINTER, 0);

	scg_signals[FREE] =
		gtk_signal_new("free",
			GTK_RUN_LAST,
			object_class->type,
			GTK_SIGNAL_OFFSET (SingitConfigGenClass, free),
			gtk_marshal_NONE__POINTER,
			GTK_TYPE_NONE, 1,
			GTK_TYPE_POINTER);

	scg_signals[LOAD] =
		gtk_signal_new("load",
			GTK_RUN_LAST,
			object_class->type,
			GTK_SIGNAL_OFFSET (SingitConfigGenClass, load),
			gtk_marshal_NONE__POINTER_POINTER,
			GTK_TYPE_NONE, 2,
			GTK_TYPE_POINTER,
			GTK_TYPE_POINTER);

	scg_signals[SAVE] =
		gtk_signal_new("save",
			GTK_RUN_FIRST,
			object_class->type,
			GTK_SIGNAL_OFFSET (SingitConfigGenClass, save),
			gtk_marshal_NONE__POINTER_POINTER,
			GTK_TYPE_NONE, 2,
			GTK_TYPE_POINTER,
			GTK_TYPE_POINTER);

	scg_signals[SAVE_PART] =
		gtk_signal_new("save_part",
			GTK_RUN_FIRST,
			object_class->type,
			GTK_SIGNAL_OFFSET (SingitConfigGenClass, save_part),
			gtk_marshal_NONE__POINTER_POINTER_INT,
			GTK_TYPE_NONE, 3,
			GTK_TYPE_POINTER,
			GTK_TYPE_POINTER,
			GTK_TYPE_INT);

	scg_signals[UPDATE] =
		gtk_signal_new("update",
			GTK_RUN_FIRST,
			object_class->type,
			GTK_SIGNAL_OFFSET (SingitConfigGenClass, update),
			gtk_marshal_NONE__NONE,
			GTK_TYPE_NONE, 0);

	klass->init = NULL;
	klass->free = NULL;
	klass->load = NULL;
	klass->save = NULL;
	klass->update = NULL;

	gtk_object_class_add_signals (object_class, scg_signals, LAST_SIGNAL);
}

static void singit_config_gen_init (SingitConfigGen *scg)
{
	scg->config_data = NULL;
	scg->config_file = NULL;
}

static void singit_config_gen_destroy (GtkObject *object)
{
	SingitConfigGen *scg;

	g_return_if_fail (object != NULL);
	g_return_if_fail (IS_SINGIT_CONFIG_GEN (object));

	scg = SINGIT_CONFIG_GEN (object);

	if (scg->config_data != NULL)
		gtk_signal_emit (GTK_OBJECT(scg), scg_signals[FREE], scg->config_data);

/*	if (scg->adjustment)
		gtk_signal_disconnect_by_data (GTK_OBJECT(scg->adjustment), scg);*/

	if (GTK_OBJECT_CLASS(parent_class)->destroy)
		GTK_OBJECT_CLASS(parent_class)->destroy(object);
}
/*
static void singit_config_gen_set_arg(GtkObject *object, GtkArg *arg, guint arg_id)
{
	SingitConfigGen *scg;

	scg = SINGIT_CONFIG_GEN(object);

	switch (arg_id)
	{
	default:
//		arg->type = GTK_TYPE_INVALID;
		break;
	}
}

static void singit_config_gen_get_arg(GtkObject *object, GtkArg *arg, guint arg_id)
{
	SingitConfigGen *scg;

	scg = SINGIT_CONFIG_GEN(object);

	switch (arg_id)
	{
	default:
		arg->type = GTK_TYPE_INVALID;
		break;
	}
}
*/
GtkObject *singit_config_gen_new (gpointer cfg_data)
{
	SingitConfigGen *scg = gtk_type_new(TYPE_SINGIT_CONFIG_GEN);
	scg->config_data = cfg_data;
	return GTK_OBJECT(scg);
}

gboolean singit_config_gen_open(SingitConfigGen *scg)
{
	gchar *filename;

	g_return_val_if_fail (scg != NULL, FALSE);
	g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), FALSE);

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_open] : "), 9);
#	endif

	if (!singit_config_gen_attach(scg)) {
#		ifdef CODEDEBUG
		DEBUG(("Failed\n"), 9);
#		endif
		return FALSE;
	}

	filename = CONFIG_FILENAME;
	scg->config_file = xmms_cfg_open_file(filename);
	if (!scg->config_file)
		scg->config_file = xmms_cfg_new();
	g_free(filename);

#	ifdef CODEDEBUG
	DEBUG(("Ok\n"), 9);
#	endif

	return (scg->config_file != NULL);
}

gboolean singit_config_gen_close(SingitConfigGen *scg, gboolean save)
{
	gchar *filename;

	g_return_val_if_fail (scg != NULL, FALSE);
	g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), FALSE);

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_close] : "), 9);
#	endif

	if (!scg->config_file) {
#		ifdef CODEDEBUG
		DEBUG(("Failed\n"), 9);
#		endif
		return FALSE;
	}

	if (save) {
		filename = CONFIG_FILENAME;
		xmms_cfg_write_file(scg->config_file, filename);
		g_free(filename);
	}
	xmms_cfg_free(scg->config_file);

	singit_config_gen_detach(scg);

#	ifdef CODEDEBUG
	DEBUG(("Ok\n"), 9);
#	endif

	return TRUE;
}

gboolean singit_config_gen_attach(SingitConfigGen *scg)
{
#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_attach] : "), 9);
#	endif

	if (scg != NULL) {

		g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), FALSE);

		gtk_object_ref(GTK_OBJECT(scg));

#		ifdef CODEDEBUG
		DEBUG(("Attached\n"), 9);
#		endif
		return TRUE;
	}
#	ifdef CODEDEBUG
	DEBUG(("Failed\n"), 9);
#	endif
	return FALSE;
}

void singit_config_gen_detach(SingitConfigGen *scg)
{
	g_return_if_fail (scg != NULL);
	g_return_if_fail (IS_SINGIT_CONFIG_GEN (scg));

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_detach]\n"), 9);
#	endif

	gtk_object_unref(GTK_OBJECT(scg));
}

gboolean singit_config_gen_load(SingitConfigGen *scg)
{
	gboolean result = FALSE;

	g_return_val_if_fail (scg != NULL, FALSE);
	g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), FALSE);

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_load] : "), 9);
#	endif

	if (singit_config_gen_open(scg)) {
		if (scg->config_data != NULL)
			gtk_signal_emit (GTK_OBJECT(scg), scg_signals[FREE], scg->config_data);
		gtk_signal_emit (GTK_OBJECT(scg), scg_signals[INIT], &scg->config_data);
		gtk_signal_emit (GTK_OBJECT(scg), scg_signals[LOAD], scg->config_file, scg->config_data);
		result = singit_config_gen_close(scg, FALSE);
	}
#	ifdef CODEDEBUG
	if (result == TRUE) { DEBUG(("Ok\n"), 9); }
	else { DEBUG(("Failed\n"), 9); }
#	endif
	return result;
}

gboolean singit_config_gen_save(SingitConfigGen *scg)
{
	gboolean result = FALSE;

	g_return_val_if_fail (scg != NULL, FALSE);
	g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), FALSE);

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_save] : "), 9);
#	endif

	if (singit_config_gen_open(scg)) {
		gtk_signal_emit (GTK_OBJECT(scg), scg_signals[SAVE], scg->config_file, scg->config_data);
		result = singit_config_gen_close(scg, TRUE);
	}
#	ifdef CODEDEBUG
	if (result == TRUE) { DEBUG(("Ok\n"), 9); }
	else { DEBUG(("Failed\n"), 9); }
#	endif
	return result;
}

gpointer singit_config_gen_get_data(SingitConfigGen *scg)
{
	g_return_val_if_fail (scg != NULL, NULL);
	g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), NULL);

	return scg->config_data;
}
/*
gchar* singit_config_read_color (ConfigFile *cfg, const gchar *config_entry, const gchar *default_color)
{
	GdkColor color;
	gchar *temp = NULL;
	if (!(xmms_cfg_read_string(cfg, "SingIt", (gchar *) config_entry, &temp))) {
		temp = g_strdup(default_color);
	}
	else {
		if (!gdk_color_parse(temp, &color)) {
			g_free(temp);
			temp = g_strdup(default_color);
		}
	}
	return temp;
}
*/
gboolean singit_config_gen_read_color(ConfigFile *cfg, gchar *section, gchar *key, gchar **color_str)
{
	GdkColor color;
	gboolean result = FALSE;
	if (xmms_cfg_read_string(cfg, section, key, color_str))
	{
		result = gdk_color_parse(*color_str, &color);
		if (result == FALSE) {
			g_free(*color_str);
			*color_str = NULL;
		}
	}
	return result;
}

void singit_config_gen_emit_update(SingitConfigGen *scg)
{
	g_return_if_fail (scg != NULL);
	g_return_if_fail (IS_SINGIT_CONFIG_GEN (scg));

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_emit_update]\n"), 9);
#	endif

	gtk_signal_emit (GTK_OBJECT(scg), scg_signals[UPDATE]);
}

gboolean singit_config_gen_save_part(SingitConfigGen *scg, gint part)
{
	gboolean result = FALSE;

	g_return_val_if_fail (scg != NULL, FALSE);
	g_return_val_if_fail (IS_SINGIT_CONFIG_GEN (scg), FALSE);

#	ifdef CODEDEBUG
	DEBUG(("singit_config_gen.c [singit_config_gen_save_part] : "), 9);
#	endif

	if (singit_config_gen_open(scg)) {
		gtk_signal_emit (GTK_OBJECT(scg), scg_signals[SAVE_PART],
			scg->config_file, scg->config_data, part);
		result = singit_config_gen_close(scg, TRUE);
	}
#	ifdef CODEDEBUG
	if (result == TRUE) { DEBUG(("Ok\n"), 9); }
	else { DEBUG(("Failed\n"), 9); }
#	endif
	return result;
}