#include "kj.h"


/* ----------------------------------------------------------------------
 *  BMP loader stolen from the XMMS project.
 * ---------------------------------------------------------------------- */
typedef struct tagRGBQUAD
{
	guchar rgbBlue;
	guchar rgbGreen;
	guchar rgbRed;
	guchar rgbReserved;
}
RGBQUAD;

#define BI_RGB        0L
#define BI_RLE8       1L
#define BI_RLE4       2L
#define BI_BITFIELDS  3L

static GdkGC *bmp_gc = NULL;

/* ---------------------------------------------------------------------- */
int read_le_short(FILE * file, gushort * ret)
{
	guchar b[2];

	if (fread(b, sizeof (guchar), 2, file) != 2)
		return 0;

	*ret = (b[1] << 8) | b[0];
	return 1;
}


/* ---------------------------------------------------------------------- */
int read_le_long(FILE * file, gulong * ret)
{
	guchar b[4];

	if (fread(b, sizeof (guchar), 4, file) != 4)
		return 0;

	*ret = (b[3] << 24) | (b[2] << 16) | (b[1] << 8) | b[0];
	return 1;
}


/* ---------------------------------------------------------------------- */
/*
 * Imlib's bmp loader sucks big time so I think I'll hang on to this one
 * a while longer and just use imlib for rendering
 */
guchar *kj_read_bmp(gchar* filename, gulong *width, gulong *height, gulong *transp)
{
	FILE *file;
	gchar type[2];
	gulong size, offset, headSize, w, h, comp, imgsize, j, k, l;
	gushort tmpShort, planes, bitcount, ncols, skip;
	guchar *data, *data_end, byte = 0, g, t1 = 0, t2, b, r, *buffer, *buffer_end;
	struct stat statbuf;
	register guchar *ptr, *buffer_ptr;
	register gulong i;
	register gushort x, y;

	RGBQUAD rgbQuads[256];

	if (stat(filename, &statbuf) == -1)
		return NULL;
	size = statbuf.st_size;

	file = fopen(filename, "rb");
	if (!file)
		return NULL;

	if (fread(type, 1, 2, file) != 2)
	{
		fclose(file);
		return NULL;
	}
	if (strncmp(type, "BM", 2))
	{
		fprintf(stderr, "Error in BMP file `%s': wrong type\n", filename);
		fclose(file);
		return NULL;
	}
	fseek(file, 8, SEEK_CUR);
	read_le_long(file, &offset);
	read_le_long(file, &headSize);
	if (headSize == 12)
	{
		read_le_short(file, &tmpShort);
		w = tmpShort;
		read_le_short(file, &tmpShort);
		h = tmpShort;
		read_le_short(file, &planes);
		read_le_short(file, &bitcount);
		imgsize = size - offset;
		comp = BI_RGB;
	}
	else if (headSize == 40)
	{
		read_le_long(file, &w);
		read_le_long(file, &h);
		read_le_short(file, &planes);
		read_le_short(file, &bitcount);
		read_le_long(file, &comp);
		read_le_long(file, &imgsize);
		imgsize = size - offset;

		fseek(file, 16, SEEK_CUR);
	}
	else
	{
		fprintf(stderr, "Error in BMP file `%s': Unknown header size\n", filename);
		fclose(file);
		return NULL;
	}
	if (bitcount != 24)
	{
		ncols = (offset - headSize - 14);
		if (headSize == 12)
		{
			ncols /= 3;
			for (i = 0; i < ncols; i++)
			{
				fread(&rgbQuads[i], 3, 1, file);
			}
		}
		else
		{
			ncols /= 4;
			fread(rgbQuads, 4, ncols, file);
		}
	}
	fseek(file, offset, SEEK_SET);
	buffer = g_malloc(imgsize);
	fread(buffer, imgsize, 1, file);
	fclose(file);
	buffer_ptr = buffer;
	buffer_end = buffer + imgsize;
	data = (guchar *) g_malloc0((w * 3 * h) + 3);	/* +3 is just for safety */
	data_end = data + (w * 3 * h);
	if (!data)
	{
		fprintf(stderr, "Error reading `%s': Couldn't alloc memory for RGB data\n", filename);
		fclose(file);
		return NULL;
	}
	ptr = data + ((h - 1) * w * 3);
	if (bitcount == 4)
	{
		if (comp == BI_RLE4)
		{
			x = 0;
			y = 0;
			for (i = 0, g = 1; i < imgsize && g && buffer_ptr < buffer_end; i++)
			{
				byte = *(buffer_ptr++);
				if (byte)
				{
					guchar t1, t2;

					l = byte;
					byte = *(buffer_ptr++);
					t1 = byte & 0xF;
					t2 = (byte >> 4) & 0xF;
					for (j = 0; j < l; j++)
					{
						k = (j & 1) ? t1 : t2;

						if (x >= w)
							break;

						r = rgbQuads[k].rgbRed;
						g = rgbQuads[k].rgbGreen;
						b = rgbQuads[k].rgbBlue;
						if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
						*ptr++ = r;
						*ptr++ = g;
						*ptr++ = b;
						x++;
						if (ptr > data_end)
							ptr = data_end;

					}
				}
				else
				{
					byte = *(buffer_ptr++);
					switch (byte)
					{
						case 0:
							x = 0;
							y++;
							ptr = data + ((h - y - 1) * w * 3) + (x * 3);
							if (ptr > data_end)
								ptr = data_end;
							break;
						case 1:
							g = 0;
							break;
						case 2:
							x += *(buffer_ptr++);
							y += *(buffer_ptr++);
							ptr = data + ((h - y - 1) * w * 3) + (x * 3);
							if (ptr > data_end)
								ptr = data_end;
							break;
						default:
							l = byte;
							for (j = 0; j < l; j++)
							{
								if ((j & 1) == 0)
								{
									byte = *(buffer_ptr++);
									t1 = byte & 0xF;
									t2 = (byte >> 4) & 0xF;
								}
								k = (j & 1) ? t1 : t2;

								if (x >= w)
								{
									buffer_ptr += (l - j) / 2;
									break;
								}

								r = rgbQuads[k].rgbRed;
								g = rgbQuads[k].rgbGreen;
								b = rgbQuads[k].rgbBlue;
								if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
								*ptr++ = r;
								*ptr++ = g;
								*ptr++ = b;

								x++;

								if (ptr > data_end)
									ptr = data_end;

							}

							if ((l & 3) == 1)
							{
								buffer_ptr++;
								buffer_ptr++;
							}
							else if ((l & 3) == 2)
								buffer_ptr++;
							break;
					}
				}
			}
		}
		else if (comp == BI_RGB)
		{
			skip = ((((w + 7) / 8) * 8) - w) / 2;
			for (y = 0; y < h; y++)
			{
				for (x = 0; x < w && buffer_ptr < buffer_end; x++)
				{
					if ((x & 1) == 0)
					{
						byte = *(buffer_ptr++);
					}
					k = (byte & 0xF0) >> 4;
					r = rgbQuads[k].rgbRed;
					g = rgbQuads[k].rgbGreen;
					b = rgbQuads[k].rgbBlue;
					if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
					*ptr++ = r;
					*ptr++ = g;
					*ptr++ = b;
					byte <<= 4;
				}
				buffer_ptr += skip;
				ptr -= w * 6;
			}
		}
	}
	if (bitcount == 8)
	{
		if (comp == BI_RLE8)
		{
			x = 0;
			y = 0;
			for (i = 0, g = 1; i < imgsize && buffer_ptr < buffer_end && g; i++)
			{
				byte = *(buffer_ptr++);
				if (byte)
				{
					l = byte;
					byte = *(buffer_ptr++);
					for (j = 0; j < l; j++)
					{
						if (x >= w)
							break;

						r = rgbQuads[byte].rgbRed;
						g = rgbQuads[byte].rgbGreen;
						b = rgbQuads[byte].rgbBlue;
						if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
						*ptr++ = r;
						*ptr++ = g;
						*ptr++ = b;
						x++;
						if (ptr > data_end)
							ptr = data_end;
					}
				}
				else
				{
					byte = *(buffer_ptr++);
					switch (byte)
					{
						case 0:
							x = 0;
							y++;
							ptr = data + ((h - y - 1) * w * 3) + (x * 3);
							if (ptr > data_end)
								ptr = data_end;
							break;
						case 1:
							g = 0;
							break;
						case 2:
							x += *(buffer_ptr++);
							y += *(buffer_ptr++);
							ptr = data + ((h - y - 1) * w * 3) + (x * 3);
							if (ptr > data_end)
								ptr = data_end;
							break;
						default:
							l = byte;
							for (j = 0; j < l; j++)
							{
								byte = *(buffer_ptr++);

								if (x >= w)
								{
									buffer_ptr += l - j;
									break;
								}

								r = rgbQuads[byte].rgbRed;
								g = rgbQuads[byte].rgbGreen;
								b = rgbQuads[byte].rgbBlue;
								if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
								*ptr++ = r;
								*ptr++ = g;
								*ptr++ = b;
								x++;

								if (ptr > data_end)
									ptr = data_end;
							}
							if (l & 1)
								buffer_ptr++;
							break;
					}
				}
			}
		}
		else if (comp == BI_RGB)
		{
			skip = (((w + 3) / 4) * 4) - w;
			for (y = 0; y < h; y++)
			{
				for (x = 0; x < w && buffer_ptr < buffer_end; x++)
				{
					byte = *(buffer_ptr++);
					r = rgbQuads[byte].rgbRed;
					g = rgbQuads[byte].rgbGreen;
					b = rgbQuads[byte].rgbBlue;
					if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
					*ptr++ = r;
					*ptr++ = g;
					*ptr++ = b;
				}
				ptr -= w * 6;
				buffer_ptr += skip;
			}
		}

	}
	else if (bitcount == 24)
	{
		skip = (4 - ((w * 3) % 4)) & 3;
		for (y = 0; y < h; y++)
		{
			for (x = 0; x < w && buffer_ptr < buffer_end; x++)
			{
				b = *(buffer_ptr++);
				g = *(buffer_ptr++);
				r = *(buffer_ptr++);
				if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
				*ptr++ = r;
				*ptr++ = g;
				*ptr++ = b;
			}
			ptr -= w * 6;
			buffer_ptr += skip;
		}
	}

	g_free(buffer);

	*width = w;
	*height = h;
	return data;
}


/* ----------------------------------------------------------------------
 *  Mostly stolen from Imglib.  Maybe should link Imglib instead of png.
 * ---------------------------------------------------------------------- */
#if HAVE_LIBPNG
#include <png.h>

guchar *read_png(gchar* filename, gulong *width, gulong *height, gulong *transp)
{
FILE *fp;
png_structp png_ptr;
png_infop info_ptr;
unsigned char *data, *ptr, **lines, *ptr2, r, g, b, a;
int i, x, y, bit_depth, color_type, interlace_type;
png_uint_32 ww, hh;

	if((fp = fopen(filename, "rb")) == NULL)
		{
		printf("Error opening PNG file `%s'\n", filename);
		return NULL;
		}

	if(!(png_ptr = png_create_read_struct(PNG_LIBPNG_VER_STRING, NULL, NULL, NULL))) { fclose(fp); return NULL; }
	if(!(info_ptr = png_create_info_struct(png_ptr)))
		{
		png_destroy_read_struct(&png_ptr, NULL, NULL);
		fclose(fp);
		return NULL;
		}
	if(setjmp(png_ptr->jmpbuf))
		{
		png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
		fclose(fp);
		return NULL;
		}
	if(info_ptr->color_type == PNG_COLOR_TYPE_RGB_ALPHA)
		{
		png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
		fclose(fp);
		return NULL;
		}
	png_init_io(png_ptr, fp);

		/* Read Header */
	png_read_info(png_ptr, info_ptr);
	png_get_IHDR(png_ptr, info_ptr, &ww, &hh, &bit_depth, &color_type, &interlace_type, NULL, NULL);

	*width = ww;
	*height = hh;
	*transp = 0;

	if(!(data = malloc(*width * *height * 3)))
		{
		png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
		fclose(fp);
		return NULL;
		}

		/* Setup Translators */
	if(color_type == PNG_COLOR_TYPE_PALETTE) png_set_expand(png_ptr);
	png_set_strip_16(png_ptr);
	png_set_packing(png_ptr);
	if(png_get_valid(png_ptr, info_ptr, PNG_INFO_tRNS)) png_set_expand(png_ptr);
	png_set_filler(png_ptr, 0xff, PNG_FILLER_AFTER);
	if((lines = (unsigned char **)malloc(*height * sizeof(unsigned char *))) == NULL)
		{
		free(data);
		png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
		fclose(fp);
		return NULL;
		}
	
	for(i = 0; i < *height; i++)
		{
		if((lines[i] = malloc(*width * (sizeof(unsigned char) * 4))) == NULL)
			{
			int n;
			free(data);
			for(n = 0; n < i; n++) free(lines[n]);
			free(lines);
			png_destroy_read_struct(&png_ptr, &info_ptr, NULL);
			fclose(fp);
			return NULL;
			}
		}

	png_read_image(png_ptr, lines);
	png_destroy_read_struct(&png_ptr, &info_ptr, NULL);

	ptr = data;
	if(color_type == PNG_COLOR_TYPE_GRAY_ALPHA)
		{
		for(y = 0; y < *height; y++)
			{
			ptr2 = lines[y];
			for(x = 0; x < *width; x++)
				{
				r = *ptr2++;
				a = *ptr2++;
				if(a < 128)
					{
					*ptr++ = 255;
					*ptr++ = 0;
					*ptr++ = 255;
					*transp = 1;
					}
				else
					{
					*ptr++ = r;
					*ptr++ = r;
					*ptr++ = r;
					}
				}
			}
		}
	else if(color_type == PNG_COLOR_TYPE_GRAY)
		{
		for(y = 0; y < *height; y++)
			{
			ptr2 = lines[y];
			for(x = 0; x < *width; x++)
				{
				r = *ptr2++;
				*ptr++ = r;
				*ptr++ = r;
				*ptr++ = r;
				}
			}
		}
	else
		{
		for(y = 0; y < *height; y++)
			{
			ptr2 = lines[y];
			for(x = 0; x < *width; x++)
				{
				r = *ptr2++;
				g = *ptr2++;
				b = *ptr2++;
				a = *ptr2++;
				if(a < 128)
					{
					*ptr++ = 255;
					*ptr++ = 0;
					*ptr++ = 255;
					*transp = 1;
					}
				else
					{
					// if((r == 255) && (g == 0) && (b == 255)) r = 254;
					if((r == 255) && (g == 0) && (b == 255)) *transp = 1;
					*ptr++ = r;
					*ptr++ = g;
					*ptr++ = b;
					}
				}
			}
		}
	for (i = 0; i < *height; i++) free(lines[i]);
	free(lines);
	fclose(fp);
	return data;
}

#endif



/* ---------------------------------------------------------------------- */
guchar *read_image_file(gchar* filename, gulong *width, gulong *height, gulong *transp)
{
char *ending;

	ending = strrchr(filename, '.');
	if(ending)
		{
		if(!strcasecmp(ending, ".bmp")) return kj_read_bmp(filename, width, height, transp);
		else if(!strcasecmp(ending, ".png"))
			{
#if HAVE_LIBPNG
			return read_png(filename, width, height, transp);
#else
			printf("ERROR: no PNG file support linked.\n");
			return NULL;
#endif
			}
		}

	return NULL;
}


/* ---------------------------------------------------------------------- */
GdkBitmap *generate_mask(k_image *img, gulong trans)
{
GdkBitmap *mask;
GdkGC *mask_gc;
GdkColor c;
int x, y;

	mask = gdk_pixmap_new(root_window, img->width, img->height, 1);
	mask_gc = gdk_gc_new(mask);

	c.pixel = 1;
	gdk_gc_set_foreground(mask_gc, &c);
	gdk_draw_rectangle(mask, mask_gc, TRUE, 0, 0, -1, -1);

	c.pixel = 0;
	gdk_gc_set_foreground(mask_gc, &c);
	for(y = 0; y < img->height; y++)
		for(x = 0; x < img->width; x++)
			{
			if(kj_get_pixel(img, x, y) == trans)
				gdk_draw_point(mask, mask_gc, x, y);
			}

	gdk_gc_destroy(mask_gc);
	return mask;
}


/* ---------------------------------------------------------------------- */
void kj_mask_colour(k_image *img, gulong trans)
{
	if(img->mask) gdk_bitmap_unref(img->mask);
	img->mask = generate_mask(img, trans);
}


/* ---------------------------------------------------------------------- */
gulong kj_get_pixel(k_image *img, gint x, gint y)
{
guchar *ptr;
gulong pixel;

	if(!img || !img->data) return -1;
	ptr = img->data + (y * img->width * 3) + x * 3;
	pixel = ((*ptr++) << 16);
	pixel |= ((*ptr++) << 8);
	pixel |= (*ptr++);

	return pixel;
}


/* ----------------------------------------------------------------------
 *  pixmap: 0 - don't create pixmap.
 *          1 - create pixmap and keep raw image.
 *          2 - create pixmap and free raw image.
 */
k_image *kj_read_image(gchar *filename, int pixmap)
{
k_image *img;
gulong w, h, t;

	if((img = g_malloc(sizeof(k_image))) == NULL) return NULL;
	if((img->data = read_image_file(filename, &w, &h, &t)) == NULL) return NULL;
	img->width = w;
	img->height = h;
	img->pix = NULL;
	img->mask = NULL;

	if(pixmap)
		{
		img->pix = gdk_pixmap_new(root_window, w, h, gdk_visual_get_best_depth());
		if(!bmp_gc) bmp_gc = gdk_gc_new(root_window);
		gdk_draw_rgb_image(img->pix, bmp_gc, 0, 0, w, h, GDK_RGB_DITHER_MAX, img->data, w * 3);
		if(t) img->mask = generate_mask(img, 0xff00ff);
		else img->mask = NULL;
		if(pixmap == 2)
			{
			g_free(img->data);
			img->data = NULL;
			}
		}

	return img;
}


/* ---------------------------------------------------------------------- */
void kj_free_image(k_image *img)
{
	if(img)
		{
		if(img->data) g_free(img->data);
		if(img->pix) gdk_pixmap_unref(img->pix);
		if(img->mask) gdk_bitmap_unref(img->mask);
		g_free(img);
		}
}

