/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2000  Peter Alm, Mikael Alm, Olle Hallnas, Thomas Nilsson and 4Front Technologies
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "jack.h"
#include <xmms/configfile.h>

JACKConfig jackxmms_cfg;

void jackxmms_init(void)
{
	ConfigFile *cfgfile;

	memset(&jackxmms_cfg, 0, sizeof (JACKConfig));

	jackxmms_cfg.audio_device = 0;
	jackxmms_cfg.mixer_device = 0;
	jackxmms_cfg.buffer_size = 3000;
	jackxmms_cfg.prebuffer = 25;
	jackxmms_cfg.use_alt_audio_device = FALSE;
	jackxmms_cfg.alt_audio_device = NULL;
	jackxmms_cfg.use_master=0;
	
	if ((cfgfile = xmms_cfg_open_default_file()))
	{
		xmms_cfg_read_int(cfgfile, "JACK", "audio_device", &jackxmms_cfg.audio_device);
		xmms_cfg_read_int(cfgfile, "JACK", "mixer_device", &jackxmms_cfg.mixer_device);
		xmms_cfg_read_int(cfgfile, "JACK", "buffer_size", &jackxmms_cfg.buffer_size);
		xmms_cfg_read_int(cfgfile, "JACK", "prebuffer", &jackxmms_cfg.prebuffer);
		xmms_cfg_read_boolean(cfgfile, "JACK", "use_master", &jackxmms_cfg.use_master);
		xmms_cfg_read_boolean(cfgfile, "JACK", "use_alt_audio_device", &jackxmms_cfg.use_alt_audio_device);
		xmms_cfg_read_string(cfgfile, "JACK", "alt_audio_device", &jackxmms_cfg.alt_audio_device);
		xmms_cfg_read_boolean(cfgfile, "JACK", "use_alt_mixer_device", &jackxmms_cfg.use_alt_mixer_device);
		xmms_cfg_read_string(cfgfile, "JACK", "alt_mixer_device", &jackxmms_cfg.alt_mixer_device);
		xmms_cfg_free(cfgfile);
	}
}
