//	includes
#include <stdio.h>
#include "iTunesVisualAPI.h"
#include "iTunesAPI.h"
#include "goom_core.h"
#include <CoreFoundation/CoreFoundation.h>

//*****************************************************
#include <stdlib.h>
#include <string.h>
//*****************************************************

CFStringRef CFBundleIdentifier;

extern void ppc_doubling(unsigned int,UInt32 *,UInt32 *,UInt32 *,UInt32,UInt32);

//	typedef's, struct's, enum's, etc.
#define kTVisualPluginName		"\piGoom"
#define	kTVisualPluginCreator		'gyom'
#define	kTVisualPluginMajorVersion	1
#define	kTVisualPluginMinorVersion	99
#define	kTVisualPluginReleaseStage	alphaStage
#define	kTVisualPluginNonFinalRelease	0

// Defines the number of frames the interface is drawn.
#define interfaceTime			200

//#define Timers


enum
{
        kColorSettingID = 3,
        kOKSettingID = 5,
        kInputTypeID = 6
};

typedef struct VisualPluginData {
	void *			appCookie;
	ITAppProcPtr		appProc;

	ITFileSpec		pluginFileSpec;

	CGrafPtr		destPort;
	Rect			destRect;
	OptionBits		destOptions;
	UInt32			destBitDepth;

	ITTrackInfo		trackInfo;
	ITStreamInfo		streamInfo;

	Boolean			playing;

//	Plugin-specific data
	GWorldPtr		offscreen;
        signed short 		data[2][512];
} VisualPluginData;


//	local (static) globals
static Boolean	doublePixels = true;
static unsigned short	useSpectrum = 0;
static CGrafPtr	gSavePort;
static GDHandle	gSaveDevice;
static int	interfaceFeedBack = interfaceTime;
static float	sensitivity = 1.2;
//#ifdef Timers
AbsoluteTime	backUpTime;
//#endif
unsigned char	changeRes = FALSE;
unsigned int	oldx = 0, oldy = 0;
unsigned int	useAltivec = false;
signed int	forced = 0;
unsigned int    showFPS = 0;
static int	showTexte = 0, showTitle = 1;
FILE		*prefFile;
CGContextRef zeCGContext;
static int test = 0;

//	exported function prototypes
extern OSStatus iTunesPluginMainMachO(OSType message,PluginMessageInfo *messageInfo,void *refCon);

// Calcul de diff de temps
#ifdef Timers
static void HowLong(const char* text);
#endif

//	MemClear
inline static void MemClear(LogicalAddress dest,SInt32 length)
{
	unsigned char	*ptr = (unsigned char*) dest;
	while (length-- > 0) *ptr++ = 0;
}

static void HowLong(const char* text)
{
#ifdef Timers
    AbsoluteTime absTime;
    Nanoseconds nanosec;
    
    absTime = SubAbsoluteFromAbsolute(UpTime(), backUpTime);
    nanosec = AbsoluteToNanoseconds(absTime);
    fprintf(stderr,"Time for %s:  %f\n", text, (float) UnsignedWideToUInt64( nanosec ) / 1000000.0);
    backUpTime = UpTime();
#endif
}

// ProcessRenderData --> preprocessing des donnees en entre
static void ProcessRenderData(VisualPluginData *visualPluginData,const RenderVisualData *renderData)
{
	SInt16		index;
	SInt32		channel;
	register float c = 127.*sensitivity;
        
	if (renderData == nil)
	{
		MemClear(&visualPluginData->data,sizeof(visualPluginData->data));
		return;
	}

        if (useSpectrum == 1)
        {
            for (channel = 0;channel < 2;channel++)
            {
                    for (index = 0; index < 512; index++)
                        visualPluginData->data[channel][index] = ((renderData->spectrumData[channel][index]-127) * c);
             }
        }
        else
        {
            for (channel = 0;channel < 2;channel++)
            {
                    for (index = 0; index < 512; index++)
                        visualPluginData->data[channel][index] = ((renderData->waveformData[channel][index]-127) * c);
            }
        }
}

// GetPortCopyBitsBitMap
//
static BitMap* GetPortCopyBitsBitMap(CGrafPtr port)
{
	BitMap*		destBMap;

#if ACCESSOR_CALLS_ARE_FUNCTIONS
	destBMap = (BitMap*)GetPortBitMapForCopyBits(port);
#else
  #if OPAQUE_TOOLBOX_STRUCTS
	PixMapHandle	pixMap;
	
	pixMap		= GetPortPixMap(port);
	destBMap	= (BitMap*) (*pixMap);
  #else
	destBMap	= (BitMap*) &((GrafPtr)port)->portBits;
  #endif
#endif
	return destBMap;
}

//	RenderVisualPort
/*	OK, This is pretty weird : if we are not in pixel doubling mode, the goom internal buffer is copied on destPort via CopyBits(). Now, if we are in pixel doubling mode : if we are full screen, the goom internal buffer is copied on another buffer with ppc_doubling() and then to destPort with CopyBits().*/

char * Str255ToC(Str255 source)
{
    static char dst[255];
    char * cur = dst, * src = (char*)source;
    int i;
    int size = *src;
    src++;
    for (i=0; i<size; i++)
    {
        *cur = *src;
        switch (*cur)
        {
            case '' :
                *cur = 'A';
                break;
            case '' :
            case '' :
            case '' :
            case '' :
                *cur = 'a';
                break;
            case '' :
            case '' :
            case '' :
                *cur = 'E';
                break;
            case '' :
            case '' :
            case '' :
            case '' :
                *cur = 'e';
                break;
            case '' :
            case '' :
            case '' :
            case '' :
                *cur = 'i';
                break;
            case '' :
                *cur = 'n';
                break;
            case '' :
                *cur = 'c';
                break;
            case '' :
            case '' :
            case '' :
            case '' :
                *cur = 'o';
                break;
            case '' :
            case '' :
            case '' :
            case '' :
                *cur = 'u';
                break;
            default : break;
        }
        src++;
        cur++;
    }
    *cur = 0;
    return dst;
}

static void RenderVisualPort(VisualPluginData *visualPluginData,CGrafPtr destPort,const Rect *destRect,Boolean onlyUpdate)
{
	BitMap*		srcBitMap;
	BitMap*		dstBitMap;
        unsigned int 	right, bottom;
        static float	fpssampler = 0;
        int	fullscreen;
	GWorldPtr	offscreen;
        PixMapHandle	pixMapHdl = GetGWorldPixMap(visualPluginData->offscreen);
        static char textBuffer[15];
        static char titleBuffer[256];
        Point pt = {0,0};
	Rect		srcRect= *destRect;
 	Rect		dstRect = srcRect;

        AbsoluteTime absTime;
        Nanoseconds nanosec;
        
        LocalToGlobal(&pt);
        fullscreen = (pt.v == 0);

        if ((nil == destPort) || (nil == destRect) || (nil == visualPluginData->offscreen)) return;
        
        absTime = SubAbsoluteFromAbsolute(UpTime(), backUpTime);
        nanosec = AbsoluteToNanoseconds(absTime);
        fpssampler = 1000000000.0 / (float) UnsignedWideToUInt64( nanosec );
        if (fpssampler>35) return;
        backUpTime = UpTime();
        
     
	GetGWorld(&gSavePort,&gSaveDevice);
 	SetGWorld(destPort,nil);

	srcBitMap	= GetPortCopyBitsBitMap(visualPluginData->offscreen);
	dstBitMap	= GetPortCopyBitsBitMap(destPort);

        OffsetRect(&srcRect,-srcRect.left,-srcRect.top);
        if (!pixMapHdl || !*pixMapHdl) return;
        
        right = srcRect.right;
        bottom = srcRect.bottom;
//        if ((right<100) || (bottom<100)) return;

        // Update our offscreen pixmap
        if ((changeRes) || (oldx != right) || (oldy != bottom))
        {
            if (doublePixels)
                    goom_set_resolution (right%2 + right/2,  bottom/2 + bottom%2,NULL);
            else
                    goom_set_resolution (right, bottom,NULL);
            oldx = right;
            oldy = bottom;
            changeRes = FALSE;
        }


        //fprintf(stderr,"%d ",test);


        if (showTexte == 0)
        {
            sprintf(textBuffer,"The iGoom %s", useAltivec?"G4":"G3");
        }

        //fprintf(stderr,"local : %s iTunes : %s\n", titleBuffer, Str255ToC(visualPluginData->trackInfo.name));

        if (showTitle == 0) //(strcmp(titleBuffer, Str255ToC(visualPluginData->trackInfo.name))!=0)
        {
            //showTitle = 0;
            //fprintf(stderr,"* local : %s iTunes : %s\n", titleBuffer, Str255ToC(visualPluginData->trackInfo.name));
            strcpy(titleBuffer, Str255ToC(visualPluginData->trackInfo.name));
            //if (strcmp(titleBuffer, Str255ToC(visualPluginData->trackInfo.name))!=0) fprintf(stderr,"copy failed\n");
            if (strcmp(textBuffer, "") != 0)
            {
                showTexte = 0;
                strcpy(textBuffer,"");
            }
        }
         
        /*
        if (test==150)
        {
            sprintf(textBuffer,"Sensitivity \"<\" and \">\" : %.1f", sensitivity-1);
            showTexte = 1;
        }
        if (test==300)
        {
            sprintf(textBuffer,"Quality \"Q\" : %s", doublePixels?"Quick":"Smooth");
            showTexte = 1;
        }
*/
        test++;

        if (doublePixels)
        {
            UInt32 rowBytes = (GetPixRowBytes(pixMapHdl))>>2;
            register UInt32 *myX = (UInt32*) GetPixBaseAddr(pixMapHdl);
            register UInt32 inc = 2*rowBytes - right - right%2;
            register UInt32 *myx = (UInt32*)  goom_update (visualPluginData->data,forced,(showFPS > 0)?fpssampler:-1,(showTitle==0)?titleBuffer:NULL,(showTexte==0)?textBuffer:NULL);

            ppc_doubling(right/2 + right%2, myx, myX, myX + rowBytes, bottom/2,inc*4);
            srcBitMap = GetPortCopyBitsBitMap(visualPluginData->offscreen);
        }
        else
        {
            NewGWorldFromPtr(&offscreen, k32ARGBPixelFormat,&srcRect, NULL, NULL, 0, (Ptr) goom_update (visualPluginData->data,forced, (showFPS > 0)?fpssampler:-1, (showTitle==0)?titleBuffer:NULL,(showTexte==0)?textBuffer:NULL), right*4);
            HowLong("Goom");
            SetGWorld(destPort,nil);
            srcBitMap = GetPortCopyBitsBitMap(offscreen);
            CopyBits(srcBitMap,dstBitMap,&srcRect,&dstRect,srcCopy,nil);
	    DisposeGWorld(offscreen);
	}
        showTexte = 1;
        showTitle = 1;


        if (doublePixels) SetGWorld(visualPluginData->offscreen,nil);
        /*
	if ((--interfaceFeedBack > 0) && ((fullscreen == 0) || (doublePixels)))
        {
            PenState oldPen,newPen;
            
            GetPenState (&oldPen);
            GetPenState (&newPen);

            TextMode (srcXor);

            newPen.pnLoc.h = 20 + dstRect.left*!doublePixels;
            newPen.pnLoc.v = 25 + dstRect.top*!doublePixels;
            SetPenState (&newPen);
	    sprintf(textBuffer,"The iGoom Effect (%d FPS / %s)",(int)fpssampler, useAltivec ? "G4" : "G3");
	    DrawText (textBuffer, 0, strlen(textBuffer));
            
            if (bottom < 100)
            {
                if (doublePixels)
                {
                    SetGWorld(destPort,nil);
                    CopyBits(srcBitMap,dstBitMap,&srcRect,&dstRect,srcCopy,nil);
                }
                SetPenState (&oldPen);
            	SetGWorld(gSavePort,gSaveDevice);
                return;
            }
            newPen.pnLoc.h = 20 + dstRect.left*!doublePixels;
            newPen.pnLoc.v += 20;
            SetPenState (&newPen);
            sprintf(textBuffer,"Sensitivity \"<\" and \">\" : %.1f",sensitivity-1);
            DrawText (textBuffer, 0, strlen(textBuffer));
            newPen.pnLoc.h = 20 + dstRect.left*!doublePixels;
            newPen.pnLoc.v += 20;
            SetPenState (&newPen);
            sprintf(textBuffer,"Quality \"Q\" : %s",doublePixels?"Quick":"Smooth");
            DrawText (textBuffer, 0, strlen(textBuffer));

            SetPenState (&oldPen);
        }
*/
        if (doublePixels)
        {
            SetGWorld(destPort,nil);
            CopyBits(srcBitMap,dstBitMap,&srcRect,&dstRect,srcCopy,nil);
        }

	SetGWorld(gSavePort,gSaveDevice);
	if (forced>0) forced = -1;
}


/*	AllocateVisualData is where you should allocate any information that depends
	on the port or rect changing (like offscreen GWorlds). */
static OSStatus AllocateVisualData(VisualPluginData *visualPluginData,CGrafPtr destPort,const Rect *destRect)
{
	OSStatus		status;
	Rect			allocateRect;
/*
	CreateCGContextForPort(destPort,&zeCGContext);
	//GetPortBounds(destPort,&rect);
	CGContextTranslateCTM(zeCGContext, (float)destRect->left, (float)(destRect->bottom - destRect->top));
	//CGContextScaleCTM (zeCGContext, 1, -1);
*/
	
	(void) destPort;

	GetGWorld(&gSavePort,&gSaveDevice);
	
	allocateRect = *destRect;
	OffsetRect(&allocateRect,-allocateRect.left,-allocateRect.top);
				
	status = NewGWorld(&visualPluginData->offscreen,32,&allocateRect,nil,nil,useTempMem);
	if (status == noErr)
	{
		PixMapHandle	pix = GetGWorldPixMap(visualPluginData->offscreen);
		LockPixels(pix);

		// Offscreen starts out black
		SetGWorld(visualPluginData->offscreen,nil);
		ForeColor(blackColor);
		PaintRect(&allocateRect);
	}
	SetGWorld(gSavePort,gSaveDevice);
	return status;
}

//	DeallocateVisualData is where you should deallocate the .
static void DeallocateVisualData(VisualPluginData *visualPluginData)
{
	if (visualPluginData->offscreen != nil)
	{
		DisposeGWorld(visualPluginData->offscreen);
		visualPluginData->offscreen = nil;
	}
    CFPreferencesAppSynchronize(CFBundleIdentifier);
}

// ChangeVisualPort
static OSStatus ChangeVisualPort(VisualPluginData *visualPluginData,CGrafPtr destPort,const Rect *destRect)
{
	OSStatus		status;
	Boolean			doAllocate;
	Boolean			doDeallocate;
	
	status = noErr;
	
	doAllocate	= false;
	doDeallocate	= false;
		
	if (destPort != nil)
	{
		if (visualPluginData->destPort != nil)
		{
			if (false == EqualRect(destRect,&visualPluginData->destRect))
			{
				doDeallocate	= true;
				doAllocate	= true;
			}
		}
		else
		{
			doAllocate = true;
		}
	}
	else
	{
		doDeallocate = true;
	}
	
	if (doDeallocate)
		DeallocateVisualData(visualPluginData);
	
	if (doAllocate)
		status = AllocateVisualData(visualPluginData,destPort,destRect);

	if (status != noErr)
		destPort = nil;

	visualPluginData->destPort = destPort;
	if (destRect != nil)
		visualPluginData->destRect = *destRect;

	return status;
}

//	ResetRenderData
static void ResetRenderData(VisualPluginData *visualPluginData)
{
	MemClear(&visualPluginData->data,sizeof(visualPluginData->data));
}

//	settingsControlHandler
pascal OSStatus settingsControlHandler(EventHandlerCallRef inRef,EventRef inEvent, void* userData)
{
    WindowRef wind=NULL;
    ControlID controlID;
    ControlRef control=NULL;
    //get control hit by event
    GetEventParameter(inEvent,kEventParamDirectObject,typeControlRef,NULL,sizeof(ControlRef),NULL,&control);
    wind=GetControlOwner(control);
    GetControlID(control,&controlID);
    switch(controlID.id){
        case kColorSettingID:
                doublePixels=GetControlValue(control);
	    CFPreferencesSetAppValue (CFSTR("iGoomPixelDoubling"),doublePixels?CFSTR("YES"):CFSTR("NO"),CFBundleIdentifier);
	        //CFPreferencesAppSynchronize(CFBundleIdentifier);
	    
	    
                changeRes = TRUE;
                break;
        case kInputTypeID:
                useSpectrum = GetControlValue( control )-1;
                break;
        case kOKSettingID:
                HideWindow(wind);
                break;
    }
    return noErr;
}

//	VisualPluginHandler
static OSStatus VisualPluginHandler(OSType message,VisualPluginMessageInfo *messageInfo,void *refCon)
{
	OSStatus		status;
	VisualPluginData *	visualPluginData;

	visualPluginData = (VisualPluginData*) refCon;
	
	status = noErr;

	switch (message)
	{
		//	Sent when the visual plugin is registered.  The plugin should do minimal
		//	memory allocations here.  The resource fork of the plugin is still available.		
		case kVisualPluginInitMessage:
		{
			visualPluginData = (VisualPluginData*) NewPtrClear(sizeof(VisualPluginData));
			if (visualPluginData == nil)
			{
				status = memFullErr;
				break;
			}
			visualPluginData->appCookie = messageInfo->u.initMessage.appCookie;
			visualPluginData->appProc   = messageInfo->u.initMessage.appProc;
			// Remember the file spec of our plugin file.
                        // We need this so we can open our resource fork during
			// the configuration message
			
			status = PlayerGetPluginFileSpec(visualPluginData->appCookie, visualPluginData->appProc, &visualPluginData->pluginFileSpec);
			messageInfo->u.initMessage.refCon	= (void*) visualPluginData;
			break;
		}
			
		//	Sent when the visual plugin is unloaded
		case kVisualPluginCleanupMessage:
			if (visualPluginData != nil)
				DisposePtr((Ptr)visualPluginData);
			break;
			
		//	Sent when the visual plugin is enabled.  iTunes currently enables all
		//	loaded visual plugins.  The plugin should not do anything here.
		case kVisualPluginEnableMessage:
                    showTexte = 0;
                    showTitle = 1;
		case kVisualPluginDisableMessage:
			break;

		//	Sent if the plugin requests idle messages.  Do this by setting the kVisualWantsIdleMessages
		//	option in the RegisterVisualMessage.options field.
		case kVisualPluginIdleMessage:
			if (false == visualPluginData->playing)
                            RenderVisualPort(visualPluginData,visualPluginData->destPort,&visualPluginData->destRect,false);
			break;
					
		//	Sent if the plugin requests the ability for the user to configure it.  Do this by setting
		//	the kVisualWantsConfigure option in the RegisterVisualMessage.options field.
		case kVisualPluginConfigureMessage:
                       {
                            static EventTypeSpec controlEvent={kEventClassControl,kEventControlHit};
                            static const ControlID kColorSettingControlID={'cbox',kColorSettingID};
                            static const ControlID kInputTypeSettingControlID={'rbox',kInputTypeID};
                            static WindowRef settingsDialog=NULL;
                            static ControlRef color=NULL;
                            static ControlRef input=NULL;
                            if(settingsDialog==NULL){
                                IBNibRef 		nibRef;
                                //we have to find our bundle to load the nib inside of it
                                CFBundleRef iTunesXPlugin=CFBundleGetBundleWithIdentifier(CFSTR("iGoom"));
                                CreateNibReferenceWithCFBundle(iTunesXPlugin,CFSTR("SettingsDialog"), &nibRef);
                                CreateWindowFromNib(nibRef, CFSTR("PluginSettings"), &settingsDialog);
                                DisposeNibReference(nibRef);
                                InstallWindowEventHandler(settingsDialog,NewEventHandlerUPP(settingsControlHandler),
                                                    1,&controlEvent,0,NULL);
                                GetControlByID(settingsDialog,&kColorSettingControlID,&color);
                                GetControlByID(settingsDialog,&kInputTypeSettingControlID,&input);
                            }
                            SetControlValue(color,doublePixels);
                            SetControlValue(input,useSpectrum+1);
                            ShowWindow(settingsDialog);
                        }
                        break;

		//	Sent when iTunes is going to show the visual plugin in a port.  At
		//	this point,the plugin should allocate any large buffers it needs.
		case kVisualPluginShowWindowMessage:
                    showTexte = 0;
                    showTitle = 1;
			visualPluginData->destOptions = messageInfo->u.showWindowMessage.options;
			status = ChangeVisualPort( visualPluginData, messageInfo->u.showWindowMessage.port,
                                                                    &messageInfo->u.showWindowMessage.drawRect);
                        if (doublePixels)
                            goom_init ((visualPluginData->destRect.right-visualPluginData->destRect.left)/2, 1 + (visualPluginData->destRect.bottom-visualPluginData->destRect.top)/2,NULL);
                        else
                            goom_init (visualPluginData->destRect.right-visualPluginData->destRect.left, visualPluginData->destRect.bottom-visualPluginData->destRect.top,NULL);
                    goom_set_font(NULL,NULL,NULL);

			break;
		//	Sent when iTunes is no longer displayed.
		case kVisualPluginHideWindowMessage:
                        goom_close();
			(void) ChangeVisualPort(visualPluginData,nil,nil);

			MemClear(&visualPluginData->trackInfo,sizeof(visualPluginData->trackInfo));
			MemClear(&visualPluginData->streamInfo,sizeof(visualPluginData->streamInfo));
			break;
		
		//	Sent when iTunes needs to change the port or rectangle of the currently
		//	displayed visual.
		case kVisualPluginSetWindowMessage:
			visualPluginData->destOptions = messageInfo->u.setWindowMessage.options;
                        
			status = ChangeVisualPort(	visualPluginData,
										messageInfo->u.setWindowMessage.port,
										&messageInfo->u.setWindowMessage.drawRect);
			break;
		
		//	Sent for the visual plugin to render a frame.
		case kVisualPluginRenderMessage:
			ProcessRenderData(visualPluginData,messageInfo->u.renderMessage.renderData);
			RenderVisualPort(visualPluginData,visualPluginData->destPort,&visualPluginData->destRect,false);
			break;

		//	Sent in response to an update event.  The visual plugin should update
		//	into its remembered port.  This will only be sent if the plugin has been
		//	previously given a ShowWindow message.
		case kVisualPluginUpdateMessage:
			RenderVisualPort(visualPluginData,visualPluginData->destPort,&visualPluginData->destRect,true);
			break;
		
		//	Sent when the player starts.
		case kVisualPluginPlayMessage:
			if (messageInfo->u.playMessage.trackInfo != nil)
				visualPluginData->trackInfo = *messageInfo->u.playMessage.trackInfo;
			else
				MemClear(&visualPluginData->trackInfo,sizeof(visualPluginData->trackInfo));

			if (messageInfo->u.playMessage.streamInfo != nil)
				visualPluginData->streamInfo = *messageInfo->u.playMessage.streamInfo;
			else
				MemClear(&visualPluginData->streamInfo,sizeof(visualPluginData->streamInfo));
		
			visualPluginData->playing = true;
                        showTexte = 1;
                        showTitle = 0;
			break;

		//	Sent when the player changes the current track information.  This
		//	is used when the information about a track changes,or when the CD
		//	moves onto the next track.  The visual plugin should update any displayed
		//	information about the currently playing song.
		case kVisualPluginChangeTrackMessage:
			if (messageInfo->u.changeTrackMessage.trackInfo != nil)
				visualPluginData->trackInfo = *messageInfo->u.changeTrackMessage.trackInfo;
			else
				MemClear(&visualPluginData->trackInfo,sizeof(visualPluginData->trackInfo));

			if (messageInfo->u.changeTrackMessage.streamInfo != nil)
				visualPluginData->streamInfo = *messageInfo->u.changeTrackMessage.streamInfo;
			else
				MemClear(&visualPluginData->streamInfo,sizeof(visualPluginData->streamInfo));
                    showTexte = 1;
                    showTitle = 0;
			break;

		//	Sent when the player stops.
		case kVisualPluginStopMessage:
			visualPluginData->playing = false;
			ResetRenderData(visualPluginData);
			//RenderVisualPort(visualPluginData,visualPluginData->destPort,&visualPluginData->destRect,true);
                    showTexte = 0;
                    showTitle = 1;
			break;
		
		//	Sent when the player changes position.
		case kVisualPluginSetPositionMessage:
			break;

		//	Sent when the player pauses.  iTunes does not currently use pause or unpause.
		//	A pause in iTunes is handled by stopping and remembering the position.
		case kVisualPluginPauseMessage:
			visualPluginData->playing = false;
			ResetRenderData(visualPluginData);
			//RenderVisualPort(visualPluginData,visualPluginData->destPort,&visualPluginData->destRect,true);
			break;
			
		//	Sent when the player unpauses.  iTunes does not currently use pause or unpause.
		//	A pause in iTunes is handled by stopping and remembering the position.
		case kVisualPluginUnpauseMessage:
			visualPluginData->playing = true;
			break;
		
		//	Sent to the plugin in response to a MacOS event.  The plugin should return noErr
		//	for any event it handles completely,or an error (unimpErr) if iTunes should handle it.
		case kVisualPluginEventMessage:
			{
				EventRecord* tEventPtr = messageInfo->u.eventMessage.event;
				if ((tEventPtr->what == keyDown) || (tEventPtr->what == autoKey))
				{    // charCodeMask,keyCodeMask;
					char theChar = tEventPtr->message & charCodeMask;

					switch (theChar) // Process keys here
					{
					case	'q':
					case	'Q':
                                                doublePixels = (doublePixels==0)?1:0;
						CFPreferencesSetAppValue (CFSTR("iGoomPixelDoubling"),doublePixels?CFSTR("YES"):CFSTR("NO"),CFBundleIdentifier);
					    

                                                interfaceFeedBack = interfaceTime;
                                                changeRes = TRUE;
                                                break;
					case	'0':
					    forced = (forced == 0) ? -1 : 0;
					    interfaceFeedBack = interfaceTime;
					    break;
					case	'1':
					case	'2':
					case	'3':
					case	'4':
					case	'5':
					case	'6':
					case	'7':
					case	'8':
					    forced = theChar - '0';
					    interfaceFeedBack = interfaceTime;
					    break;
					case	'i':
					case	'I':
                                                interfaceFeedBack = interfaceTime;
                                                useSpectrum = (useSpectrum==0)?1:0;
                                                break;
					case	'f':
					case	'F':
					    showFPS = (showFPS==0)?1:0;
                                            CFPreferencesSetAppValue (CFSTR("iGoomShowFPS"),showFPS?CFSTR("YES"):CFSTR("NO"),CFBundleIdentifier);
					    break;
					case	'<':
                                                interfaceFeedBack = interfaceTime;
                                                sensitivity-=0.1;
                                                break;
					case	'>':
                                                interfaceFeedBack = interfaceTime;
                                                sensitivity+=0.1;
                                                break;
					case	'\r':
					case	'\n':
                                                interfaceFeedBack = interfaceTime;
                                                break;
					default:
						status = unimpErr;
						break;
					}
				}
				else
					status = unimpErr;
			}
			break;

		default:
			status = unimpErr;
			break;
	}
	return status;	
}

//	RegisterVisualPlugin
static OSStatus RegisterVisualPlugin(PluginMessageInfo *messageInfo)
{
	OSStatus		status;
	PlayerMessageInfo	playerMessageInfo;
	Str255			pluginName = kTVisualPluginName;
        SInt32 CPU = 0;
        #ifdef Timers
        backUpTime = UpTime();
	#endif

	CFStringRef textColor;
	CFComparisonResult result;

        CFBundleIdentifier = CFSTR("com.ios.igoom");
        
	// Read the preference.
	textColor = CFPreferencesCopyAppValue(CFSTR("iGoomPixelDoubling"),CFBundleIdentifier);
	if (textColor != NULL)
	{
	    result = CFStringCompareWithOptions(textColor, CFSTR("YES"), CFRangeMake(0,CFStringGetLength(textColor)), kCFCompareCaseInsensitive);
	    if (result ==  kCFCompareEqualTo) {
		doublePixels = true;
		//show(CFSTR("%@ is the same as %@"), str1, str2);
	    }
	    else doublePixels = false;
	}
	MemClear(&playerMessageInfo.u.registerVisualPluginMessage,sizeof(playerMessageInfo.u.registerVisualPluginMessage));
	BlockMoveData((Ptr)&pluginName[0],(Ptr)&playerMessageInfo.u.registerVisualPluginMessage.name[0],pluginName[0] + 1);

	SetNumVersion(&playerMessageInfo.u.registerVisualPluginMessage.pluginVersion, kTVisualPluginMajorVersion, kTVisualPluginMinorVersion, kTVisualPluginReleaseStage, kTVisualPluginNonFinalRelease);

	playerMessageInfo.u.registerVisualPluginMessage.options			= kVisualWantsIdleMessages | kVisualWantsConfigure;
	playerMessageInfo.u.registerVisualPluginMessage.handler			= (VisualPluginProcPtr)VisualPluginHandler;
	playerMessageInfo.u.registerVisualPluginMessage.registerRefCon		= 0;
	playerMessageInfo.u.registerVisualPluginMessage.creator			= kTVisualPluginCreator;
	
	playerMessageInfo.u.registerVisualPluginMessage.timeBetweenDataInMS	= 0xFFFFFFFF; // 16 milliseconds = 1 Tick,0xFFFFFFFF = Often as possible.
	playerMessageInfo.u.registerVisualPluginMessage.numWaveformChannels	= 2;
	playerMessageInfo.u.registerVisualPluginMessage.numSpectrumChannels	= 2;
	
	playerMessageInfo.u.registerVisualPluginMessage.minWidth		= 200;
	playerMessageInfo.u.registerVisualPluginMessage.minHeight		= 200;
	playerMessageInfo.u.registerVisualPluginMessage.maxWidth		= 4000;
	playerMessageInfo.u.registerVisualPluginMessage.maxHeight		= 4000;
	playerMessageInfo.u.registerVisualPluginMessage.minFullScreenBitDepth	= 32;
	playerMessageInfo.u.registerVisualPluginMessage.maxFullScreenBitDepth	= 32;
	playerMessageInfo.u.registerVisualPluginMessage.windowAlignmentInBytes	= 16;
	
	status = PlayerRegisterVisualPlugin(messageInfo->u.initMessage.appCookie,messageInfo->u.initMessage.appProc,&playerMessageInfo);
        
        Gestalt(gestaltPowerPCProcessorFeatures,&CPU);
        //fprintf(stderr,"CPU : %d / %d\n",CPU,(1 & (CPU >> gestaltPowerPCHasVectorInstructions)));
        if (1 & (CPU >> gestaltPowerPCHasVectorInstructions)) useAltivec = 1;
        else useAltivec = 0;
        return status;
}

//	main entrypoint
OSStatus iTunesPluginMainMachO(OSType message,PluginMessageInfo *messageInfo,void *refCon)
{
	OSStatus		status;
	
	(void) refCon;
	
	switch (message)
	{
		case kPluginInitMessage:
			status = RegisterVisualPlugin(messageInfo);
			break;
		case kPluginCleanupMessage:
			status = noErr;
			break;
		default:
			status = unimpErr;
			break;
	}
	
	return status;
}