#!/bin/bash
#
# try to merge media-sound/xmms-1.2.10-r15 with custom patches
#
source /etc/make.globals
source /etc/make.conf

EBUILD="$PORTDIR/media-sound/xmms/xmms-1.2.10-r15.ebuild"
SRCDIR="$PORTAGE_TMPDIR/portage/xmms-1.2.10-r15/work/xmms-1.2.10"

#
# emerge clean
# emerge unpack
#
if [[ -d "$SRCDIR" ]]
then
	ebuild "$EBUILD" clean  || exit 1
	ebuild "$EBUILD" unpack || exit 1
fi

#
# patch
#
echo -n "Patching XMMS..."
if ! patch --batch -N -d "$SRCDIR" -p1 <xmms-1.2.10-gentoo-r15.patch >/dev/null
then
	echo " failed!"
	echo -n "Trying dry-run of reverse patch..."
	if ! patch --batch --dry-run -R -d "$SRCDIR" -p1 <xmms-1.2.10-gentoo-r15.patch >/dev/null
	then
		echo " failed!"
		exit 1
	else
		echo " ok"
	fi	
fi

#
# emerge compile
# emerge merge
#
ebuild "$EBUILD" compile || exit 1
ebuild "$EBUILD" merge   || exit 1
