/*
 * get_mem.c
 * get memory usage, from get_load.c derived
 *
 * Author:  Hans-Helmut Buehmann 20. Jan. 1996
 * 
 * Modified for more recent kernels Helmut Geyer Oct. 1996
 */

#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <stdio.h>
#include <unistd.h>
#include "MemStripChart.h"

#ifdef linux
#include <proc/sysinfo.h>	/* possibly <proc/sysinfo.h> instead */

void GetMemLoadPoint(w, closure, call_data)	/* Linux version */
    Widget	w;		/* unused */
    caddr_t	closure;	/* unused */
    caddr_t	call_data;	/* pointer to (MemStripChartCallbackData) return value */
{
    MemStripChartCallbackData ret;
    meminfo();

    ret.code = (double)(kb_main_used - kb_main_buffers - kb_main_cached) / kb_main_total;
    ret.cached = (double)kb_main_cached / (double)kb_main_total;
    ret.buffer = (double)kb_main_buffers / (double)kb_main_total;
    ret.free = (double)kb_main_free / (double)kb_main_total;
    ret.swap = (double)kb_swap_used / (double)kb_main_total;

    memcpy(call_data, &ret, sizeof(MemStripChartCallbackData));
}

#endif /* linux */
