#! /usr/bin/perl -w

#  Copyright (C) 2000 Matthew P. Hodges
#  This file is part of XMakemol.

#  XMakemol is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2, or (at your option)
#  any later version.

#  XMakemol is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.

#  You should have received a copy of the GNU General Public License
#  along with XMakemol; see the file COPYING. If not, write to the
#  Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#  MA 02111-1307 USA

# Script to make an animated gif from a series of .xpm files produced
# by XMakemol. Uses gifmerge and other external programs.

# 	$rcs = ' $Id: xmake_anim.pl,v 1.18 2000/05/04 10:53:23 matt Exp $ ' ;

# Configure: specify where the binaries are

$gifmerge = "/usr/local/bin/gifmerge";
$ppmtogif = "/usr/bin/ppmtogif";
$ppmquant = "/usr/bin/ppmquant";
$xpmtoppm = "/usr/bin/xpmtoppm";

$convert = "/usr/bin/convert";

# Set the default options

require "getopts.pl";

$opt_c = 0;                     # Clean up *.gif *.xpm files
$opt_d = 50;                    # The delay in 1/100th seconds
$opt_l = 0;                     # The number of loops

&Getopts ("cd:l:o:");

$0 =~ s/.*\///;                 # Basename

if ($#ARGV != 0)
  {
    print ("Usage: $0 [options] file\n");
    print ("       -c            (clean up files)\n");
    print ("       -d <delay>    (in 1/100th seconds)\n");
    print ("       -l <no_loops> (0 for infinite)\n");
    print ("       -o <output>\n");
    die ();
  }

$root = $ARGV[0];

# Protect against some regexp constructs

$root =~ s/\./\\./g;
$root =~ s/\+/\\+/g;

if (defined ($opt_o))
  {
    $output = $opt_o;
  }
else
  {
    $output = $root . ".gif";
  }

opendir (DIR, ".");
@xpm_files = sort by_frame_number (grep (/$root\.[0-9]+\.xpm$/, readdir (DIR)));

if ($#xpm_files == -1)
  {
    die ("No files matching $root*.xpm\n");
  }

# Convert each xpm file into a gif file

print ("Converting files from xpm to gif ");

if (-e $convert)
  {
    printf ("using ImageMagick `convert' program\n");
    $use_convert = 1;
  }
else
  {
    printf ("using $xpmtoppm, $ppmquant and $ppmtogif\n");
    printf ("  (ImageMagick `convert' program not found)\n");
    $use_convert = 0;
  }


foreach $xpm_file (@xpm_files)
  {
    $gif_file = $xpm_file;
    $gif_file =~ s/xpm$/gif/;

    # Don't run if $gif_file exists and is newer than $xpm_file

    if ((-e $gif_file) &&
        ((-M $gif_file) < (-M $xpm_file)))
      {
        print ("$gif_file newer than $xpm_file -- skipping\n");
      }
    else
      {
        print ("\n   $xpm_file -> $gif_file\n");

        if ($use_convert == 1)
          {
            `$convert $xpm_file $gif_file`;
          }
        else
          {
            `$xpmtoppm < $xpm_file | $ppmquant -fs 256 | $ppmtogif > $gif_file`;
          }
      }

    push (@gif_files, $gif_file);

  }

# Run gifmerge

$command = "$gifmerge -l$opt_l -$opt_d @gif_files > $output";
print ("\nRunning gifmerge - $command\n\n");
`$command`;

print ("\n$output written\n");

# Clean up files

if ($opt_c)
  {
    print ("\nCleaning up *.xpm and *.gif files\n");
    unlink (@gif_files);
    unlink (@xpm_files);
  }

sub by_frame_number
  {
    $frame1 = $a;
    $frame2 = $b;

    # Remove all but the number frame the file name

    $frame1 =~ s/.*\.(\d+)\.xpm$/$1/;
    $frame2 =~ s/.*\.(\d+)\.xpm$/$1/;

    $frame1 <=> $frame2;
  }
