#ifndef INC_FIFO_H
#define INC_FIFO_H

//To initialize a fifo, just set the head pointer (not maintained
// by the fifo implementation but by the app) to NULL.

// the fifo is managed as a circular bidirectionally linked list
struct tfifo_item
{
	void * next;
	void * prev;
	void * data;
};

typedef struct tfifo_item	fifo_item;

fifo_item * fifo_push(fifo_item* head, void * data); // returns the new head
fifo_item * fifo_pop(fifo_item* head, void ** data); // fills in data, frees the
				// fifo_item and returns the new head
void * fifo_inspect(fifo_item* head); // returns the data of the item which
				// gets poped as next whithout altering the fifo queue.

#endif
