/*
 * Copyright (C) 2001-2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: xfmedia-xine.h 18475 2005-10-29 07:42:24Z kelnos $
 *
 * the xine engine in a widget - header
 */

#ifndef __XFMEDIA_XINE_H__
#define __XFMEDIA_XINE_H__

#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/extensions/XShm.h>

#include <glib.h>
#include <gtk/gtkbox.h>

#include <xine.h>

G_BEGIN_DECLS

#define XFMEDIA_TYPE_XINE              (xfmedia_xine_get_type())
#define XFMEDIA_XINE(obj)              (G_TYPE_CHECK_INSTANCE_CAST((obj), XFMEDIA_TYPE_XINE, XfmediaXine))
#define XFMEDIA_XINE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), XFMEDIA_TYPE_XINE, XfmediaXineClass))
#define XFMEDIA_IS_XINE(obj)           (G_TYPE_CHECK_INSTANCE_TYPE((obj), XFMEDIA_TYPE_XINE))
#define XFMEDIA_IS_XINE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE((klass), XFMEDIA_TYPE_XINE))

typedef struct _XfmediaXine XfmediaXine;
typedef struct _XfmediaXineClass XfmediaXineClass;
typedef struct _XfmediaXinePriv XfmediaXinePriv;

struct _XfmediaXine
{
    GtkWidget parent;
    
    /*< private >*/
    XfmediaXinePriv *priv;
};

struct _XfmediaXineClass
{
    GtkWidgetClass parent_class;
    
    /*< signals >*/
    void (*stream_ended)(XfmediaXine *xfx);
    void (*set_title)(XfmediaXine *xfx, const gchar *title);
    void (*ui_message)(XfmediaXine *xfx, const gchar *message);
    void (*format_changed)(XfmediaXine *xfx, gint width, gint height, gint aspect_code, gint is_pan_scan);
    void (*progress_message)(XfmediaXine *xfx, const gchar *message, gint percent);
    void (*mrl_reference)(XfmediaXine *xfx, const gchar *mrl, gint alternative, const gchar *title, gint length);
    void (*spu_button_enter)(XfmediaXine *xfx);
    void (*spu_button_leave)(XfmediaXine *xfx);
    
    /*< reserved >*/
    void (*_reserved1)();
    void (*_reserved2)();
    void (*_reserved3)();
};

GtkType      xfmedia_xine_get_type                   () G_GNUC_CONST;
GtkWidget *  xfmedia_xine_new                        (const gchar *video_driver_id,
                                                  const gchar *audio_driver_id);
void         xfmedia_xine_set_visibility             (XfmediaXine *xfx,
                                                  GdkVisibilityState state);
void         xfmedia_xine_resize                     (XfmediaXine *xfx,
                                                  gint x,
                                                  gint y,
                                                  gint width,
                                                  gint height);
gboolean     xfmedia_xine_open                       (XfmediaXine *xfx,
                                                  const gchar *mrl);
gboolean     xfmedia_xine_play                       (XfmediaXine *xfx,
                                                  gint pos,
                                                  gint start_time);
gboolean     xfmedia_xine_trick_mode                 (XfmediaXine *xfx,
                                                  gint mode,
                                                  gint value);
gint         xfmedia_xine_get_stream_info            (XfmediaXine *xfx,
                                                  gint info);
G_CONST_RETURN gchar *xfmedia_xine_get_meta_info     (XfmediaXine *xfx,
                                                  gint info);
G_CONST_RETURN gchar *xfmedia_xine_get_current_mrl   (XfmediaXine *xfx);
gboolean     xfmedia_xine_get_pos_length             (XfmediaXine *xfx,
                                                  gint *pos_stream,
                                                  gint *pos_time,
                                                  gint * length_time);
void         xfmedia_xine_stop                       (XfmediaXine *xfx);

gint         xfmedia_xine_get_error                  (XfmediaXine *xfx);
gint         xfmedia_xine_get_status                 (XfmediaXine *xfx);

void         xfmedia_xine_set_param                  (XfmediaXine *xfx,
                                                  gint param,
                                                  gint value);
gint         xfmedia_xine_get_param                  (XfmediaXine *xfx,
                                                  gint param);

void         xfmedia_xine_engine_set_param           (XfmediaXine *xfx,
                                                  gint param,
                                                  gint value);

gint         xfmedia_xine_engine_get_param           (XfmediaXine *xfx,
                                                  gint value);

gint         xfmedia_xine_get_audio_lang             (XfmediaXine *xfx,
                                                  gint channel,
                                                  gchar *lang);
gint         xfmedia_xine_get_spu_lang               (XfmediaXine *xfx,
                                                  gint channel,
                                                  gchar *lang);

void         xfmedia_xine_set_resize_factor          (XfmediaXine *xfx,
                                                  gdouble factor);

gint         xfmedia_xine_get_current_frame          (XfmediaXine *xfx,
                                                  gint *width,
                                                  gint *height,
                                                  gint *ratio_code,
                                                  gint *format,
                                                  guint8 *img);

gint         xfmedia_xine_get_log_section_count      (XfmediaXine *xfx);
gchar **     xfmedia_xine_get_log_names              (XfmediaXine *xfx);
gchar **     xfmedia_xine_get_log                    (XfmediaXine *xfx,
                                                  gint buf);
void         xfmedia_xine_register_log_cb            (XfmediaXine *xfx,
                                                  xine_log_cb_t cb,
                                                  gpointer user_data);

gchar **     xfmedia_xine_get_browsable_input_plugin_ids
                                                 (XfmediaXine * xfx);
xine_mrl_t **xfmedia_xine_get_browse_mrls            (XfmediaXine *xfx,
                                                  const gchar *plugin_id,
                                                  const gchar *start_mrl,
                                                  gint *num_mrls);
GList *      xfmedia_xine_get_autoplay_input_plugin_ids
                                                 (XfmediaXine *xfx);
GList *      xfmedia_xine_get_autoplay_mrls          (XfmediaXine *xfx,
                                                  const gchar *plugin_id);
gchar *      xfmedia_xine_get_file_extensions        (XfmediaXine *xfx);
gchar *      xfmedia_xine_get_mime_types             (XfmediaXine *xfx);

G_CONST_RETURN gchar *xfmedia_xine_config_register_string
                                                 (XfmediaXine *xfx,
                                                  const gchar *key,
                                                  const gchar *def_value,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         xfmedia_xine_config_register_range      (XfmediaXine *xfx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  gint min,
                                                  gint max,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         xfmedia_xine_config_register_enum       (XfmediaXine *xfx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  gchar **values,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         xfmedia_xine_config_register_num        (XfmediaXine *xfx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         xfmedia_xine_config_register_bool       (XfmediaXine *xfx,
                                                  const gchar *key,
                                                  gint def_value,
                                                  const gchar *description,
                                                  const gchar *help,
                                                  gint exp_level,
                                                  xine_config_cb_t changed_cb,
                                                  gpointer cb_data);

gint         xfmedia_xine_config_get_first_entry     (XfmediaXine *xfx,
                                                  xine_cfg_entry_t *entry);
gint         xfmedia_xine_config_get_next_entry      (XfmediaXine *xfx,
                                                  xine_cfg_entry_t * entry);
gint         xfmedia_xine_config_lookup_entry        (XfmediaXine *xfx,
                                                  const gchar *key,
                                                  xine_cfg_entry_t *entry);
void         xfmedia_xine_config_update_entry        (XfmediaXine *xfx,
                                                  xine_cfg_entry_t *entry);
void         xfmedia_xine_config_load                (XfmediaXine *xfx,
                                                  const gchar *cfg_filename);
void         xfmedia_xine_config_save                (XfmediaXine *xfx,
                                                  const gchar *cfg_filename);
void         xfmedia_xine_config_reset               (XfmediaXine *xfx);

xine_event_queue_t *xfmedia_xine_event_new_queue     (XfmediaXine *xfx);

void         xfmedia_xine_event_send                 (XfmediaXine *xfx,
                                                  const xine_event_t *event);

GList *      xfmedia_xine_list_post_plugins_typed    (XfmediaXine *xfx,
                                                  gint type);

void         xfmedia_xine_set_vis                    (XfmediaXine *xfx,
                                                  const gchar *id); 

xine_t *     xfmedia_xine_get_raw_xine_engine        (XfmediaXine *xfx);
xine_stream_t *xfmedia_xine_get_raw_stream           (XfmediaXine *xfx);
xine_audio_port_t *xfmedia_xine_get_raw_audio_port   (XfmediaXine *xfx);
xine_video_port_t *xfmedia_xine_get_raw_video_port   (XfmediaXine *xfx);
xine_post_t *xfmedia_xine_get_raw_post_plugin        (XfmediaXine *xfx);

void         xfmedia_xine_port_send_gui_data         (XfmediaXine *xfx,
                                                  gint type,
                                                  gpointer data);

GList *      xfmedia_xine_list_audio_output_plugins  (XfmediaXine *xfx);
GList *      xfmedia_xine_list_video_output_plugins  (XfmediaXine *xfx);

gboolean     xfmedia_xine_set_audio_output_plugin    (XfmediaXine *xfx,
                                                  const gchar *plugin_id);
gboolean     xfmedia_xine_set_video_output_plugin    (XfmediaXine *xfx,
                                                  const gchar *plugin_id);

/* FIXME: OSD missing */

G_END_DECLS

#endif
