/* $Id: misc.cpp,v 1.13 2004/01/02 04:05:36 fesnel Exp $ */
/*******************************************************************************
 *   This program is part of the XFMail email client.                          *
 *                                                                             *
 *   Copyright : (C) 1995-1998 Gennady B. Sorokopud (gena@NetVision.net.il)    *
 *               (C) 1995 Ugen. J. S. Antsilevich (ugen@latte.worldbank.org)   *
 *               (C) 1998-2004 by the Archimedes Project                       *
 *                   http://sourceforge.net/projects/archimedes                *
 *                                                                             *
 *             --------------------------------------------                    *
 *                                                                             *
 *   This program is free software; you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by      *
 *   the Free Software Foundation; either version 2 of the License, or         *
 *   (at your option) any later version.                                       *
 *                                                                             *
 *   This program is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY, without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 *   GNU General Public License for more details.                              *
 *                                                                             *
 *   You should have received a copy of the GNU General Public License         *
 *   along with this program; if not, write to the Free Software               *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston MA 02111-1307, USA.  *
 *                                                                             *
 *   Additional Permission granted:                                            *
 *                                                                             *
 *   This program is designed to use the XForms library, so we consider        *
 *   permission to link to that non-GPL-compatible library is implicit.        *
 *   However, in case this is not considered so, we explicitly state:          *
 *                                                                             *
 *   "As a special exception, the Archimedes Project, with the permission      *
 *    of all earlier copyright holders, formally gives permission to link      *
 *    this program with the XForms library, and distribute the resulting       *
 *    executable without the source code for XForms in the source              *
 *    distribution".                                                           *
 *                                                                             *
 ******************************************************************************/


#include <glib.h>

#include <fmail.h>
#include <umail.h>
#include <choose_folder.h>
#include <cfgfile.h>
#include "configform.h"

extern cfgfile Config;

static FD_config_misc *misc_obj;
static FD_config_header *header_obj;

void Misc_Mail_Dir_Call(FL_OBJECT * obj, long param) {
}

void Misc_Cache_Dir_Call(FL_OBJECT * obj, long param) {
	fl_show_message("Warning!",
					"Please restart XFMail immediatly after you",
					"changed the location of cache directory");
}

void Misc_SIconized_Call(FL_OBJECT * obj, long param) {
}

void Misc_Empty_Call(FL_OBJECT * obj, long param) {
}

void Misc_From_Call(FL_OBJECT * obj, long param) {
}

void misc_conf(int set_default, FD_config_misc * form) {
	char buf[255];

	misc_obj = form;

	snprintf(buf, sizeof(buf), "%s/Mail", homedir);
	fl_set_input(misc_obj->Misc_Mail_Dir,
				 Config.get("maildir", buf, set_default).c_str());
	fl_set_input(misc_obj->Misc_From,
				 Config.get("from", "", set_default).c_str());
	fl_set_input(misc_obj->Misc_LPR,
				 Config.get("print",
										 get_print_command(NULL),
										 set_default).c_str());
	fl_set_input(misc_obj->Misc_Printer,
				 Config.get("printer", "lp",
										 set_default).c_str());
	fl_set_input(misc_obj->Misc_Cache_Dir,
					 Config.get("cachedir",
											 configdir, set_default).c_str());

	if(Config.exist("organization"))
		fl_set_input(misc_obj->Misc_Org,
					 Config.get("organization", "", set_default).c_str());
	else
		fl_set_input(misc_obj->Misc_Org, "");

	if(Config.exist("replyto"))
		fl_set_input(misc_obj->Misc_RTO,
					 Config.get("replyto", "", set_default).c_str());
	else
		fl_set_input(misc_obj->Misc_RTO, "");

	fl_set_input(misc_obj->Misc_Cache,
				 Config.get("mincache", "512", set_default).c_str());
	fl_set_button(misc_obj->Misc_SIconized,
				  Config.getIntDefault("starticon", 0, set_default));
	fl_set_button(misc_obj->Misc_Empty,
				  Config.getIntDefault("emptytrash", 0, set_default));
	fl_set_button(misc_obj->Misc_SLog,
				  Config.getIntDefault("startlog", 0, set_default));
	fl_set_button(misc_obj->Misc_TTips,
				  Config.getIntDefault("tooltips", 1, set_default));
	fl_set_button(misc_obj->Misc_Placement,
				  Config.getIntDefault("wplace", 1, set_default));
	fl_set_button(misc_obj->Misc_CExit,
				  Config.getIntDefault("cexit", 0, set_default));
	fl_set_button(misc_obj->Misc_SetID,
				  Config.getIntDefault("setmsgid", 1, set_default));
	fl_set_button(misc_obj->Misc_SetSender, Config.getIntDefault("setsender", 1, set_default));
	fl_set_button(misc_obj->Misc_PrintHeader, Config.getIntDefault("printheader", 1, set_default));
	fl_set_button(misc_obj->Misc_Log, (logging & LOG_ERRORS) ? 1 : 0);
	fl_set_button(misc_obj->Misc_Lognet, (logging & LOG_NET) ? 1 : 0);
}

void handle_misc_input(FD_config_misc * form) {
	struct _mail_addr *ma;
	char *p;

	misc_obj = form;

	Config.set("from", (char *) fl_get_input(misc_obj->Misc_From));
	if( ((ma = get_address(Config.get("from", "").c_str(), ADDR_GET_FIRST)) == NULL)
	  || ((p = strchr(ma->addr, '@')) == NULL)
	  || (strchr(p, '.') == NULL)) display_msg(MSG_WARN,
											   "Your E-Mail address (From field)",
											   "is invalid, please fix it");

	if(ma)
		discard_address(ma);

	Config.set("print", (char *) fl_get_input(misc_obj->Misc_LPR));
	Config.set("printer",
					 (char *) fl_get_input(misc_obj->Misc_Printer));
	if(strlen(fl_get_input(misc_obj->Misc_Org)) > 1)
		Config.set("organization", (char *) fl_get_input(misc_obj->Misc_Org));
	else
		Config.remove("organization");
	if(strlen(fl_get_input(misc_obj->Misc_RTO)) > 1)
		Config.set("replyto", (char *) fl_get_input(misc_obj->Misc_RTO));
	else
		Config.remove("replyto");
	Config.set("maildir", (char *) fl_get_input(misc_obj->Misc_Mail_Dir));
	Config.set("mincache", (char *) fl_get_input(misc_obj->Misc_Cache));
	if(strlen(fl_get_input(misc_obj->Misc_Cache_Dir)) > 1)
		Config.set("cachedir", (char *) fl_get_input(misc_obj->Misc_Cache_Dir));
	else
		Config.remove("cachedir");
	Config.set("starticon", fl_get_button(misc_obj->Misc_SIconized));
	Config.set("emptytrash", fl_get_button(misc_obj->Misc_Empty));
	Config.set("startlog", fl_get_button(misc_obj->Misc_SLog));
	Config.set("tooltips", fl_get_button(misc_obj->Misc_TTips));
	Config.set("wplace", fl_get_button(misc_obj->Misc_Placement));
	Config.set("cexit", fl_get_button(misc_obj->Misc_CExit));
	Config.set("setmsgid", fl_get_button(misc_obj->Misc_SetID));
	Config.set("setsender", fl_get_button(misc_obj->Misc_SetSender));
	Config.set("printheader", fl_get_button(misc_obj->Misc_PrintHeader));
	if(fl_get_button(misc_obj->Misc_Log))
		logging |= LOG_ERRORS;
	else
		logging &= ~LOG_ERRORS;

	if(fl_get_button(misc_obj->Misc_Lognet))
		logging |= LOG_NET;
	else
		logging &= ~LOG_NET;

	ttips = fl_get_button(misc_obj->Misc_TTips);

	return;
}

void display_header() {
	struct _head_field *hf;
	char buf[255];
	char *h = (char *) fl_get_browser_line(header_obj->Header_List,
										   fl_get_browser(header_obj->
														  Header_List));

	if(!h || !*h) {
		fl_set_input(header_obj->Header_Name, "");
		fl_set_input(header_obj->Header_Contents, "");
		return;
	}

	strncpy(buf, h, sizeof(buf) - 1);
	buf[sizeof(buf) - 1] = '\0';
	if((hf = get_field(buf)) == NULL) {
		fl_set_input(header_obj->Header_Name, "");
		fl_set_input(header_obj->Header_Contents, "");
		return;
	}

	fl_set_input(header_obj->Header_Name, hf->f_name);
	fl_set_input(header_obj->Header_Contents, hf->f_line);
	if(hf->f_line)
		free(hf->f_line);
	free(hf);

	return;
}

void display_headers() {
	int i;
	char hline[255];
	struct _head_field *hf;

	fl_clear_browser(header_obj->Header_List);
	fl_freeze_form(header_obj->config_header);
	for(i = 1; i <= MAX_EXTRA_HEADERS; i++) {
		sprintf(hline, "ExtraHeader%d", i);
		if(Config.exist(hline)) {
			strcpy(hline, Config.get(hline, "").c_str());
			if((hf = get_field(hline)) == NULL) {
				Config.remove(hline);
				continue;
			}
			if(strlen(hf->f_name) + strlen(hf->f_line) >= sizeof(hline))
				hf->f_line[sizeof(hline) - strlen(hf->f_name)] = '\0';
			snprintf(hline, sizeof(hline), "%s: %s", hf->f_name,
					 hf->f_line);
			fl_addto_browser(header_obj->Header_List, hline);
			if(hf->f_line)
				free(hf->f_line);
			free(hf);

		}
	}
	fl_select_browser_line(header_obj->Header_List, 1);
	display_header();
	fl_unfreeze_form(header_obj->config_header);

	return;
}

void store_headers() {
	int i;
	char hline[32], buf[255], *h;
	struct _head_field *hf;

	for(i = 1; i <= MAX_EXTRA_HEADERS; i++) {
		sprintf(hline, "ExtraHeader%d", i);
		if((h = (char *) fl_get_browser_line(header_obj->Header_List, i))
		   != NULL) {
			strncpy(buf, h, sizeof(buf) - 1);
			buf[sizeof(buf) - 1] = '\0';
			if((hf = get_field(buf)) == NULL) {
				Config.remove(hline);
				continue;
			}
			if(strlen(hf->f_name) + strlen(hf->f_line) >= sizeof(buf))
				hf->f_line[sizeof(buf) - strlen(hf->f_name)] = '\0';
			snprintf(buf, sizeof(buf), "%s: %s", hf->f_name, hf->f_line);
			Config.set(hline, buf);
			if(hf->f_line)
				free(hf->f_line);
			free(hf);
		} else
			Config.remove(hline);
	}

	return;
}

void Header_Call(FL_OBJECT * obj, long param) {
}

void Header_List_Call(FL_OBJECT * obj, long param) {
	display_header();
}

void Header_Add_Call(FL_OBJECT * obj, long param) {
	char buf[255], *h;
	struct _head_field *hf;
	int i;

	snprintf(buf, sizeof(buf), "%s: %s",
			 fl_get_input(header_obj->Header_Name),
			 fl_get_input(header_obj->Header_Contents));

	if(((hf = get_field(buf)) == NULL) ||
	   (hf->f_line == NULL) || !*hf->f_line) {
		display_msg(MSG_WARN, "add", "Invalid header field");
		if(hf) {
			if(hf->f_line)
				free(hf->f_line);
			free(hf);
		}
		return;
	}

	if(!strncasecmp(hf->f_name, "Subject", 7) &&
	   ((hf->f_name[7] == '\0') ||
		(isdigit(hf->f_name[7]) && (hf->f_name[8] == '\0')))) {
	} else if(is_spechdr(hf)) {
		if(hf->f_line)
			free(hf->f_line);
		free(hf);
		display_msg(MSG_WARN, "add", "\"%s\" can not be used", hf->f_name);
		return;
	}


	if(hf->f_line)
		free(hf->f_line);
	free(hf);

	snprintf(buf, sizeof(buf), "%s: %s",
			 fl_get_input(header_obj->Header_Name),
			 fl_get_input(header_obj->Header_Contents));

	for(i = 1; i <= MAX_EXTRA_HEADERS; i++) {
		if((h = (char *) fl_get_browser_line(header_obj->Header_List, i))
		   == NULL) {
			fl_addto_browser(header_obj->Header_List, buf);
			fl_select_browser_line(header_obj->Header_List,
								   fl_get_browser_maxline(header_obj->
														  Header_List));
			display_header();
			return;
		}
	}

	display_header();
	display_msg(MSG_WARN, "add",
				"Can not have more then %d extra header fields",
				MAX_EXTRA_HEADERS);
	return;
}

void Header_Delete_Call(FL_OBJECT * obj, long param) {
	fl_delete_browser_line(header_obj->Header_List,
						   fl_get_browser(header_obj->Header_List));
	fl_select_browser_line(header_obj->Header_List, 1);
	display_header();
}

void Header_Modify_Call(FL_OBJECT * obj, long param) {
	char buf[255];
	struct _head_field *hf;

	snprintf(buf, sizeof(buf), "%s: %s",
			 fl_get_input(header_obj->Header_Name),
			 fl_get_input(header_obj->Header_Contents));

	if(((hf = get_field(buf)) == NULL) ||
	   (hf->f_line == NULL) || !*hf->f_line) {
		display_msg(MSG_WARN, "modify", "Invalid header field");
		if(hf) {
			if(hf->f_line)
				free(hf->f_line);
			free(hf);
		}
		return;
	}

	if(is_spechdr(hf)) {
		if(hf->f_line)
			free(hf->f_line);
		free(hf);
		display_msg(MSG_WARN, "modify", "\"%s\" can not be used",
					hf->f_name);
		return;
	}

	if(hf->f_line)
		free(hf->f_line);
	free(hf);

	snprintf(buf, sizeof(buf), "%s: %s",
			 fl_get_input(header_obj->Header_Name),
			 fl_get_input(header_obj->Header_Contents));

	fl_replace_browser_line(header_obj->Header_List,
							fl_get_browser(header_obj->Header_List),
							(char *) buf);

	display_header();

	return;
}

void header_conf(int set_default, FD_config_header * form) {

	header_obj = form;
	fl_set_browser_fontstyle(header_obj->Header_List, FL_FIXED_STYLE);
	fl_set_browser_fontsize(header_obj->Header_List, FL_NORMAL_SIZE);
	display_headers();

	return;
}

void handle_header_input(FD_config_header * form) {

	header_obj = form;
	store_headers();
}
