/*
 *	xeno_rc_style.h:
 *		Gtk 1.2: XenoRcStyleData
 *		Gtk 2.0: XenoRcStyle
 *		Common types also used by GtkStyle
 */

#ifndef XENO_RC_STYLE_H
#define XENO_RC_STYLE_H

#include "xeno_theme.h"
#include <gtk/gtkrc.h>

#define XENO_DEFAULT_SHINE				1.5
#define XENO_DEFAULT_SHADE				0.6666667


/*
 *	GtkShadowType
 */
typedef enum {
	XENO_SHADOW_NONE		= GTK_SHADOW_NONE,			/* 0	none	*/
	
	XENO_SHADOW_IN			= GTK_SHADOW_IN,			/* 1	in		*/
	XENO_SHADOW_OUT			= GTK_SHADOW_OUT,			/* 2	out		*/
	
	XENO_SHADOW_ETCHED_IN	= GTK_SHADOW_ETCHED_IN,		/* 3	etched in	*/
	XENO_SHADOW_ETCHED_OUT	= GTK_SHADOW_ETCHED_OUT,	/* 4	etched out	*/
	
	XENO_SHADOW_XENO_IN,		/* default in	*/
	XENO_SHADOW_XENO_OUT,		/* default out	*/
	
	XENO_SHADOW_THIN_IN,		/* thin in		*/
	XENO_SHADOW_THIN_OUT,		/* thin out		*/
	
	XENO_SHADOW_NEXT_IN,		/* next in		*/
	XENO_SHADOW_NEXT_OUT,		/* next out		*/
	
	XENO_SHADOW_NOTE_IN,		/* note in		*/
	XENO_SHADOW_NOTE_OUT,		/* note out		*/
	
	XENO_SHADOW_BLACK_IN,		/* black in		*/
	XENO_SHADOW_BLACK_OUT,		/* black out	*/
	
	XENO_SHADOW_LAST,
	
	/* aliases */
	XENO_SHADOW_BUTTON_RELIEF	= XENO_SHADOW_BLACK_OUT,
	XENO_SHADOW_NOTE			= XENO_SHADOW_NOTE_OUT,
	XENO_SHADOW_THIN_BUTTON_IN	= XENO_SHADOW_NOTE_IN,
	XENO_SHADOW_BUTTON_IN		= XENO_SHADOW_NOTE_IN,
	XENO_SHADOW_MENU			= XENO_SHADOW_OUT,
	XENO_SHADOW_FOCUS			= XENO_SHADOW_BLACK_IN
} XenoShadowType;
#define XENO_SHADOW_IS_IN(shadow)	((shadow) & 0x01)
#define XENO_SHADOW_USER(shadow)	(shadow)


/*
 *	GtkKnobType
 */
typedef enum {
	XENO_KNOB_NONE = 0,
	
	XENO_KNOB_SHADOW_IN			= XENO_SHADOW_IN,
	XENO_KNOB_SHADOW_OUT		= XENO_SHADOW_OUT,
	XENO_KNOB_SHADOW_ETCHED_IN	= XENO_SHADOW_ETCHED_IN,
	XENO_KNOB_SHADOW_ETCHED_OUT	= XENO_SHADOW_ETCHED_OUT,
	XENO_KNOB_SHADOW_THIN_IN	= XENO_SHADOW_THIN_IN,
	XENO_KNOB_SHADOW_THIN_OUT	= XENO_SHADOW_THIN_OUT,
	
	XENO_KNOB_LINES_IN,
	XENO_KNOB_LINES_OUT,
	XENO_KNOB_DIMPLE_IN,
	XENO_KNOB_DIMPLE_OUT,
	XENO_KNOB_BUDS_IN,
	XENO_KNOB_BUDS_OUT,
	XENO_KNOB_NS_BUDS_IN,
	XENO_KNOB_NS_BUDS_OUT,
	
	XENO_KNOB_END,
	
	/* aliases */
	XENO_KNOB_DIMPLE	= XENO_KNOB_DIMPLE_IN,
	XENO_KNOB_LINES		= XENO_KNOB_LINES_OUT,
	XENO_KNOB_HOLES		= XENO_KNOB_BUDS_IN,
	XENO_KNOB_BUDS		= XENO_KNOB_BUDS_OUT,
	XENO_KNOB_BOX		= XENO_KNOB_SHADOW_ETCHED_IN,
	XENO_KNOB_DEFAULT	= XENO_KNOB_NS_BUDS_OUT,
	
	XENO_KNOB_SHADOW_LAST = XENO_KNOB_SHADOW_THIN_OUT,
	XENO_KNOB_LAST		  = XENO_KNOB_END - 1
} XenoKnobType;


/*
 *	XenoRcGradient
 */
typedef enum {
	XENO_GRADIENT_NONE			= 0,
	XENO_GRADIENT_HORIZONTAL	= 1,
	XENO_GRADIENT_VERTICAL		= 2,
	XENO_GRADIENT_DIAGONAL		= 3
} XenoGradientType;

typedef struct {
	gfloat			factor;
	gfloat			bias;
	guint8			type;
	guint8			interlaced;
} XenoRcGradient;

#define xeno_rc_gradient_init(g)	{ (g)->type = XENO_GRADIENT_NONE; }


/*
 *	XenoRcOrigin - background pixmap alignment
 */
typedef enum {
	XENO_ORIGIN_DEFAULT,
	XENO_ORIGIN_WIDGET,
	XENO_ORIGIN_ALIGNMENT,
	XENO_ORIGIN_TOPLEVEL,
	XENO_ORIGIN_ROOT,
	
	XENO_ORIGIN_UNKNOWN
} XenoOriginType;

typedef struct {
	XenoOriginType	type;
	gfloat	x, y;
} XenoRcOrigin;

#define xeno_rc_origin_init(o)		{ (o)->type = XENO_ORIGIN_DEFAULT; }


/*
 *	Configuration management, inherited and merged rc_styles
 */
typedef guint32 XenoConfigMask;

enum {
	XENO_CONFIG_STEPPER_ENDS	= 0x00000001,
	XENO_CONFIG_STEPPER_ARROWS	= 0x00000002,
	XENO_CONFIG_STEPPER_BOX		= 0x00000004,
	XENO_CONFIG_SCROLLBAR_WIDTH	= 0x00000008,
	XENO_CONFIG_SCROLLBAR_FLUSH	= 0x00000010,
	XENO_CONFIG_POPUP_ARROWS	= 0x00000100,
	XENO_CONFIG_COMBO_IMAGE		= 0x00000200,
	XENO_CONFIG_FLAT_WINDOWS	= 0x00000800,
	XENO_CONFIG_THICKNESS		= 0x00001000
};

enum {
	XENO_CONFIG_KNOB_SCROLLBAR	= 0x00000001,	/* 0x0000001f */
	XENO_CONFIG_KNOB_PANED		= 0x00000020,	/* 0x000003e0 */
	XENO_CONFIG_KNOB_HANDLE		= 0x80000000
};

enum {
	XENO_CONFIG_SHADOW_IN		= 0x00000001,	/* 0x0000001f */
	XENO_CONFIG_SHADOW_OUT		= 0x00000020,	/* 0x000003e0 */
	XENO_CONFIG_SHADOW_TEXT		= 0x00000400,	/* 0x00007c00 */
	
	XENO_CONFIG_SHADOW_BUTTON_RELIEF	= 0x80000000,
	XENO_CONFIG_SHADOW_BUTTON_DEFAULT	= 0x40000000,
	XENO_CONFIG_SHADOW_MENU_ITEM		= 0x20000000
};

enum {
	XENO_CHROME_SHINE			= 0x00000001,	/* 0x0000001f */
	XENO_CHROME_SHADE			= 0x00000020,	/* 0x000003e0 */
	XENO_CHROME_WHITE			= 0x00000400,	/* 0x00007c00 */
	XENO_CHROME_BLACK			= 0x00008000,	/* 0x000f8000 */
	XENO_CHROME_GRADIENT		= 0x00100000,	/* 0x01f00000 */
	XENO_CHROME_ORIGIN			= 0x02000000,	/* 0x3e000000 */
	XENO_CHROME_FOCUS_COLOR		= 0x80000000
};


/*
 *	XenoRcData / XenoRcStyle
 */
#if XENO_GTK2
#define XENO_TYPE_RC_STYLE              (xeno_rc_style_get_type ())
#define XENO_RC_STYLE(object)           (G_TYPE_CHECK_INSTANCE_CAST((object), XENO_TYPE_RC_STYLE, XenoRcStyle))
#define XENO_RC_STYLE_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST((klass), XENO_TYPE_RC_STYLE, XenoRcStyleClass))
#define XENO_IS_RC_STYLE(object)        (G_TYPE_CHECK_INSTANCE_TYPE((object), XENO_TYPE_RC_STYLE))
#define XENO_IS_RC_STYLE_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE((klass), XENO_TYPE_RC_STYLE))
#define XENO_RC_STYLE_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS((obj), XENO_TYPE_RC_STYLE, XenoRcStyleClass))

typedef struct _XenoRcData			XenoRcStyle;
typedef struct _XenoRcStyleClass	XenoRcStyleClass;

#define XENO_RC_STYLE_DATA(rc_style)	(rc_style)
#else
#define XENO_RC_STYLE_DATA(rc_style)	((XenoRcData *)((rc_style)->engine_data))
#endif

typedef struct _XenoRcData			XenoRcData;

struct _XenoRcData {
  #if XENO_GTK2
	GtkRcStyle		parent_instance;
  #endif
	XenoConfigMask	config;
	XenoConfigMask	chrome;
	XenoConfigMask	config_knobs;
	XenoConfigMask	config_shadows;
	
	XenoRcGradient	gradient[5];
	XenoRcOrigin	origin[5];
	
	GdkColor		focus_color;
	
	gfloat			shine[5];
	gfloat			shade[5];
	gfloat			white[5];
	gfloat			black[5];
	
  #if !XENO_GTK2
	gint16			ref_count;
  #endif
	
	guint8			shadow_in[5];
	guint8			shadow_out[5];
	guint8			shadow_text[5];
	guint8			shadow_button_default;
	guint8			shadow_button_relief;
	guint8			shadow_menu_item;
	
	guint8			scrollbar_knobs[5];
	guint8			paned_knobs[5];
	guint8			handle_knob;
	
	guint8			thickness;
	guint8			scrollbar_width;
  /*
	guint8			check_image_variant : 3;
	guint8			radio_image_variant : 2;
	guint8			dimple_image_variant : 1;
  */
	gboolean		thin : 1;
	gboolean		stepper_ends : 1;
	gboolean		stepper_arrows : 1;
	gboolean		stepper_box : 1;
	gboolean		scrollbar_flush : 1;
	gboolean		flat_windows : 1;
	gboolean		popup_arrows : 1;
};

#if XENO_GTK2
struct _XenoRcStyleClass {
	GtkRcStyleClass	parent_class;
};

GType		xeno_rc_style_get_type ();
#define		xeno_rc_style_new()		g_object_new(xeno_rc_style_get_type(), NULL)

#else
guint		xeno_parse_rc_style		(GScanner *scanner, GtkRcStyle *rc_style);
void		xeno_merge_rc_style		(GtkRcStyle *dest, GtkRcStyle *src);
void		xeno_rc_style_to_style	(GtkStyle *style, GtkRcStyle *rc_style);
void		xeno_destroy_rc_style	(GtkRcStyle *rc_style);
#endif

#if !XENO_GTK2
extern GMemChunk *	xeno_rc_data_chunk;
#endif

#endif /* XENO_RC_STYLE_H */

