/*
 *	xeno_images.h
 */

#ifndef XENO_IMAGES_H
#define XENO_IMAGES_H

#include "xeno_theme.h"

/*
 *	Enums
 */

enum {
	/* colors in the style */
	XENO_FG, XENO_BG,
	XENO_LIGHT, XENO_DARK, XENO_MID,
	XENO_TEXT, XENO_BASE,
	XENO_WHITE, XENO_BLACK,
	XENO_GRADIENT_BG,
	
	XENO_COLOR_LAST,
	
	/* colors from frame */
	XENO_TOP, XENO_BOT, XENO_CORNER,
	
	/* conditional */       
	XENO_THIN,
	
	/* change brightness only */
	XENO_SHADE,
	
	/* blends */
	XENO_BI,
	XENO_TRI,
	XENO_QUAD,
	
	/* static */
	XENO_USER,
	XENO_PURE_WHITE,
	XENO_PURE_BLACK,
	
	/* alias */
};

enum {
	XENO_NORMAL			= GTK_STATE_NORMAL,
	XENO_ACTIVE			= GTK_STATE_ACTIVE,
	XENO_PRELIGHT		= GTK_STATE_PRELIGHT,
	XENO_SELECTED		= GTK_STATE_SELECTED,
	XENO_INSENSITIVE	= GTK_STATE_INSENSITIVE,
	
	XENO_CURRENT		= 0x0008,
	XENO_PARENT_CURRENT	= 0x0019,
	
	XENO_PARENT			= 0x0010,
	
	XENO_STATE_MASK		= 0x000f,
	XENO_GTK_STATE_MASK	= 0x0007
};

/* the masks that can be shared between different images */
typedef enum {
	XENO_MASK_NONE,
	
	XENO_MASK_RADIO,
	XENO_MASK_RADIO_ITEM,
	XENO_MASK_CORNER,
	XENO_MASK_DIMPLE,
	
	XENO_MASK_TRIANGLES,
	
	XENO_MASK_CHECK_7,
	XENO_MASK_CHECK_9,
	XENO_MASK_CHECK_11,
	
	XENO_MASK_LAST
} XenoMaskType;


/*
 *	Image info
 */

#define XENO_IMAGE_RADIO_SIZE		13
#define XENO_IMAGE_RADIO_MENU_SIZE	6
#define XENO_IMAGE_DIMPLE_SIZE		6

#define XENO_TRIANGLE_UP_X		15
#define XENO_TRIANGLE_UP_Y		0

#define XENO_TRIANGLE_DOWN_X	46
#define XENO_TRIANGLE_DOWN_Y	31

#define XENO_TRIANGLE_LEFT_X	62
#define XENO_TRIANGLE_LEFT_Y	15

#define XENO_TRIANGLE_RIGHT_X	117
#define XENO_TRIANGLE_RIGHT_Y	15

#define	XENO_TRIANGLE_HEIGHT_RATIO	0.866025403783
#define	XENO_TRIANGLE_BASE_RATIO	1.15470053838


/*
 *	XenoImage
 */

typedef struct {
	const char		**xpm;
	gint			mask_type;
	const guchar	*remap;
	GtkShadowType	shadow_type;
	GtkStateType	state_type;
} XenoImage;

extern const XenoImage xeno_images[XENO_IMAGE_LAST];
extern const XenoImage xeno_low_images[XENO_IMAGE_LAST];


/*
 *	XenoShadow
 */

enum {
	XENO_PEN_TOP	= 0,
	XENO_PEN_BOTTOM	= 1,
	XENO_PEN_CORNER	= 2
};

typedef guint8			XenoShadowPen[2];
typedef XenoShadowPen	XenoShadowRing[3];

typedef struct {
	XenoShadowRing	thin_ring[1];
	XenoShadowRing	medium_ring[2];
	XenoShadowRing	thick_ring[3];
	gint	thickness;
} XenoShadowStyle;

extern const XenoShadowStyle xeno_shadows[XENO_SHADOW_LAST];


#endif /* XENO_IMAGES_H */

