// manual.cpp - online help.

#include <qlayout.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qmultilineedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpaintdevicemetrics.h>
#include <qscrollview.h>
#include <qwhatsthis.h>
#include <qpushbutton.h>
#include <qdialog.h>
#include <qhbox.h>
#include <qvbox.h>
#include <qtextview.h>
#include <qbrush.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qstringlist.h>

#include "application.h"
#include "defs.h"
#include "manual.h"

// Manual pages.  Rich text format.
void XManual::InitManPages() {
  // Title Page
  manpages.append( tr("<center><b>Welcome to XDrawChem!</b><br>Bryan Herger<br>herger@chemistry.gatech.edu<br></center><p><b>Navigating the manual:</b><p>At the bottom of the window there are three buttons.  These are:<p>Close - close the manual.<br>Prev - go to the previous manual page.<br>Next - go to the next manual page.<p>The number between Prev and Next tells what page you are viewing.<br>You can jump to any page by selecting the page title from the combo box at the top.<p>A note on keyboard shortcuts:  key names are abbreviated.  For example, \"Ctrl+O\" means hold the control (Ctrl) key and press O.") );

  // Overview
  manpages.append( tr("<b>Overview</b><p>The application window consists of five major elements:<br>The menu bar at the top;<br>The file/edit toolbar below the menu bar;<br>The drawing toolbar, on the left;<br>The status bar, along the bottom;<br>and the drawing area, the large area in the middle.<p>The File/Edit toolbar shows commonly used items which are also found under the File and Edit menus.<p>The Drawing toolbar shows available drawing tools.<p>To get help on a toolbar button, click on the <img source=\"whatsthisicon\"><b>What's This?</b> button, then the button you want help with.<p>The status bar shows error messages, information, and usually a tip on how to use the current drawing tool.<p>The following pages describe all the buttons and menu options.") );

  // The File Menu and Toolbar Buttons
  manpages.append( tr("<b>The File Menu and Toolbar Buttons</b><p><img source=\"fileopenicon\"><b>Open File</b> (Ctrl+O) Open a file. A dialog will appear asking you to select a file. This will overwrite the drawing in the current window!<br>Files which are not native (XDC) format will be scaled to the current fixed length on loading.<p><img source=\"filesaveicon\"><b>Save File</b> (Ctrl+S) Save the current file.  If it is a new file, you will be prompted for a directory and filename to save to.<p><b>Save as...</b> Save the current file with a different name.<br><p><b>Save image</b> Saves the current drawing as an image (BMP, PNG, EPS formats available).  The entire drawing is saved.<p><b>Page Setup</b> Opens a window allowing you to choose paper size and orientation.<p><img source=\"fileprinticon\"><b>Print</b> (Ctrl+P) Prints the current drawing.  A dialog will appear, allowing you to select destination printer or file, paper size, orientation, etc.<p><b>Close</b> (Ctrl+W) Closes this window.<p><b>Quit</b> (Ctrl+Q) Closes all windows and exits the application.") );

  // Drawing
  manpages.append( tr("<b>Drawing</b><p>The toolbar on the left side show available drawing tools.  Click on a tool, then click and drag in the drawing area to draw.<p><img source=\"selecttoolicon\"><b>Select tool</b> Select objects in the drawing.  Click on individual objects to select, or left-click and drag to select multiple objects.<br>After selecting objects, you can move them by dragging with the left mouse button, or roatet them by dragging with the right mouse button.<p><img source=\"erasetoolicon\"><b>Erase tool</b> Erase individual objects. Move mouse over object to highlight and left-click to delete.<p><img source=\"linetoolicon\"><b>Line tool</b> Draw lines (bonds).  This tool will automatically snap endpoints of lines together. Start or finish drawing near the endpoint of another line.  The highlight square will indicate which line it will snap to. Create double and triple bonds by drawing over an existing line.<p><img source=\"dashtoolicon\"><b>Dashed line tool</b> Draw dashed lines.  These can also be drawn over existing bonds to form e.g. aromatic bonds or resonance forms.<p><img source=\"uplinetoolicon\"><b>Up Line tool</b> Draw up-facing "
"stereospecific bonds.<p><img source=\"downlinetoolicon\"><b>Down Line tool</b> Draw down-facing stereospecific bonds.<p><img source=\"arrowtoolicon\"><b>Arrow tool</b> Draw arrows.  Arrows cannot snap to any other object.<p><img source=\"curvearrowtoolicon\"><b>Curved arrow tool</b> Draw curved arrows.  Click and hold this tool and a submenu will appear.  Select a curved arrow from the menu.<p><img source=\"brackettoolicon\"><b>Bracket tool</b> Draw brackets. Click and hold this tool and a submenu will appear.  Select a bracket from the menu. Left-click and drag to draw brackets.<p><img source=\"texttoolicon\"><b>Text tool</b> Add text.  Click on the endpoint of a line or an intersection to label it.<br>The next page describes text in great detail.<p><img source=\"ringtoolicon\"><b>Ring tool</b> Add rings and other predefined molecules. A dialog box will appear with rings and molecules XChemDraw is able to draw.  Or, click and hold to get a picture list of 'favorite' rings.<br>Directions to put molecules on the 'favorite' list appear later.<p><img source=\"symboltoolicon\"><b>Symbol tool</b> Add symbols.  Click and hold for a picture menu of symbols.  Select a symbol from the menu.  Click on a point to put a symbol on that point -- the symbol will move with the point.") );

  // Text
  manpages.append( tr("<b>Text</b><p>Select the <img source=\"texttoolicon\">Text tool to add or edit text.  Click anywhere to add text, click on a point to add a label (e.g., the element or functional group). Click on existing text to edit.<p>While you are editing, select text by dragging over with the cursor, or hold Shift and Arrow-Left or Right.  Use the <img source=\"supericon\">Superscript and <img source=\"subicon\">Subscript buttons on the top toolbar to add or remove super- and subscript. You can also make the text <img source=\"boldtool\"><b>bold</b>, <img source=\"italictool\"><i>italic</i>, or <img source=\"underlinetool\"><u>underlined</u> in a similar manner.<p>While editing, you can change the font and size of the text being edited by changing the font and size on the top toolbar.  Note that this affects the entire text being edited.") );

  // Selecting and Editing
#ifdef UNIX
  QString combiner;
  combiner.append( tr("<b>Selecting and Editing</b><p>Important note:  you can cut, copy, and paste between XDrawChem windows.  It is possible to copy images into other applications, or to drag and drop selections.  If the application will not accept copy or drag and drop, use <b>Save image</b> to create an image, or save as an MDL Molfile.  It is not possible to paste or drag items into XDrawChem from other applications.") );
  combiner.append( tr("<p><b>Selecting, Moving, Drag and Drop</b><p>Select using the <img source=\"selecttoolicon\"><b>Select tool</b>.  Click and drag to highlight a selection.  Alternatively, the Select tool can be used to drag individual objects and points.  Move the cursor over an object and the cursor will become a four-way arrow.  Click and drag with the left button to move.<p>You can drag and drop selections into other applications.  Use the right mouse button to drag the selected region to another application.  The destination application must be able to accept image drops of type image/png or image/bmp.<p><b>Changing objects</b><p>To change an object after drawing it, choose the select tool and highlight the object.  Right-click on it.  A dialog box will appear (except for Text object) allowing you to change properties of the object.<p><b>Rotate and resize</b><p>To rotate or resize, select multiple objects.  A box will appear around the selection.  Click and drag the box in the top right to rotate; click and drag the box in the bottom right to resize.<p><b>Editing</b><br><b>Undo</b> (Ctrl+Z) Undo the last action.  The last 16 actions may be undone.<br><img source=\"cuticon\"><b>Cut</b> (Ctrl+X) Cut a selection from this drawing.<br><img source=\"copyicon\"><b>Copy</b> (Ctrl+C) Copy a selection from this drawing.  The Copy command also copies the selection to the system clipboard as an image.<br><img source=\"pasteicon\"><b>Paste</b> (Ctrl+V) Paste something that was cut or copied.<br><b>Clear</b> (Del) Erases the current selection permanently.<br><b>Select all</b> (Ctrl+A) Select all objects in the drawing.<br>There are two sub-menus:<br><b>Rotate:</b> Rotate the selection by 90, 180, or 270 degrees.<br><b>Flip:</b> Flip the selection about a horizontal or vertical line.") );
  manpages.append( combiner );
#else
  manpages.append( tr("<b>Selecting and Editing</b><p><b>Selecting, Moving, Drag and Drop</b><p>Select using the <img source=\"selecttoolicon\"><b>Select tool</b>.  Click and drag to highlight a selection.  Alternatively, the Select tool can be used to drag individual objects and points.  Move the cursor over an object and the cursor will become a four-way arrow.  Click and drag with the left button to move.<p>You can drag and drop selections into other applications.  Use the right mouse button to drag the selected region to another application.  The destination application must be able to accept image drops of type image/png or image/bmp.<p><b>Changing objects</b><p>To change an object after drawing it, choose the select tool and highlight the object.  Right-click on it.  A dialog box will appear (except for Text object) allowing you to change properties of the object.<p><b>Rotate and resize</b><p>To rotate or resize, select multiple objects.  A box will appear around the selection.  Click and drag the box in the top right to rotate; click and drag the box in the bottom right to resize.<p><b>Editing</b><br><b>Undo</b> (Ctrl+Z) Undo the last action.  The last 16 actions may be undone.<br><img source=\"cuticon\"><b>Cut</b> (Ctrl+X) Cut a selection from this drawing.<br><img source=\"copyicon\"><b>Copy</b> (Ctrl+C) Copy a selection from this drawing.  The Copy command also copies the selection to the system clipboard as an image.<br><img source=\"pasteicon\"><b>Paste</b> (Ctrl+V) Paste something that was cut or copied.<br><b>Clear</b> (Del) Erases the current selection permanently.<br><b>Select all</b> (Ctrl+A) Select all objects in the drawing.<br>There are two sub-menus:<br><b>Rotate:</b> Rotate the selection by 90, 180, or 270 degrees.<br><b>Flip:</b> Flip the selection about a horizontal or vertical line.") );
#endif

  // Formatting
  manpages.append( tr("<b>Formatting</b><p><b>Fixed line length and angles</b> To set fixed line length and angles, check the 'Fixed length/angles' option under the Format menu.  The fixed length may be changed in the 'Set fixed length/angle' dialog.  Units are in pixels.  To print to scale, use 50 pixels as the fixed length, save as an image and print at 100 dpi for 1/2 inch lines, for example.<p><b>Changing font and font size</b> To change font parameters, select a new font and size from the top toolbar.<p><b>Changing color</b> To change color, click on the Set Color button on the top toolbar.  It is the button showing the current drawing color (default is black) with an arrow to the right.  A window will appear allowing you to select the new drawing color.<p><b>Changing the background</b> Select 'Set Background Color' from the Format menu.  A window will appear allowing you to select a new background color.<p><b>Changing line width</b> To change line width, select a line width from the pulldown of numbers to the right of the color list.<p><b>Auto Layout</b> To automatically adjust the position of molecules and arrows, select the objects you wish to line up. Select Auto Layout under the Tools menu or press Ctrl+L.") );

  // Tools
  manpages.append( tr("<b>Tools</b><p>The Tools menu has several useful functions:<br><b>Auto layout</b> (Ctrl+L) is described  on the previous page.<br><b>Calculate empirical formula</b> Select this option and click on a molecule.  A label will appear above the molecule showing its empirical formula.<br><b>Calculate molecular weight</b> Select this option and click on a molecule.  A label will appear under the molecule with its molecular weight.<br><b>Calculate empirical formula</b> Select this option and click on a molecule.  A window will pop up with the percent composition of carbon, hydrogen, oxygen, and nitrogen.<br><b>Predict 13C NMR</b> Select this option and click on a molecule.  A dialog will appear with a picture of the molecule and the predicted peaks.  You can print the picture and peak list exactly as shown on the screen.<br><b>Predict IR</b> Select this option and click on a molecule.  A dialog will appear with a picture of the molecule and the predicted peaks.  You can print the picture and peak list exactly as shown on the screen.<br>") );

  // Internet database searches
  manpages.append( tr("<b>Internet database searches</b>"
"<p>XDrawChem can retrieve molecules from its own network database.  Structures in the database are taken from the public NCI database.  See References in Help menu.<p>Choose Find on Internet from the File menu or press Ctrl+F to open the search dialog.  The server is set at compile time, or by the environment variable XDC_SERVER.  It can also be changed here.  Select CAS-Number or Formula search from the pulldown menu.  Type the search string in the bottom text box.  Check exact match if you want to find an exact formula; CAS number searches are always assumed to be exact match searaches.  Press Search.  If only one molecule is found, it is automatically inserted.  If multiple molecules are found, you will be presented with a list of molecules.  Click on the CAS number to select the molecule and press Select to insert the molecule into the current drawing.") );

  // Rings and molecules...
  manpages.append( tr("<img source=\"ringtoolicon\"><b>Ring and Molecules in XDrawChem's library</b><p>Press and hold the left mouse button on the Ring tool button to open the ring menu.  The following structures are available:<p>Rings: cyclopentane, imidazole, cyclohexane, benzene.<p>Molecules:<br>All 20 standard amino acids.<br>Standard nucleic acids: adenine, guanine, cytosine, thymine, uracil.<p><b>Adding molecules</b><br>To add a molecule to the Ring dialog, simply save a CML format file of it to the RINGDIR directory (see INSTALL.txt).  The molecule will appear by the name it is saved as (e.g., save methyl t-butyl ether as 'mtbe.cml' and 'mtbe' will appear on the molecule list next time the dialog is opened.)<p><b>The Favorite list</b><br>The Favorite list is the last meu item under the ring menu.  To add molecules to this list, simply put the molecule in the RINGDIR directory (see INSTALL.txt), as well as a PNG image of the molecule with the same name.  For instance, one could add acetone by placing a CML file named 'acetone.cml' in RINGDIR, as well as a PNG file named 'acetone.png'.  See files in RINGDIR already; XDrawChem installs with benzene, imidazole, cyclopentane, and cyclohexane on the favorite list.<br>To remove a picture from the Favorite list, delete its corresponding picture (PNG file).") );
}

// Show the manual.  Called by Help/Manual or pressing F1.
void ApplicationWindow::Manual()
{
  XManual *m = new XManual;
  m->show();
}

// Manual dialog box.  Start at page 1.  Pages defined above in manpages[]
XManual::XManual(QWidget *parent, const char *name) : 
  QDialog(parent, name)
{
  InitManPages();
  resize(500,500);
  setCaption("XDrawChem manual");
  qvb = new QVBox(this, "Manual dialog box");
  qvb->setMinimumSize(400,450);
  qvb->setMargin(3);
    
  pagelist = new QComboBox( false, qvb );
  pagelist->insertItem( tr("Title page") );
  pagelist->insertItem( tr("Overview") );
  pagelist->insertItem( tr("File Menu/Toolbar") );
  pagelist->insertItem( tr("Drawing Toolbar") );
  pagelist->insertItem( tr("Text") );
  pagelist->insertItem( tr("Selecting and Editing") );
  pagelist->insertItem( tr("Formatting") );
  pagelist->insertItem( tr("Tools") );
  pagelist->insertItem( tr("Internet search") );
  pagelist->insertItem( tr("Available rings and molecules") );
  connect( pagelist, SIGNAL( activated(int) ), this, SLOT( gotoPage(int) ) );

  pages = new QTextView( qvb );
  pages->setText( manpages[0] );
  QBrush paper( QColor(255,255,255) );
  pages->setPaper( paper );

  QHBox *buttons = new QHBox( qvb );
  buttons->setMargin( 3 );

  bClose = new QPushButton( tr("&Close"), buttons );
  QWidget *w = new QWidget( buttons );
  w->setMaximumHeight( bClose->sizeHint().height() );
  bPrev = new QPushButton( tr("<< &Previous"), buttons );
  bLabel = new QLabel( "1", buttons );
	bLabel->setAlignment(AlignCenter);
  bNext = new QPushButton( tr("&Next >>"), buttons );
  buttons->setMaximumHeight( bNext->sizeHint().height() + 10 );

  bPrev->setEnabled( FALSE );

  connect( bClose, SIGNAL( clicked() ), this, SLOT( close() ) );
  connect( bPrev, SIGNAL( clicked() ), this, SLOT( prevPage() ) );
  connect( bNext, SIGNAL( clicked() ), this, SLOT( nextPage() ) );

  pagenum = 0;
  lastpage = 9;
}

// Turn to previous manual page.
void XManual::prevPage()
{
	if (pagenum == 0) return;
	pagenum--;
	pages->setText(manpages[pagenum]);
	if (pagenum == 0) bPrev->setEnabled(false);
	bNext->setEnabled(true);

	QString q;
	q.setNum(pagenum + 1);
	bLabel->setText( q );

	pagelist->setCurrentItem(pagenum);
}

// Turn to next manual page.
void XManual::nextPage()
{
	if (pagenum == lastpage) return;
	pagenum++;
	pages->setText(manpages[pagenum]);
	if (pagenum == lastpage) bNext->setEnabled(false);
	bPrev->setEnabled(true);

	QString q;
	q.setNum(pagenum + 1);
	bLabel->setText( q );

	pagelist->setCurrentItem(pagenum);
}

// Goto a specific page by number.
// NOTE: gotoPage assumes first page is 0.
void XManual::gotoPage(int thispage)
{
	if (thispage > lastpage) return;
	pagenum = thispage;
	bNext->setEnabled(true);
	bPrev->setEnabled(true);
	if (pagenum == 0) bPrev->setEnabled(false);
	if (pagenum == lastpage) bNext->setEnabled(false);
	pages->setText( manpages[thispage] );
	QString q;
	q.setNum(thispage+1);
	bLabel->setText( QString("Page ") + q );
}

// Handle resize.  Propagates the event to QVBox* qvb, which handles
// resize for its children.
void XManual::resizeEvent(QResizeEvent *re)
{
	qvb->resize( re->size() );
}
