#include <qwidget.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qdialog.h>
#include <qcolor.h>
#include <qfont.h>
#include <qnamespace.h>

// language file
//#include "language.h"
// end language include(s)

#include "render2d.h"
#include "fixeddialog.h"

FixedDialog::FixedDialog(QWidget *parent, QString name) : 
	QDialog(parent, name, TRUE)
{
  QPushButton *ok, *cancel, *def1;
  QLabel *t1, *t2, *t3, *t4;
  setBackgroundColor(lightGray);
  setCaption( tr("Set fixed angle and length") );
  t1 = new QLabel( tr("Bond fixed length:"), this);
  t1->setGeometry(10,10,130,30);
  t1->setBackgroundColor(lightGray);
  t2 = new QLabel( tr("Bond fixed angle:"), this);
  t2->setGeometry(10,50,130,30);
  t2->setBackgroundColor(lightGray);
  bond_length = new QLineEdit(this);
  bond_length->setGeometry(150,10,170,30);
  bond_angle = new QLineEdit(this);
  bond_angle->setGeometry(150,50,170,30);
  t3 = new QLabel( tr("Arrow fixed length:"), this);
  t3->setGeometry(10,90,130,30);
  t3->setBackgroundColor(lightGray);
  t4 = new QLabel( tr("Arrow fixed angle:"), this);
  t4->setGeometry(10,130,130,30);
  t4->setBackgroundColor(lightGray);
  arrow_length = new QLineEdit(this);
  arrow_length->setGeometry(150,90,170,30);
  arrow_angle = new QLineEdit(this);
  arrow_angle->setGeometry(150,130,170,30);
  ok = new QPushButton( tr("OK"), this);
  ok->setGeometry(10,170,100,30);
  ok->setPalette(QPalette(lightGray));
  connect(ok, SIGNAL(clicked()), SLOT(accept()) );
  cancel = new QPushButton( tr("Cancel"), this);
  cancel->setGeometry(230,170,100,30);
  cancel->setPalette(QPalette(lightGray));
  connect(cancel, SIGNAL(clicked()), SLOT(reject()) );
  def1 = new QPushButton( tr("Default"), this);
  def1->setGeometry(120,170,100,30);
  def1->setPalette(QPalette(lightGray));
  connect(def1, SIGNAL(clicked()), SLOT(setDefaults()) );
}

void FixedDialog::setDefaults() {
  QString n;
  n.setNum(25);
  bond_length->setText(n);
  n.setNum(15);
  bond_angle->setText(n);
  n.setNum(50);
  arrow_length->setText(n);
  n.setNum(15);
  arrow_angle->setText(n);
}

void FixedDialog::setLength_bond(double t)
{
  QString n;
  n.setNum(t);

  bond_length->setText(n);
}

void FixedDialog::setAngle_bond(double t)
{
  QString n;
  n.setNum(t);

  bond_angle->setText(n);
}

double FixedDialog::getLength_bond(void)
{
  double t;
  bool b;

  t = bond_length->text().toDouble(&b);
  if (b == true)
    return t;
  return -1.0;
}

double FixedDialog::getAngle_bond(void)
{
  double t;
  bool b;

  t = bond_angle->text().toDouble(&b);
  if (b == true)
    return t;
  return -1.0;
}

void FixedDialog::setLength_arrow(double t)
{
  QString n;
  n.setNum(t);

  arrow_length->setText(n);
}

void FixedDialog::setAngle_arrow(double t)
{
  QString n;
  n.setNum(t);

  arrow_angle->setText(n);
}

double FixedDialog::getLength_arrow(void)
{
  double t;
  bool b;

  t = arrow_length->text().toDouble(&b);
  if (b == true)
    return t;
  return -1.0;
}

double FixedDialog::getAngle_arrow(void)
{
  double t;
  bool b;

  t = arrow_angle->text().toDouble(&b);
  if (b == true)
    return t;
  return -1.0;
}
