// chemdata.h --  the class that manages all of XDrawChem's data.

#ifndef CHEMDATA_H
#define CHEMDATA_H

#include <qobject.h>
#include <qlist.h>
#include <qstringlist.h>

#include "drawable.h"
#include "bond.h"
#include "text.h"
#include "cml.h"

class Render2D;
class Clipboard;

class ChemData : public QObject {
  Q_OBJECT
 public:
  void setRender2D(Render2D *r1) { r = r1; }
  Render2D *getRender2D() { return r; }
  bool edited() { return false; }
  // defined in chemdata.cpp
  ChemData(Clipboard *, QObject *parent = 0, const char *name = 0);
  void drawAll();
  void addBond(DPoint *, DPoint *, int, int, QColor, bool hl = false);
  void addArrow(DPoint *, DPoint *, QColor, int, bool hl = false);
  void addCurveArrow(DPoint *, DPoint *, QColor, QString, bool hl = false);
  void addBracket(DPoint *, DPoint *, QColor, int, bool hl = false);
  void addText(Text *);
  void addSymbol(DPoint *, QString);
  void Erase(Drawable *);
  void EraseSelected();
  void DetectSplit();
  DPoint *FindNearestPoint(DPoint *, double &);
  Drawable *FindNearestObject(DPoint *, double &);
  void NewSelectRect(QRect, bool);
  void SelectAll(void);
  void DeselectAll(void);
  void Move(double, double);
  void Resize(DPoint *, double);
  void Rotate(DPoint *, double);
  void Flip(DPoint *, int);
  void SetColorIfHighlighted(QColor);
  QRect selectionBox();
  QList<DPoint> UniquePoints();
  QList<Drawable> UniqueObjects();
  void SetTopLeft(QPoint p) { RenderTopLeft = p; }
  // defined in chemdata_edit.cpp
  void Cut();
  void Copy();
  bool Paste();
  void StartUndo(int, DPoint *);
  bool Undo();
  // defined in chemdata_rw.cpp
  bool load(QString);
  bool save(QString);
  bool load_legacy(QString);
  // defined in chemdata_xdc.cpp
  bool load_native(QString);
  bool save_native(QString);
  // defined in chemdata_cdx.cpp
  bool save_cdx(QString);
  bool save_cdxml(QString);
  // defined in chemdata_mdl.cpp
  bool load_mdl(QString);
  bool ProcessMDL(QString);
  bool save_mdl(QString);
  // defined in chemdata_xml.cpp
  bool load_xml(QString);
  bool ProcessXML(QString);
  bool LoadCDXMLFile(QString, QString);
  bool SelfContainedTag(QString);
  QString ReadTag(QString, int &);
  QString ReadData(QString, int &);
  QStringList ReadAttr(QString);
  QStringList Tokenize(QString);
  void ParseBoundingBox(QString, double &, double &, double &, double &);
  // defined in chemdata_cml.cpp
  bool LoadCMLFile(QString, QString);
  bool save_cml(QString);
  void Convert_CML_Lists_To_Native();
  // defined in chemdata_tools.cpp
  void CalcMW();
  void Tool(DPoint *, int);
  void AutoLayout();
  void fromSMILES(QString);
  // defined in cdx2cdxml.cpp
  QString ParseProperty(QByteArray);
  QString CDXToCDXML(QString);

 signals:
  void SignalSetStatusBar(QString);

 private:
  // the Render2D widget this ChemData is linked to
  Render2D *r;
  // Top left corner of visible part of r
  QPoint RenderTopLeft;
  // Application clipboard
  Clipboard *clip;
  // temporary/current Drawable (temporary DPoint *tmp_pt defined below)
  Drawable *tmp_draw;
  // list of Drawable objects we are tracking
  QList<Drawable> drawlist;
  // Variables for reading CML/CDXML/XML files
  QString MoleculeTitle;
  QString MoleculeId;
  QList<CML_Atom> CML_Atoms;
  QList<CML_Atom> CML_Atoms_Sub;
  QList<CML_Bond> CML_Bonds;
  QList<CML_Bond> CML_Bonds_Sub;
  QList<int> TagStack;
  QList<Drawable> CDXML_Objects;
  DPoint *tmp_pt;
  CML_Atom *tmp_atom;
  CML_Bond *tmp_bond;
  // variables for Undo
  int undo_last;
  DPoint *undo_start, *undo_end;
  double undo_dx, undo_dy;
  QStringList last_states;
  QString current_undo_file;
};

#endif
