#include "application.h"

// language file
//#include "language.h"
// end language include(s)

#include <iostream.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>

#include <qimage.h>
#include <qbitmap.h>
#include <qpixmap.h>
#include <qtooltip.h>
#include <qtoolbar.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qkeycode.h>
#include <qmultilineedit.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qstatusbar.h>
#include <qmessagebox.h>
#include <qprinter.h>
#include <qapplication.h>
#include <qaccel.h>
#include <qtextstream.h>
#include <qpainter.h>
#include <qpushbutton.h>
#include <qcolordialog.h>
#include <qpaintdevicemetrics.h>
#include <qwhatsthis.h>
#include <qscrollview.h>
#include <qcombobox.h>
#include <qfont.h>
#include <qdir.h>
#include <qstringlist.h>
#include <qmime.h>

#include "defs.h"
#include "chemdata.h"
#include "render2d.h"

// canned structures
#define RING_3 100
#define RING_4 101
#define RING_5 102
#define RING_6 103
#define RING_BOAT6 104
#define RING_CHAIR6 105
#define RING_IMIDAZOLE 106
#define RING_CYCLOPENTADIENE 107
#define RING_BENZENE 108
#define NA_ADENINE  200
#define NA_CYTOSINE 201
#define NA_GUANINE  202
#define NA_THYMINE  203
#define NA_URACIL   204
#define AA_ALANINE 300
#define AA_ARGININE 301
#define AA_ASPARAGINE 302
#define AA_ASPARTIC_ACID 303
#define AA_CYSTEINE 304
#define AA_GLUTAMIC_ACID 305
#define AA_GLUTAMINE 306
#define AA_GLYCINE 307
#define AA_HISTIDINE 308
#define AA_ISOLEUCINE 309
#define AA_LEUCINE 310
#define AA_LYSINE 311
#define AA_METHIONINE 312
#define AA_PHENYLALANINE 313
#define AA_PROLINE 314
#define AA_SERINE 315
#define AA_THREONINE 316
#define AA_TRYPTOPHAN 317
#define AA_TYROSINE 318
#define AA_VALINE 319
#define S_RIBOSE 400
#define S_DEOXYRIBOSE 401
#define S_D_FRUCTOSE 402
#define S_D_GLUCOSE 403
// end structures

QPopupMenu *ApplicationWindow::BuildNewRingMenu() {
  QPopupMenu * ringSub = new QPopupMenu(this);

  // make generic ring list
  QPopupMenu * genericSub = new QPopupMenu(this);
  genericSub->insertItem( tr("Cyclopropane"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_3 );
  genericSub->insertItem( tr("Cyclobutane"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_4 );
  genericSub->insertItem( tr("Cyclopentane"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_5 );
  genericSub->insertItem( tr("Imidazole"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_IMIDAZOLE );
  genericSub->insertItem( tr("Cyclopentadiene"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_CYCLOPENTADIENE );
  genericSub->insertItem( tr("Cyclohexane (flat)"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_6 );
  genericSub->insertItem( tr("Cyclohexane (boat)"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_BOAT6 );
  genericSub->insertItem( tr("Cyclohexane (chair)"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_CHAIR6 );
  genericSub->insertItem( tr("Benzene"), 
			  this, SLOT(FromNewRingMenu(int)), 0,
			  RING_BENZENE );
  ringSub->insertItem( tr("Rings"), genericSub );

  // make amino acid list
  QPopupMenu * aaSub = new QPopupMenu(this);
  aaSub->insertItem( tr("Alanine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_ALANINE );
  aaSub->insertItem( tr("Arginine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_ARGININE );
  aaSub->insertItem( tr("Asparagine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_ASPARAGINE );
  aaSub->insertItem( tr("Aspartic acid"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_ASPARTIC_ACID );
  aaSub->insertItem( tr("Cysteine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_CYSTEINE );
  aaSub->insertItem( tr("Glutamic acid"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_GLUTAMIC_ACID );
  aaSub->insertItem( tr("Glutamine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_GLUTAMINE );
  aaSub->insertItem( tr("Glycine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_GLYCINE );
  aaSub->insertItem( tr("Histidine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_HISTIDINE );
  aaSub->insertItem( tr("Isoleucine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_ISOLEUCINE );
  aaSub->insertItem( tr("Leucine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_LEUCINE );
  aaSub->insertItem( tr("Lysine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_LYSINE );
  aaSub->insertItem( tr("Methionine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_METHIONINE );
  aaSub->insertItem( tr("Phenylalanine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_PHENYLALANINE );
  aaSub->insertItem( tr("Proline"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_PROLINE );
  aaSub->insertItem( tr("Serine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_SERINE );
  aaSub->insertItem( tr("Threonine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_THREONINE );
  aaSub->insertItem( tr("Tryptophan"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_TRYPTOPHAN );
  aaSub->insertItem( tr("Tyrosine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_TYROSINE );
  aaSub->insertItem( tr("Valine"), this, SLOT(FromNewRingMenu(int)), 0,
		     AA_VALINE );
  ringSub->insertItem( tr("Amino acids"), aaSub );

  // make nucleic acid list
  QPopupMenu * naSub = new QPopupMenu(this);
  naSub->insertItem( tr("Adenine"), this, SLOT(FromNewRingMenu(int)), 0,
		     NA_ADENINE );
  naSub->insertItem( tr("Cytosine"), this, SLOT(FromNewRingMenu(int)), 0,
		     NA_CYTOSINE );
  naSub->insertItem( tr("Guanine"), this, SLOT(FromNewRingMenu(int)), 0,
		     NA_GUANINE );
  naSub->insertItem( tr("Thymine"), this, SLOT(FromNewRingMenu(int)), 0,
		     NA_THYMINE );
  naSub->insertItem( tr("Uracil"), this, SLOT(FromNewRingMenu(int)), 0,
		     NA_URACIL );
  ringSub->insertItem( tr("Nucleic acids"), naSub );

  // make sugar list
  QPopupMenu * sugarSub = new QPopupMenu(this);
  sugarSub->insertItem( tr("Ribose"), 
			this, SLOT(FromNewRingMenu(int)), 0,
			S_RIBOSE );
  sugarSub->insertItem( tr("Deoxyribose"), 
			this, SLOT(FromNewRingMenu(int)), 0,
			S_DEOXYRIBOSE );
  sugarSub->insertItem( tr("D-fructose"), 
			this, SLOT(FromNewRingMenu(int)), 0,
			S_D_FRUCTOSE );
  sugarSub->insertItem( tr("D-glucose"), 
			this, SLOT(FromNewRingMenu(int)), 0,
			S_D_GLUCOSE );
  ringSub->insertItem( tr("Sugars"), sugarSub );

  // make user-defined list
  QPopupMenu * userDefSub = new QPopupMenu(this);
  QDir d(RingDir, "*.png");
  ringlist = d.entryList();
  for (int cc = 0; cc < ringlist.count(); cc++) {
    QPixmap px1( QString(RingDir + ringlist[cc]) );
    QBitmap mask1( px1.width(), px1.height() );
    mask1.fill(Qt::color1);
    px1.setMask(mask1);
    /*userDefSub->insertItem( QPixmap( QString(RingDir + ringlist[cc]) ),
			    ringlist[cc],
			    this, SLOT(FromRingMenu(int)), 0, cc );*/
    userDefSub->insertItem( px1,
			    ringlist[cc].left(ringlist[cc].length() - 4),
			    this, SLOT(FromRingMenu(int)), 0, cc );
  }
  //userDefSub->insertItem( tr("Add new...") );
  ringSub->insertItem( tr("User-defined"), userDefSub );

  return ringSub;
}

void ApplicationWindow::FromNewRingMenu(int x) {
  c->StartUndo(0,0);
  c->DeselectAll();
  c->SetTopLeft(sv->viewportToContents(QPoint(0,0)));
  QString fname;
  if (x == RING_3) fname = "cyclopropane.cml";
  if (x == RING_4) fname = "cyclobutane.cml";
  if (x == RING_5) fname = "cyclopentane.cml";
  if (x == RING_IMIDAZOLE) fname = "imidazole.cml";
  if (x == RING_CYCLOPENTADIENE) fname = "cyclopentadiene.cml";
  if (x == RING_6) fname = "cyclohexane.cml";
  if (x == RING_BOAT6) fname = "6ring_boat.cml";
  if (x == RING_CHAIR6) fname = "6ring_chair.cml";
  if (x == RING_BENZENE) fname = "benzene.cml";
  if (x == NA_ADENINE) fname = "adenine.cml";
  if (x == NA_CYTOSINE) fname = "cytosine.cml";
  if (x == NA_GUANINE) fname = "guanine.cml";
  if (x == NA_THYMINE) fname = "thymine.cml";
  if (x == NA_URACIL) fname = "uracil.cml";
  if (x == AA_ALANINE) fname = "alanine.cml";
  if (x == AA_ARGININE) fname = "arginine.cml";
  if (x == AA_ASPARTIC_ACID) fname = "aspartic_acid.cml";
  if (x == AA_ASPARAGINE) fname = "asparagine.cml";
  if (x == AA_CYSTEINE) fname = "cysteine.cml";
  if (x == AA_GLUTAMIC_ACID) fname = "glutamic_acid.cml";
  if (x == AA_GLUTAMINE) fname = "glutamine.cml";
  if (x == AA_GLYCINE) fname = "glycine.cml";
  if (x == AA_HISTIDINE) fname = "histidine.cml";
  if (x == AA_ISOLEUCINE) fname = "isoleucine.cml";
  if (x == AA_LEUCINE) fname = "leucine.cml";
  if (x == AA_LYSINE) fname = "lysine.cml";
  if (x == AA_METHIONINE) fname = "methionine.cml";
  if (x == AA_PHENYLALANINE) fname = "phenylalanine.cml";
  if (x == AA_PROLINE) fname = "proline.cml";
  if (x == AA_SERINE) fname = "serine.cml";
  if (x == AA_THREONINE) fname = "threonine.cml";
  if (x == AA_TRYPTOPHAN) fname = "tryptophan.cml";
  if (x == AA_TYROSINE) fname = "tyrosine.cml";
  if (x == AA_VALINE) fname = "valine.cml";
  if (x == S_RIBOSE) fname = "ribose.cml";
  if (x == S_DEOXYRIBOSE) fname = "deoxyribose.cml";
  if (x == S_D_FRUCTOSE) fname = "d-fructose.cml";
  if (x == S_D_GLUCOSE) fname = "d-glucose.cml";
  c->load( RingDir + fname );
  r->Inserted();
}
