/* ########################################################################

			      tool_bar.c

   File: 
   Path: 
   Description: 
   Created: Sun Jan 26 15:44:05 MET 1997
   Author: Lionel Fournigault
   Modified: Sun Jan 26 15:44:07 MET 1997
   Last maintained by: Lionel Fournigault

   RCS $Revision$ $State$
   

   ########################################################################

   Note: 

   ########################################################################

   Copyright (c) : Lionel Fournigault

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   ######################################################################## */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <sys/types.h>
#include <sys/time.h>
#include <signal.h>

#if HAVE_STRING_H
#include <string.h>
#else
#include <strings.h>
#endif

#include "xcoral.h"
#include "get_file.h"
#include "new_window.h"
#include "chars_cmds.h"
#include "man_box.h"
#include "mark_reg.h"
#include "page.h"
#include "main_events.h"
#include "parse.h"
#include "shadow.h"

#include "tool_bar.h"
#include "buttons_bits.h"
#include "browser_init.h"

extern Display *dpy;

void (*f_tb_window []) () = {
  MenuReadFile,
  NewWindow,
  MenuSaveFile,
  DeleteBytesFromCutBuffer,
  PasteSelection,
  DoUndo,
  SetDefaultMode,
  SetCMode,
  SetCCMode,
  SetJavaMode,
  SetLatexMode,
  DisplayBrowser,
  ColorBuffer,
  DisplayManBox,
  ProgrammingUtil,
  LatexMacros,
  HtmlMacros,
  RcsCommands,
/*  MiscCommands, */
  0
};

static unsigned char *bname [] = {
  "Open file",
  "New window",
  "Save file",
  "Cut",
  "Paste",
  "Undo",
  "Default mode",
  "C mode",
  "C++ mode",
  "Java mode",
  "LaTeX mode",
  "Class Browser",
  "Syntax highlight",
  "Manual",
  "Programming utilities",
  "LaTeX utilities",
  "Html utilities",
  "Rcs utilities",
/*  "Utils cmds", */
  0
};

static unsigned char *bitmap_name [] = {
  dired_bits,
  new_window_bits,
  save_bits,
  cut_bits,
  paste_bits,
  undo_bits,
  dlt_bits,
  c_bits,
  cplus_bits,
  java_bits,
  latex_bits,
  browser_bits,
  color_bits,
  man_bits,
  cc_util_bits,
  latex_util_bits,
  html_bits,
  rcs_bits,
/*  cmds_bits, */
  0
};

static unsigned char **xpm_name [] = {
  xpm_dired_bits,
  xpm_new_window_bits,
  xpm_save_bits,
  xpm_cut_bits,
  xpm_paste_bits,
  xpm_undo_bits,
  xpm_dlt_bits,
  xpm_c_bits,
  xpm_cplus_bits,
  xpm_java_bits,
  xpm_latex_bits,
  xpm_browser_bits,
  xpm_color_bits,
  xpm_man_bits,
  xpm_cc_util_bits,
  xpm_latex_util_bits,
  xpm_html_bits,
  xpm_rcs_bits,
/*  xpm_cmds_bits, */
  0
};

static   unsigned long tb_fg, tb_bg, tb_top_sh, 
  tb_bot_sh, bg_parent, tb_green, tb_red, tb_blue;
static GC tb_gc;
static Pixmap logo_pix, slogo_pix;
static Pixmap b_pix [24], logo_pixmap,logo_mask;
static XImage *b_image [24], *logo_image;

/*
**	Function name : InitToolBar
**
**	Description :
**	Input :
**	Output :
*/
void InitToolBar(bg, ts, bs)
    unsigned long bg, ts, bs;
{
  XGCValues 	gcv;
  Window		root;
  unsigned long gray, gainsboro, dimgray;
  int result, depth, i;
  
  root = DefaultRootWindow ( dpy );
  tb_gc = XCreateGC ( dpy, root, 0, &gcv );
  depth = DefaultDepth ( dpy, DefaultScreen ( dpy ));

  gray = PixelValue ( dpy, "lightgrey", &result );
  if ( result == False )
    gray = WhitePixel ( dpy, DefaultScreen (dpy));
  gainsboro = PixelValue ( dpy, "gainsboro", &result );
  if ( result == False )
    gainsboro = WhitePixel ( dpy, DefaultScreen (dpy));
  dimgray = PixelValue ( dpy, "dimgray", &result );
  if ( result == False )
    dimgray = WhitePixel ( dpy, DefaultScreen (dpy));
  tb_green = PixelValue ( dpy, "green", &result );
  if ( result == False )
     tb_green= BlackPixel ( dpy, DefaultScreen (dpy));
  tb_red = PixelValue ( dpy, "red", &result );
  if ( result == False )
     tb_green= BlackPixel ( dpy, DefaultScreen (dpy));
  tb_blue = PixelValue ( dpy, "blue", &result );
  if ( result == False )
     tb_green= BlackPixel ( dpy, DefaultScreen (dpy));
   
  if ( UseColor () == True) {
    tb_top_sh = ts;
    tb_bot_sh = bs;
  }
  else {
    tb_top_sh = WhitePixel ( dpy, DefaultScreen (dpy));
    tb_bot_sh = BlackPixel ( dpy, DefaultScreen (dpy));
    tb_green = BlackPixel ( dpy, DefaultScreen (dpy));
  }

  tb_fg = BlackPixel ( dpy, DefaultScreen (dpy));
  tb_bg = gray;
  
  bg_parent = bg;

  XSetState ( dpy, tb_gc, tb_fg, tb_bg, GXcopy, AllPlanes );
  for (i=0;i<N_BTOOLS;i++) {
    if ((depth == 16)||(depth == 24)) {
      b_image [i] = (XImage *)LoadImage256 ((char **)xpm_name [i]);
      b_pix [i] = XCreatePixmap (dpy, root, 32, 32, depth);
      XPutImage (dpy, b_pix [i], tb_gc, b_image[i], 0, 0, 0, 0, 32, 32);
    }
    else {
      b_pix [i] = XCreatePixmapFromBitmapData ( dpy, root, 
				   (char *) bitmap_name [i],
				   TOOL_WINDOW_SIZE,
				   TOOL_WINDOW_SIZE, 
				   tb_fg, tb_bg, depth );
    }
  }
}


/*
**	Function name : CreateToolBar
**
**	Description :
**	Input :
**	Output :
*/
ToolBar *CreateToolBar(parent, x, y)
    Window parent;
    int x, y;
{
  int i = 0;
  int depth;
  Window root;
  XWindowAttributes att;
  
  ToolBar *tb = (ToolBar *) malloc (sizeof(ToolBar)+2);
   
  depth = DefaultDepth ( dpy, DefaultScreen ( dpy ));
  root = DefaultRootWindow ( dpy );

  for (i=0;i<N_BTOOLS;i++) {
    tb -> tw [i].w = 
      XCreateSimpleWindow(dpy, 
			  parent, 
			  x + (i * (TOOL_WINDOW_SIZE+1)), y + 2, 
			  TOOL_WINDOW_SIZE, TOOL_WINDOW_SIZE,
			  0, 
			  BlackPixel(dpy, DefaultScreen(dpy)),
			  WhitePixel(dpy, DefaultScreen(dpy)));
    
    tb -> tw [i].f = f_tb_window[i];
    XSelectInput ( dpy, tb -> tw [i].w, ExposureMask | ButtonPressMask | ButtonReleaseMask  
		  | EnterWindowMask );

    tb -> tw [i].pix = b_pix [i];
    XSetWindowBackgroundPixmap ( dpy, tb -> tw [i].w, tb -> tw [i].pix );
    tb -> tw [i].title = bname [i];
  }
  
  XGetWindowAttributes ( dpy, parent, &att );
  tb -> y = y;
  tb -> w_logo = XCreateSimpleWindow(dpy, 
			  parent, 
/*			  x + (20 * (TOOL_WINDOW_SIZE+1)), */
		          att.width - (2 * TOOL_WINDOW_SIZE),
				     y + 2,
			  (2 * TOOL_WINDOW_SIZE), TOOL_WINDOW_SIZE,
			  0, BlackPixel(dpy, DefaultScreen(dpy)) /*bg_parent*/, 
			       bg_parent);
  
  XSelectInput ( dpy, tb -> w_logo, ExposureMask );

  if ((depth == 16)||(depth == 24)) {
    logo_image = (XImage *)LoadImage256 ((char **)xpm_logo);
    logo_pixmap = XCreatePixmap (dpy, root, 32, 32, depth);
    /* Le mask */
    logo_mask = XCreatePixmapFromBitmapData ( dpy, root, 
				   logo_bits,
				   TOOL_WINDOW_SIZE,
				   TOOL_WINDOW_SIZE, 
				   BlackPixel(dpy, DefaultScreen(dpy)),
					     bg_parent, 1 );
    XPutImage (dpy, logo_pixmap, tb_gc, logo_image, 0, 0, 0, 0, 32, 32);
  }

/*  XSetWindowBackgroundPixmap ( dpy, tb -> w_logo, logo_pixmap); */
  logo_pix = XCreatePixmapFromBitmapData ( dpy, root, 
				   /* xlogo32_bits, */
					  bwlogo_bits,
				   TOOL_WINDOW_SIZE,
				   TOOL_WINDOW_SIZE, 
				   BlackPixel(dpy, DefaultScreen(dpy)),
					  bg_parent, depth);
 
  slogo_pix = XCreatePixmapFromBitmapData ( dpy, root,
					   slogo_bits,
					   40, 8,
					   BlackPixel(dpy, DefaultScreen(dpy)),
					   bg_parent, depth );
 
  return (tb);
}

/*
**	Function name : DisplayToolBar
**
**	Description :
**	Input :
**	Output :
*/
void DisplayToolBar(tool_bar, width)
    ToolBar *tool_bar;
    int width;
{
  int i = 0;

  for (i=0;i<N_BTOOLS;i++) {
    XMapWindow(dpy, tool_bar -> tw [i].w);
  }
  XMoveWindow ( dpy, tool_bar -> w_logo, 
	       width - (2 * TOOL_WINDOW_SIZE),
	       tool_bar -> y + 2);
  XMapWindow(dpy, tool_bar -> w_logo);
}


/*
**	Function name : ExposeToolBar
**
**	Description :
**	Input :
**	Output :
*/
int ExposeToolBar(tool_bar, ev)
    ToolBar *tool_bar;
    XEvent *ev;
{
  int i = 0;

  for (i=0;i<N_BTOOLS;i++) {
    if (tool_bar -> tw [i].w == ev -> xexpose.window) {
      if ((DefaultDepth(dpy,DefaultScreen(dpy)) == 16)
	  ||(DefaultDepth(dpy,DefaultScreen(dpy)) == 24))
	Display3D ( dpy, ev -> xexpose.window, tb_top_sh, tb_bot_sh, 1, 0 );
      else
	Display3D ( dpy, ev -> xexpose.window, tb_top_sh, tb_bot_sh, 2, 0 );
	
      if ((i==COLOR_BUTTON)&&(DefaultDepth(dpy,DefaultScreen(dpy))==8)) {
	XSetForeground (dpy, tb_gc, tb_red);
	XFillRectangle(dpy, tool_bar -> tw [i].w, tb_gc, 7, 7, 11, 5);
	XSetForeground (dpy, tb_gc, tb_green);
	XFillRectangle(dpy, tool_bar -> tw [i].w, tb_gc, 14, 14, 11, 5);
	XSetForeground (dpy, tb_gc, tb_blue);
	XFillRectangle(dpy, tool_bar -> tw [i].w, tb_gc, 8, 21, 11, 5);
	XSetForeground (dpy, tb_gc, tb_fg);
      }

      return (True);
    }
  }
  if (tool_bar -> w_logo == ev -> xexpose.window) {
    if ((DefaultDepth(dpy,DefaultScreen(dpy)) == 16)
	||(DefaultDepth(dpy,DefaultScreen(dpy)) == 24)) {
      XSetClipMask(dpy, tb_gc, logo_mask);
      XCopyArea (dpy, logo_pixmap, tool_bar -> w_logo, tb_gc, 0, 0, 32, 32, 0, 0);
      XSetClipMask(dpy, tb_gc, None);
      XCopyArea (dpy, slogo_pix, tool_bar -> w_logo, tb_gc, 0, 0, 40, 8, 12, 22);
      return (True);
    }
    else {
      /* Affiche le logo en noir et blanc */
      XCopyArea (dpy, logo_pix, tool_bar -> w_logo, tb_gc, 0, 0, 32, 32, 0, 0);
      /* Affiche la chaine xcoral */
      XCopyArea (dpy, slogo_pix, tool_bar -> w_logo, tb_gc, 0, 0, 40, 8, 12, 24);
      return (True);
    }
  }
  return (False);
}

/*
**	Function name : ToolBarButton
**
**	Description :
**	Input :
**	Output :
*/
int ToolBarButton(edwin, ev)
    EdWin *edwin;
    XEvent *ev;
{
  int i = 0;
  Window w = ev -> xbutton.window;

  for (i=0;i<N_BTOOLS;i++) {
    if (edwin -> tool_bar -> tw [i].w == ev -> xbutton.window) {
      Display3D ( dpy, w, tb_top_sh, tb_bot_sh, 1, 1 );
      (f_tb_window [i])(edwin -> text);
      Display3D ( dpy, w, tb_top_sh, tb_bot_sh, 1, 0 );
      return (True);
    }
  }
  return (False);
}

int EnterInToolBar (t, w)
    EdWin *t;
    Window w;
{
  int i = 0;

  for (i=0;i<N_BTOOLS;i++) {
    if (w == t -> tool_bar -> tw [i].w) {
        DisplayMessage ( t -> mwin, t -> tool_bar -> tw [i].title );
	return True;
    }
  }
  return False;
}

