import re
import sys

count = 0

m = re.compile(r'^#define\s+(XP_\w+)\s+(\d+)$')
f = sys.stdin

print ("""/* XChat
   This file was generated by sigextract.py by Adam Langley
   agl@linuxpower.org

   It should *not* be edited by hand!

   AGL
*/

struct signalmapping {
   char *name;
   int num;
};

static struct signalmapping signal_mapping[] = {""")

for x in f.readlines():
    s = m.search(x)
    if s:
        print "   {\"" + s.group(1) + "\", " + s.group(2) + "},"
        count = count + 1

print ("   {NULL, 0}\n};\n\n")
print '#define NUM_SIGNALS_LOOKUP ',
print (count)




