 /*
 *  file      : win_info.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2012 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */


#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#include <gtk/gtk.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "win_info.h"




typedef struct {

	GtkWidget	*AdrWin;
	gboolean	IsShow;
	
} VAR_WININFO;

VAR_WININFO	VarWinInfo = { NULL, FALSE };


// QUITTER
// 
gboolean on_wind_info_destroy_event( GtkWidget *widget, GdkEvent *event, gpointer user_data )
{
	VarWinInfo.IsShow = FALSE;
	gtk_widget_hide (VarWinInfo.AdrWin);
	return TRUE;
}
// QUITTER
// 
gboolean on_wind_info_delete_event( GtkWidget *widget, GdkEvent *event, gpointer user_data )
{
	VarWinInfo.IsShow = FALSE;
	gtk_widget_hide (VarWinInfo.AdrWin);
	return TRUE;
}
// QUITTER
// 
void on_button_quitter_wininfo_clicked (GtkButton *button, gpointer user_data)
{
	VarWinInfo.IsShow = FALSE;
	gtk_widget_hide (VarWinInfo.AdrWin);
}
// WIN-READER OPEN
// 
void wininfo_create( GtkWidget *p_WindMain, gchar *title, ... )
{
	gchar		*StrTitle = NULL;
	va_list		Arguments;
	gchar		*PtrArg = NULL;
	GString		*StrTxt = NULL;
	
	if (TRUE == VarWinInfo.IsShow) {
		gdk_window_raise (VarWinInfo.AdrWin->window);
	}
	else {		
		if (NULL == VarWinInfo.AdrWin) {
			VarWinInfo.AdrWin = GTK_WIDGET (GLADE_GET_OBJECT("wind_info"));
			gtk_builder_connect_signals (GtkXcfaProjet, NULL);
		}
		gtk_window_set_transient_for (GTK_WINDOW(VarWinInfo.AdrWin), GTK_WINDOW(p_WindMain));
		gtk_window_set_modal (GTK_WINDOW (VarWinInfo.AdrWin), TRUE);
		libutils_set_default_icone_to_win (VarWinInfo.AdrWin);
		
		StrTitle = g_strdup_printf ("\n              <span font_desc=\"Courier bold 14\"><b>%s</b></span>              \n", title);
		gtk_label_set_markup (GTK_LABEL (GLADE_GET_OBJECT("label_titre_wininfo")), StrTitle);
		g_free (StrTitle);	StrTitle = NULL;
	
		StrTxt = g_string_new (NULL);					//  Creation du GString
		va_start (Arguments, title);					//  Debut des arguments
		while ( *(PtrArg = va_arg (Arguments, gchar *)) != '\0') {	//  TANSQUE message ALORS
			g_string_append_printf (StrTxt, "%s", &PtrArg[0]);	//  	message.stock
		}								//  FIN_TANSQUE
		va_end (Arguments);						//  Fin des arguments
		g_string_append_printf (StrTxt, "\n\n");
		
		gtk_label_set_markup (GTK_LABEL (GLADE_GET_OBJECT("label_texte_wininfo")), StrTxt->str);
		g_string_free (StrTxt, TRUE);
		
		gtk_window_set_title (GTK_WINDOW(VarWinInfo.AdrWin), title);
		
		gtk_widget_show (VarWinInfo.AdrWin);
	}
	VarWinInfo.IsShow = TRUE;
}










