 /*
 *  file    : tags_wav.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2012 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "tags.h"



// 
// 
void tagswav_close_file( WAVE *WaveHeader )
{
	if (NULL != WaveHeader->file) {
		fclose(WaveHeader->file);  
		WaveHeader->file = NULL;
	}
}
// 
// 
void tagswav_init (WAVE *WaveHeader)
{
	WaveHeader->RIFF.ChunkID [ 0 ]     = '\0';
	WaveHeader->RIFF.ChunkSize         = 0;
	WaveHeader->RIFF.Format [ 0 ]      = '\0';
	WaveHeader->FMT.Subchunk1ID [ 0 ]  = '\0';
	WaveHeader->FMT.Subchunk1Size      = 0;
	WaveHeader->FMT.AudioFormat        = 0;
	WaveHeader->FMT.NumChannels        = 0;
	WaveHeader->FMT.SampleRate         = 0;
	WaveHeader->FMT.ByteRate           = 0;
	WaveHeader->FMT.Blockalign         = 0;
	WaveHeader->FMT.BitsPerSample      = 0;
	WaveHeader->DATA.Subchunk2ID [ 0 ] = '\0';
	WaveHeader->DATA.Subchunk2Size     = 0;
	WaveHeader->DATA.data              = NULL;
	WaveHeader->file                   = NULL;
}
// 
// 
gboolean tagswav_read_file (gchar *wave_file, WAVE *WaveHeader)
{  
 	unsigned char 	devbuf[ BLOCK_SIZE +10 ];
 	gint		n_read;
	gint		tt_read = 0;
	gint		cpt;
	gboolean	BoolFound = FALSE;
	
	// PRINT_FUNC_LF();
	// g_print("\t%s\n", wave_file);
	
	// INIT STRUCTURE
	tagswav_init (WaveHeader);
	
	// ouverture/lecture du fichier wave_file en mode binaire (rb) : lecture en octets  
	if (NULL == (WaveHeader->file = fopen(wave_file, "rb"))) { 
		// gestion d'erreurs 
		g_print ("\nERREUR: fichier  %s  introuvable\n", wave_file);  
		return (FALSE);
	}  
  
	// lecture des données du fichier .wav et stockage de celle-ci dans les champs adéquats de la structure WAVE
	n_read = fread(&WaveHeader->RIFF.ChunkID, 4, 1, WaveHeader->file);		// RIFF
	n_read = fread(&WaveHeader->RIFF.ChunkSize, 4, 1, WaveHeader->file);		// taille du fichier entier en octets (sans compter les 8 octets de ce champ et le champ précédent
	n_read = fread(&WaveHeader->RIFF.Format, 4, 1, WaveHeader->file);		// WAVE
	n_read = fread(&WaveHeader->FMT.Subchunk1ID, 4, 1, WaveHeader->file);		// 'fmt '
	n_read = fread(&WaveHeader->FMT.Subchunk1Size, 4, 1, WaveHeader->file);		// taille en octet des données à suivre
	n_read = fread(&WaveHeader->FMT.AudioFormat, 2, 1, WaveHeader->file);		// format de compression (une valeur autre que 1 indique une compression) 
	n_read = fread(&WaveHeader->FMT.NumChannels, 2, 1, WaveHeader->file);		// nombre de canaux
	n_read = fread(&WaveHeader->FMT.SampleRate, 4, 1, WaveHeader->file);		// fréquence d'échantillonage (nombre d'échantillons par secondes) 
	n_read = fread(&WaveHeader->FMT.ByteRate, 4, 1, WaveHeader->file);		// nombre d'octects par secondes
	n_read = fread(&WaveHeader->FMT.Blockalign, 2, 1, WaveHeader->file);		// nombre d'octects pour coder un échantillon
	n_read = fread(&WaveHeader->FMT.BitsPerSample, 2, 1, WaveHeader->file);		// nombre de bits pour coder un échantillon
	
	// FICHIER WAV ?
	if ((0 != strncmp (WaveHeader->RIFF.ChunkID, "RIFF", 4)) || (0 != strncmp (WaveHeader->RIFF.Format, "WAVE", 4)) || (0 != strncmp (WaveHeader->FMT.Subchunk1ID, "fmt ", 4))) {
		g_print ("%s  n'est pas un fichier wav\n", wave_file);  
		// fclose(WaveHeader->file);  
		// WaveHeader->file = NULL;
		tagswav_close_file( WaveHeader );
		return (FALSE);
	}
	
	// POINTEUR AU DEBUT DU FICHIER
	rewind (WaveHeader->file);
	do {
		// LECTURE D UN BLOCK
		n_read = fread (devbuf, BLOCK_SIZE, 1, WaveHeader->file);
		// RECHERCHE DE: data
		for (cpt = 0; cpt < BLOCK_SIZE; cpt ++) {
			if (devbuf [ cpt +0 ] == 'd' && devbuf [ cpt +1 ] == 'a' && devbuf [ cpt +2 ] == 't' && devbuf [ cpt +3 ] == 'a') {
				BoolFound = TRUE;
				break;
			}
		}
		if (TRUE == BoolFound) break;
		// VARIABLE TOTAL OCTECTS LU MOINS 8 AU CAS OU data SOIS COUPE EN FIN DE BLOCK
		tt_read += BLOCK_SIZE;
		tt_read -= 8;
		// POINTEUR AU DEBUT DU FICHIER
		rewind (WaveHeader->file);
		// POINTEUR DE LECTURE SUR tt_read
		fseek (WaveHeader->file, tt_read,  SEEK_CUR);
	} while (n_read > 0);
	
	if (TRUE == BoolFound)  {
		
		rewind (WaveHeader->file);
		n_read = fseek( WaveHeader->file, cpt + tt_read, SEEK_CUR );
		n_read = fread( &WaveHeader->DATA.Subchunk2ID, 4, 1, WaveHeader->file );
		n_read = fread( &WaveHeader->DATA.Subchunk2Size, 4, 1, WaveHeader->file );
		
		if( TRUE == OptionsCommandLine.BoolVerboseMode ) {
			g_print( "\n%s\n", wave_file );
			g_print ("\tBoolFound DATA = %s\n", BoolFound ? "TRUE" : "FALSE");
			g_print ("\tChunkID        = %c%c%c%c\n", WaveHeader->RIFF.ChunkID [ 0 ], WaveHeader->RIFF.ChunkID [ 1 ], WaveHeader->RIFF.ChunkID [ 2 ], WaveHeader->RIFF.ChunkID [ 3 ] );
			g_print ("\tChunkSize      = %d\n", WaveHeader->RIFF.ChunkSize);
			g_print ("\tFormat         = %c%c%c%c\n", WaveHeader->RIFF.Format [ 0 ], WaveHeader->RIFF.Format [ 1 ], WaveHeader->RIFF.Format [ 2 ], WaveHeader->RIFF.Format [ 3 ] );
			g_print ("\tSubchunk1ID    = %c%c%c%c\n", WaveHeader->FMT.Subchunk1ID [ 0 ], WaveHeader->FMT.Subchunk1ID [ 1 ], WaveHeader->FMT.Subchunk1ID [ 2 ], WaveHeader->FMT.Subchunk1ID [ 3 ] );
			g_print ("\tSubchunk1Size  = %d\n", WaveHeader->FMT.Subchunk1Size);  
			g_print ("\tAudioFormat    = %d\n", WaveHeader->FMT.AudioFormat);  
			g_print ("\tNumChannels    = %d\n", WaveHeader->FMT.NumChannels);  
			g_print ("\tSampleRate     = %d\n", WaveHeader->FMT.SampleRate);  
			g_print ("\tByteRate       = %d\n", WaveHeader->FMT.ByteRate);  
			g_print ("\tBlockalign     = %d\n", WaveHeader->FMT.Blockalign);  
			g_print ("\tBitsPerSample  = %d\n", WaveHeader->FMT.BitsPerSample);
			g_print ("\tSubchunk2ID    = %c%c%c%c\n", WaveHeader->DATA.Subchunk2ID [ 0 ], WaveHeader->DATA.Subchunk2ID [ 1 ], WaveHeader->DATA.Subchunk2ID [ 2 ], WaveHeader->DATA.Subchunk2ID [ 3 ] );
			g_print ("\tSubchunk2Size  = %d\n", WaveHeader->DATA.Subchunk2Size);
			g_print ("\n");
		}
 	}
	else if (FALSE == BoolFound)  {
		// fermeture du fichier  
		// fclose (WaveHeader->file);  
 		// WaveHeader->file = NULL;
 		tagswav_close_file( WaveHeader );
	}

	return BoolFound;  
}  
// 
// 
void tagswav_print( gchar *p_PathNameFile )
{
	if( TRUE == OptionsCommandLine.BoolVerboseMode ) {
		
		WAVE	WaveHeader;
	
		if (TRUE == tagswav_read_file( p_PathNameFile, &WaveHeader )) {
			g_print ("\n" );
			g_print ("\t%s\n", p_PathNameFile );
			g_print ("\tChunkID        = %c%c%c%c\n", WaveHeader.RIFF.ChunkID [ 0 ], WaveHeader.RIFF.ChunkID [ 1 ], WaveHeader.RIFF.ChunkID [ 2 ], WaveHeader.RIFF.ChunkID [ 3 ] );
			g_print ("\tChunkSize      = %d\n", WaveHeader.RIFF.ChunkSize);
			g_print ("\tFormat         = %c%c%c%c\n", WaveHeader.RIFF.Format [ 0 ], WaveHeader.RIFF.Format [ 1 ], WaveHeader.RIFF.Format [ 2 ], WaveHeader.RIFF.Format [ 3 ] );
			g_print ("\tSubchunk1ID    = %c%c%c%c\n", WaveHeader.FMT.Subchunk1ID [ 0 ], WaveHeader.FMT.Subchunk1ID [ 1 ], WaveHeader.FMT.Subchunk1ID [ 2 ], WaveHeader.FMT.Subchunk1ID [ 3 ] );
			g_print ("\tSubchunk1Size  = %d\n", WaveHeader.FMT.Subchunk1Size);  
			g_print ("\tAudioFormat    = %d\n", WaveHeader.FMT.AudioFormat);  
			g_print ("\tNumChannels    = %d\n", WaveHeader.FMT.NumChannels);  
			g_print ("\tSampleRate     = %d\n", WaveHeader.FMT.SampleRate);  
			g_print ("\tByteRate       = %d\n", WaveHeader.FMT.ByteRate);  
			g_print ("\tBlockalign     = %d\n", WaveHeader.FMT.Blockalign);  
			g_print ("\tBitsPerSample  = %d\n", WaveHeader.FMT.BitsPerSample);
			g_print ("\tSubchunk2ID    = %c%c%c%c\n", WaveHeader.DATA.Subchunk2ID [ 0 ], WaveHeader.DATA.Subchunk2ID [ 1 ], WaveHeader.DATA.Subchunk2ID [ 2 ], WaveHeader.DATA.Subchunk2ID [ 3 ] );
			g_print ("\tSubchunk2Size  = %d\n", WaveHeader.DATA.Subchunk2Size);
			g_print ("\n");
		}
		tagswav_close_file( &WaveHeader );
	}
}
// 
// 
INFO_WAV *tagswav_remove_info (INFO_WAV *info)
{
	if (info) {
		if (NULL != info->time)		{ g_free (info->time);		info->time = NULL;	}
		if (NULL != info->hertz)	{ g_free (info->hertz);		info->hertz = NULL;	}
		if (NULL != info->voie)		{ g_free (info->voie);		info->voie = NULL;	}
		if (NULL != info->bits)		{ g_free (info->bits);		info->bits = NULL;	}
		if (NULL != info->NewHertz)	{ g_free (info->NewHertz);	info->NewHertz = NULL;	}
		if (NULL != info->NewVoie)	{ g_free (info->NewVoie);	info->NewVoie = NULL;	}
		if (NULL != info->NewBits)	{ g_free (info->NewBits);	info->NewBits = NULL;	}

		info->tags = (TAGS *)tags_remove (info->tags);

		g_free (info);
		info = NULL;
	}
	return ((INFO_WAV *)NULL);
}
// 
// 
gboolean tagswav_file_is_mono (gchar *namefile)
{
	WAVE	WaveHeader;
	
	if (TRUE == tagswav_read_file (namefile, &WaveHeader)) {
		tagswav_close_file( &WaveHeader );
		return (WaveHeader.FMT.NumChannels == 1 ? TRUE : FALSE);
	}
	return (FALSE);
}
// 
// 
gboolean tagswav_file_GetBitrate (gchar *namefile, gint *Channels, gint *Hertz, gint *Bits)
{
	WAVE	WaveHeader;
	
	if (TRUE == tagswav_read_file (namefile, &WaveHeader)) {
		tagswav_close_file( &WaveHeader );
		if (Channels)	*Channels = WaveHeader.FMT.NumChannels;
		if (Hertz)	*Hertz    = WaveHeader.FMT.SampleRate;
		if (Bits)	*Bits     = WaveHeader.FMT.BitsPerSample;
		return ((WaveHeader.FMT.NumChannels != 2 || WaveHeader.FMT.SampleRate != 44100 || WaveHeader.FMT.BitsPerSample != 16) ? TRUE : FALSE);
	}
	return (FALSE);
}
// 
// 
INFO_WAV *tagswav_get_info (gchar *namefile)
{
	WAVE		WaveHeader;
	INFO_WAV	*ptrinfo = NULL;
	gint		m;
	gint		s;
	gint		sec;
	gboolean	BoolReadWavFile;
	
	// PRINT_FUNC_LF();
	
	ptrinfo = (INFO_WAV *)g_malloc0 (sizeof (INFO_WAV));
	if (NULL == ptrinfo) {
		g_print ("!---------------------------------------\n");
		PRINT_FUNC_LF();
		g_print ("!---------------------------------------\n");
		g_print ("! PTRINFO EST NULL  :(\n");
		g_print ("!---------------------------------------\n");
		return (NULL);
	}

	BoolReadWavFile = tagswav_read_file (namefile, &WaveHeader);
	tagswav_close_file( &WaveHeader );
	
	if (FALSE == BoolReadWavFile) {
		g_free (ptrinfo);
		PRINT("EXIT");
		ptrinfo = NULL;
		return (NULL);
	}
	if (WaveHeader.DATA.Subchunk2Size == 0 || WaveHeader.FMT.ByteRate == 0) {
		g_free (ptrinfo);
		ptrinfo = NULL;
		g_print ("! ---\n");
		g_print ("! MAUVAIS ENTETE DU FICHIER: %s\n", namefile);
		g_print ("! ---\n\n");
		return (NULL);
	}
	
	// calcul de la duree
	sec = WaveHeader.DATA.Subchunk2Size / WaveHeader.FMT.ByteRate;
	ptrinfo->SecTime              = sec;

	s = sec % 60; sec /= 60;
	m = sec % 60; sec /= 60;
	if (sec > 0) ptrinfo->time = g_strdup_printf ("%02d:%02d:%02d", sec, m, s);
	else         ptrinfo->time = g_strdup_printf ("%02d:%02d", m, s);
		
	// mode
	ptrinfo->voie    = g_strdup_printf ("%d", WaveHeader.FMT.NumChannels);
	ptrinfo->NewVoie = g_strdup_printf ("%d", WaveHeader.FMT.NumChannels);

	// freq
	ptrinfo->hertz    = g_strdup_printf ("%d", WaveHeader.FMT.SampleRate);
	ptrinfo->NewHertz = g_strdup_printf ("%d", WaveHeader.FMT.SampleRate);

	// format
	ptrinfo->bits    = g_strdup_printf ("%d", WaveHeader.FMT.BitsPerSample);
	ptrinfo->NewBits = g_strdup_printf ("%d", WaveHeader.FMT.BitsPerSample);
	
	ptrinfo->BoolConv= FALSE;

	ptrinfo->tags = (TAGS *)tags_alloc (FALSE);
	tags_set (namefile, ptrinfo->tags);
	
	ptrinfo->LevelDbfs.level = -1;
	ptrinfo->LevelDbfs.NewLevel = -1;

	return (ptrinfo);
}
// 
// RETOUR DE LA DUREE D'ECOUTE EN SECONDES
// 		
gint tagswav_get_time_sec (gchar *namefile)
{
	WAVE	WaveHeader;
	
	// PRINT_FUNC_LF();
	
	if (TRUE == tagswav_read_file (namefile, &WaveHeader)) {
		tagswav_close_file( &WaveHeader );
		return (WaveHeader.DATA.Subchunk2Size / WaveHeader.FMT.ByteRate);
	}
	return (0);
}
		
		





