/***************************************************************************
    file                 : S003_multi.cpp
    begin                : Wed 07-Mar-01
    copyright            : (C) 2001 by Mike Richardson
    email                : mike@quaking.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; you may use the current    *
 *   version as of 07-Mar-2001, or at your discretion, any later version.  *
 *                                                                         *
 ***************************************************************************/

#include	<stdio.h>

#include	"xbsql.h"

int	main
	(	int	,
		char	*[]
	)
{

	XBaseSQL xb (".") ;

	if (!xb.execCommand ("create table T003_multi (i int(10) unique index, v char(80))"))
	{
		fprintf	(stderr, "S003_multi: create: %s\n", xb.lastError()) ;
		exit	(1) ;
	}

	XBSQLSelect	*select	;
	XBSQLInsert	*insert	;
	XBSQLUpdate	*update	;
	XBSQLDelete	*delrec	;

	select	= xb.openSelect ("select * from T003_multi") ;
	insert	= xb.openInsert ("insert into T003_multi values (?, ?)") ;
	update	= xb.openUpdate ("update T003_multi set v = ? where i = ?") ;
	delrec	= xb.openDelete	("delete from T003_multi where i = ?") ;

	XBSQLValue	v[2]	;

	if (!select->execute (0, 0))
	{
		fprintf	(stderr, "S003_multi: select: %s\n", xb.lastError()) ;
		exit	(1) ;
	}
	fprintf	(stdout, "select: %d rows\n", select->getNumRows()) ;

	for (int r = 0 ; r < 4 ; r += 1)
	{
		char	b[32]	;

		sprintf	(b, "text_%03d", r) ;
		v[0]	= r	;
		v[1]	= b	;

		if (!insert->execute (2, v))
		{
			fprintf	(stderr, "S003_multi: insert: %s\n", xb.lastError()) ;
			exit	(1) ;
		}
		fprintf	(stdout, "insert: %d rows\n", insert->getNumRows()) ;
	}

	if (!select->execute (0, 0))
	{
		fprintf	(stderr, "S003_multi: select: %s\n", xb.lastError()) ;
		exit	(1) ;
	}
	fprintf	(stdout, "select: %d rows\n", select->getNumRows()) ;

	v[0] = "one" ;
	v[1] = 1     ;

	if (!update->execute (2, v))
	{
		fprintf	(stderr, "S003_multi: update: %s\n", xb.lastError()) ;
		exit	(1) ;
	}
	fprintf	(stdout, "update: %d rows\n", update->getNumRows()) ;

	v[0] = 2 ;

	if (!delrec->execute (1, v))
	{
		fprintf	(stderr, "S003_multi: delete: %s\n", xb.lastError()) ;
		exit	(1) ;
	}
	fprintf	(stdout, "detete: %d rows\n", delrec->getNumRows()) ;

	if (!select->execute (0, 0))
	{
		fprintf	(stderr, "S003_multi: select: %s\n", xb.lastError()) ;
		exit	(1) ;
	}
	fprintf	(stdout, "select: %d rows\n", select->getNumRows()) ;

	for (uint r = 0 ; r < select->getNumRows() ; r += 1)
	{
		for (uint c = 0 ; c < select->getNumFields() ; c += 1)
		{
			if (c > 0) fprintf (stdout, ",") ;
			fprintf	(stdout, "\"%s\"", select->getField(r, c).getText()) ;
		}
		fprintf	(stdout, "\n") ;
	}

	if (!xb.execCommand ("drop table T003_multi"))
	{
		fprintf	(stderr, "S003_multi: drop  : %s\n", xb.lastError()) ;
		exit	(1) ;
	}

	delete	select	;
	delete	insert	;
	delete	update	;
	delete	delrec	;

	return	0 ;
}

