//
// XBlast Robot File
//
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

//
// default value for angles (if not already defined)
//
#ifndef (leftLowerArmAngle)
  #declare leftLowerArmAngle  = <  -15,   0, -30>
#end
#ifndef (leftArmAngle)
  #declare leftArmAngle       = <   15,  10, -45>
#end
#ifndef (rightLowerArmAngle)
  #declare rightLowerArmAngle = <  -15,   0,  30>
#end
#ifndef (rightArmAngle)
  #declare rightArmAngle      = <   15, -10,  45>
#end

#ifndef (rightLowerLegAngle)
  #declare rightLowerLegAngle = < - 25,  0,  0>
#end
#ifndef (rightLegAngle)
  #declare rightLegAngle      = < + 15, 15,  0>
#end
#ifndef (leftLowerLegAngle)
  #declare leftLowerLegAngle  = < - 25,  0,  0>
#end
#ifndef (leftLegAngle)
  #declare leftLegAngle       = < + 15,-15,  0>
#end

#ifndef (rightFootAngle)
  #declare rightFootAngle     = <    0,  0,  0>
#end
#ifndef (leftFootAngle)
  #declare leftFootAngle      = <    0,  0,  0>
#end

#ifndef (headAngle)
  #declare headAngle          = <    0,  0,  0>
#end
#ifndef (bodyAngle)           
  #declare bodyAngle          = <    0,  0,  0>
#end

//
// renormalize  leg angles
//
#declare LAN=0.4/0.45
#declare LANV=<LAN, 1, LAN>
#declare rightLowerLegAngle = LANV * rightLowerLegAngle
#declare rightLegAngle = LANV * rightLegAngle
#declare leftLowerLegAngle = LANV * leftLowerLegAngle
#declare leftLegAngle = LANV * leftLegAngle


//
// froce field and other FX
//
#ifndef (activateForceField)
  #declare activateForceField = 0
#end
#ifndef (forceFieldPhase)
  #declare forceFieldPhase = 0.0
#end

//
// Damaged Player
//
#ifndef (playerDamaged)
  #declare playerDamaged=0
#end

//
// sick player
//
#ifndef (playerIsSick)
  #declare playerIsSick=0
#end

//
// additional colors
//
#ifndef (beltColor)
#declare beltColor = color rgb <0.1,0.1,0.1>
#end

//
// no face (needed helmet for helmet camera)
//
#ifndef (noFace)
#declare noFace = 0
#end

#include "XBlastTexture.inc"

//
// some useful shapes
//
#declare helmetSphere =
superellipsoid {
  <1, 0.9>
  rotate x*90
}

//
// include force field
//
#if (activateForceField = 1)
  #include "XBlast Force Field.inc"
#end

//
// the head
//
#declare PlayerHead =
union {
  // helmet
  difference {
    // hull
    difference {
      object {
        helmetSphere
        scale <1.1,0.85,1.1>
      }
      object {
        helmetSphere
        scale <1.05,0.80,1.05>
      }
    }
    // cutout for window
    intersection {
      cylinder { <0.0,-1.25,0.0>, <0.0,-1.25,-2.0>, 1.75 }
      cylinder { <0.0, 1.25,0.1>, <0.0, 1.25,-2.1>, 1.75 }
      plane { x, 0.8 }
      plane { -x, 0.8 }
    }
  }
  // glass window
  difference {
    object {
      helmetSphere
      scale <1.083,0.833,1.083>
    }
    object {
      helmetSphere
      scale <1.067,0.817,1.067>
    }
    texture {myGlass}
  }
  #if (noFace = 0)
    //
    // face
    //
    sphere {
      <0,0,0>, 1
      scale <1.0,0.75,1.0>
      texture {faceTexture}
    }
    //
    // eyes
    //
    // right eye
    intersection {
      sphere {
        <0,0,0>, 1
        scale <1.025,0.775,1.025>
      }
      #if (playerDamaged) 
        intersection {
          cylinder {
            <0,0,0>, <0,0,-1.5>, 1
            scale <0.2,0.3,1>
          }
          union {
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*37.5          
            }
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*-37.5          
            }
          }
          translate <-0.3,0,0>
        }
      #else
        cylinder {
          <0,0,0>, <0,0,-1.5>, 1
          scale <0.2,0.3,1>
          translate <-0.3,0,0>
        }
      #end   
      #if (playerIsSick)
        texture {
          spiral1 2
          texture_map {
            [0.0 pigment {color Gray15} finish {Glossy} ]
            [0.5 pigment {color Gray15} finish {Glossy} ]
            [0.5 pigment {color rgbt <0,0,0,1>} ]
            [1.0 pigment {color rgbt <0,0,0,1>} ]
          }
          rotate x*90
          scale <0.1,0.15,0.5>
          translate <-0.3,0,0>
        }
      #else
        pigment {color Gray15}
        finish {Glossy }
      #end 
    }
    // left eye
    intersection {
      sphere {
        <0,0,0>, 1
        scale <1.025,0.775,1.025>
      }
      #if (playerDamaged)
        intersection {
          cylinder {
            <0,0,0>, <0,0,-1.5>, 1
            scale <0.2,0.3,1>
          }
          union {
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*37.5          
            }
            box {
              <-0.05,-1,-1>          
              < 0.05, 1, 1>
              rotate z*-37.5          
            }
          }
          translate <0.3,0,0>
        }
      #else
        cylinder {
          <0,0,0>, <0,0,-1.5>, 1
          scale <0.2,0.3,1>
          translate <0.3,0,0>
        }
      #end
      #if (playerIsSick)
        texture {
          spiral1 2
          texture_map {
	    [0.0 pigment {color Gray15} finish {Glossy} ]
  	    [0.5 pigment {color Gray15} finish {Glossy} ]
  	    [0.5 pigment {color rgbt <0,0,0,1>} ]
  	    [1.0 pigment {color rgbt <0,0,0,1>} ]
          }
          rotate x*90
          scale <0.1,0.15,0.5>
          translate <0.3,0,0>
        }
      #else
        pigment {color Gray15}
        finish {Glossy }
      #end
    }
  #end
  //
  // antenna
  //
  union {
    cylinder {
      <0,0,0>, <0,1.2,0>, 0.1
      texture {armsLegsTexture}
    }
    sphere {
      <0,1.2,0>, 0.2
      texture {handsFeetTexture}
    }
    rotate x*45
  }
  texture {helmetTexture}
  translate <0, 0.2125,-0.275>
  rotate headAngle
  translate <0,-0.2125, 0.275>
}

//
// the body
//
#declare PlayerBody =
union {
  // main body
  sphere {
    <0,0,0>, 1
    scale <0.8,1.0,0.6>
  }
  // backpack
  union {
    superellipsoid {
      <0.5, 0.5>
      scale <0.6,0.55,0.3>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.4,0.1,0.1>
      translate <0.0,0.2,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.4,0.1,0.1>
      translate <0.0,0.0,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.4,0.1,0.1>
      translate <0.0,-0.2,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.1,0.35,0.1>
      translate <0.55,0.0,0.05>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.1,0.35,0.1>
      translate <-0.55,0.0,0.05>
    }
    translate <0,0.0,0.5>
    texture {backpackTexture}
  }
  // bomb emblem
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.825,1.025,0.625>
    }
    union {
      cylinder {
        <0,0,0>, <0,0,-1>, 0.175
      }
      box {
        <0.00,-0.025,0>
        <0.35, 0.025,-1>
        rotate z*45
      }
      translate <0.4,0.2,0>
    }
    pigment {
      wood
      color_map {
        [0.000 color White]
        [0.100 color White]
        [0.101 color Gray10]
        [1.000 color Gray10]
      }
      translate <0.4-0.04,0.3+0.04,0.0>
    }
    finish {Shiny}
  }
  // belt
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.825,1.025,0.625>
    }
    union {
      box { <-0.20,-0.65,0>, <0.20,-0.35,-1> }
      intersection {
        plane { -y, 0.55}
        plane {  y,-0.35}
      }
    }
    pigment {color beltColor}
    finish {Dull}
  }
  // belt lock
  intersection {
    sphere {
      <0,0,0>, 1
      scale <0.85,1.05,0.65>
    }
    box { <-0.15,-0.60,0>, <0.15,-0.40,-1> }
    texture {backpackTexture}
  }
  texture {bodyTexture}
}


#declare PlayerRightHand =
union {
  // main part
  sphere {
    <0,0,0>, 1
    scale <0.2,0.125,0.25>
  }
  // thumb
  sphere {
    <0,0,0>, 1
    scale <0.1,0.1,0.25>
    rotate y*60
    rotate z*30
    translate <-0.10,-0.05,-0.15>
  }
  // fingers
  sphere {
    <0,0,0>, 1
    scale <0.3,0.125,0.2>
    translate <-0.20,-0.025,0.05>
    rotate z*30
  }
  // additional objects 
  #ifdef (rightHandObject)
    object {rightHandObject translate <-0.20,-0.225,0.05>}
  #end
  texture {handsFeetTexture}
  rotate z*-15
}

#declare PlayerRightLowerArm =
union {
 object {
    PlayerRightHand
    translate <-0.575,0,0>
  }
  sphere {
    <-0.45,0,0>, 0.225
  }
  cone {
    <-0.02187, 0, 0>, 0.26159
    <-0.46875, 0, 0>, 0.22422
  }
}

#declare PlayerRightUpperArm =
union {
  object {
    PlayerRightLowerArm
    rotate rightLowerArmAngle
    translate x*-0.45
  }
  union {
    sphere {
      <0,0,0>, 0.3
    }
    cone {
      <-0.02500, 0, 0>, 0.29896
      <-0.47187, 0, 0>, 0.26159
    }
    sphere {
      <-0.45,0,0>, 0.2625
    }
  }
}

#declare PlayerRightArm =
union {
  object {
    PlayerRightUpperArm
    rotate rightArmAngle
  }
  intersection {
    plane  { -x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.6, 0.3, 0.3>
  }
  texture {armsLegsTexture}
}

//
// Left arm of player, includings hands
//

#declare PlayerLeftHand =
union {
  sphere {
    <0,0,0>, 1
    scale <0.2,0.125,0.25>
  }
  // thumb
  sphere {
    <0,0,0>, 1
    scale <0.1,0.1,0.25>
    rotate y*-60
    rotate z*-30
    translate <0.10,-0.05,-0.15>
  }
  sphere {
    <0,0,0>, 1
    scale <0.3,0.125,0.2>
    translate <0.20,-0.025,0.05>
    rotate z*-30
  }
  // additional objects 
  #ifdef (leftHandObject) 
    object {leftHandObject translate < 0.20,-0.225,0.05>}
  #end
  texture {handsFeetTexture}
  rotate z*15
}

#declare PlayerLeftLowerArm =
union {
 object {
    PlayerLeftHand
    translate <0.575,0,0>
  }
  sphere {
    <0.45,0,0>, 0.225
  }
  cone {
    <0.02187, 0, 0>, 0.26159
    <0.46875, 0, 0>, 0.22422
  }
}

#declare PlayerLeftUpperArm =
union {
  object {
    PlayerLeftLowerArm
    rotate leftLowerArmAngle
    translate x*0.45
  }
  union {
    sphere {
      <0,0,0>, 0.3
    }
    cone {
      <0.02500, 0, 0>, 0.29896
      <0.47187, 0, 0>, 0.26159
    }
    sphere {
      <0.45,0,0>, 0.2625
    }
  }
}

#declare PlayerLeftArm =
union {
  object {
    PlayerLeftUpperArm
    rotate leftArmAngle
  }
  intersection {
    plane  { x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.6, 0.3, 0.3>
  }
  texture {armsLegsTexture}
}

//
// legs
//

//
// legs
//

#declare PlayerFoot =
union {
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { -y, 0 }
    scale <0.4,0.3,0.55>
  }
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { y, 0 }
    scale <0.4,0.1,0.55>
  }
  texture {handsFeetTexture}
}

#declare PlayerLowerRightLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.35,-0.15>
    rotate rightFootAngle
    translate <0.0,-0.45,0.0>
  }
  sphere {
    <0,-0.45,0>, 0.3
  }
  cylinder {
    <0,0,0>, <0,-0.45,0>, 0.3
  }
}

#declare PlayerUpperRightLeg =
union {
  object {
    PlayerLowerRightLeg
    rotate rightLowerLegAngle
    translate <0.0,-0.45,0.0>
  }
  sphere {
    <0,0,0>, 0.3
  }
  sphere {
    <0,-0.45,0>, 0.3
  }
  cylinder {
    <0,0,0>, <0,-0.45,0>, 0.3
  }
}

#declare PlayerRightLeg =
object {
    PlayerUpperRightLeg
    rotate rightLegAngle
    texture {armsLegsTexture}
}



#declare PlayerLowerLeftLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.35,-0.15>
    rotate leftFootAngle
    translate <0.0,-0.45,0.0>
  }
  sphere {
    <0,-0.45,0>, 0.3
  }
  cylinder {
    <0,0,0>, <0,-0.45,0>, 0.3
  }
}

#declare PlayerUpperLeftLeg =
union {
  object {
    PlayerLowerLeftLeg
    rotate leftLowerLegAngle
    translate <0.0,-0.45,0.0>
  }
  sphere {
    <0,0,0>, 0.3
  }
  sphere {
    <0,-0.45,0>, 0.3
  }
  cylinder {
    <0,0,0>, <0,-0.45,0>, 0.3
  }
}

#declare PlayerLeftLeg =
object {
  PlayerUpperLeftLeg
  rotate leftLegAngle
  texture {armsLegsTexture}
}


//
// end file "XBlastTall.inc"
//
