//
// XBlast Robot File
//
//
// Program XBLAST V2.6 or higher
// (C) by Oliver Vogel (e-mail: m.vogel@ndh.net)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published
// by the Free Software Foundation; either version 2; or (at your option)
// any later version
//
// This program is distributed in the hope that it will be entertaining,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILTY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License along
// with this program; if not, write to the Free Software Foundation, Inc.
// 675 Mass Ave, Cambridge, MA 02139, USA.
//
//

//
// default value for angles (if not already defined)
//
#ifndef (leftLowerArmAngle)
  #declare leftLowerArmAngle  = <  -15,   0, -30>
#end
#ifndef (leftArmAngle)
  #declare leftArmAngle       = <   15,  10, -45>
#end
#ifndef (rightLowerArmAngle)
  #declare rightLowerArmAngle = <  -15,   0,  30>
#end
#ifndef (rightArmAngle)
  #declare rightArmAngle      = <   15, -10,  45>
#end

#ifndef (rightLowerLegAngle)
  #declare rightLowerLegAngle = < - 25,  0,  0>
#end
#ifndef (rightLegAngle)
  #declare rightLegAngle      = < + 15, 15,  0>
#end
#ifndef (leftLowerLegAngle)
  #declare leftLowerLegAngle  = < - 25,  0,  0>
#end
#ifndef (leftLegAngle)
  #declare leftLegAngle       = < + 15,-15,  0>
#end

#ifndef (rightFootAngle)
  #declare rightFootAngle     = <    0,  0,  0>
#end
#ifndef (leftFootAngle)
  #declare leftFootAngle      = <    0,  0,  0>
#end

#ifndef (headAngle)
  #declare headAngle          = <    0,  0,  0>
#end
#ifndef (bodyAngle)           
  #declare bodyAngle          = <    0,  0,  0>
#end

//
// froce field and other FX
//
#ifndef (activateForceField)
  #declare activateForceField = 0
#end
#ifndef (forceFieldPhase)
  #declare forceFieldPhase = 0.0
#end

//
// Damaged Player
//
#ifndef (playerDamaged)
  #declare playerDamaged=0
#end

//
// sick player
//
#ifndef (playerIsSick)
  #declare playerIsSick=0
#end

//
// additional colors
//
#ifndef (beltColor)
#declare beltColor = color rgb <0.1,0.1,0.1>
#end

#include "XBlastTexture.inc"

//
// some useful shapes
//
#declare helmetSphere =
superellipsoid {
  <1, 0.9>
  rotate x*90
}

//
// include force field
//
#if (activateForceField = 1)
  #include "XBlast Force Field.inc"
#end

//
// the head
//
#declare PlayerHead =
union {
  // helmet
  difference {
    // hull
    difference {
      object {
        helmetSphere
        scale <1.15,0.85,1.15>
      }
      object {
        helmetSphere
        scale <1.10,0.80,1.10>
      }
    }
    // cutout for window
    intersection {
      cylinder { <0.0,-1.25,0.0>, <0.0,-1.25,-2.0>, 1.75 }
      cylinder { <0.0, 1.25,0.1>, <0.0, 1.25,-2.1>, 1.75 }
      plane { x, 0.825 }
      plane { -x, 0.825 }
    }
  }
  // glass window
  difference {
    object {
      helmetSphere
      scale <1.133,0.833,1.133>
    }
    object {
      helmetSphere
      scale <1.117,0.817,1.117>
    }
    texture {myGlass}
  }
  // face
  sphere {
    <0,0,0>, 1
    scale <1.05,0.75,1.05>
    texture {faceTexture}
  }
  // eyes
    #if (playerDamaged)
    intersection {
      sphere {
        <0,0,0>, 1
        scale <1.075,0.775,1.075>
      }
      union {
        intersection {
          cylinder {
            <0,0,0>, <0,0,-1.5>, 1
            scale <0.2,0.3,1>
          }
          union {
            box {
              <-0.05,-1,-1.5>          
              < 0.05, 1, 1>
              rotate z*37.5          
            }
            box {
              <-0.05,-1,-1.5>          
              < 0.05, 1, 1>
              rotate z*-37.5          
            }
          }
          translate <-0.3,0,0>
        }
        intersection {
          cylinder {
            <0,0,0>, <0,0,-1.5>, 1
            scale <0.2,0.3,1>
          }
          union {
            box {
              <-0.05,-1,-1.5>          
              < 0.05, 1, 1>
              rotate z*37.5          
            }
            box {
              <-0.05,-1,-1.5>          
              < 0.05, 1, 1>
              rotate z*-37.5          
            }
          }
          translate <0.3,0,0>
        }
      }
      pigment {color Gray15}
      finish {Glossy }
    }
  #else
  // right eye
  intersection {
    sphere {
      <0,0,0>, 1
      scale <1.075,0.775,1.075>
    }
    cylinder {
      <0,0,0>, <0,0,-1.5>, 1
      scale <0.2,0.3,1>
      translate <-0.3,0,0>
    }
#if (playerIsSick)
    texture {
      spiral1 2
      texture_map {
	[0.0 pigment {color Gray15} finish {Glossy} ]
        [0.5 pigment {color Gray15} finish {Glossy} ]
        [0.5 pigment {color rgbt <0,0,0,1>} ]
        [1.0 pigment {color rgbt <0,0,0,1>} ]
      }
      rotate x*90
      scale <0.1,0.15,0.5>
      translate <-0.3,0,0>
    }
#else
    pigment {color Gray15}
    finish {Glossy }
#end
  }
  intersection {
    sphere {
      <0,0,0>, 1
      scale <1.075,0.775,1.075>
    }
    cylinder {
      <0,0,0>, <0,0,-1.5>, 1
      scale <0.2,0.3,1>
      translate <0.3,0,0>
    }
#if (playerIsSick)
    texture {
      spiral1 2
      texture_map {
	[0.0 pigment {color Gray15} finish {Glossy} ]
	[0.5 pigment {color Gray15} finish {Glossy} ]
	[0.5 pigment {color rgbt <0,0,0,1>} ]
	[1.0 pigment {color rgbt <0,0,0,1>} ]
      }
      rotate x*90
      scale <0.1,0.15,0.5>
      translate <0.3,0,0>
    }
#else
    pigment {color Gray15}
    finish {Glossy }
#end
  }
  #end
  // antenna
  union {
    cylinder {
      <0,0,0>, <0,1.2,0>, 0.125
      texture {armsLegsTexture}
    }
    sphere {
      <0,1.2,0>, 0.2
      texture {handsFeetTexture}
    }
    rotate x*45
  }
  texture {helmetTexture}
  translate <0, 0.2125,-0.275>
  rotate headAngle
  translate <0,-0.2125, 0.275>
}

//
// the body
//
#declare PlayerBody =
union {
  // main body
  union {
    sphere {
      <0,0,0>, 1
      scale <0.85,0.9,0.65>
    }
    sphere {
      <0,0,0>, 1
      scale <0.80,0.70,0.65>
      translate <0.00,-0.175,-0.20>
    }
  }
  // backpack
  union {
    superellipsoid {
      <0.5, 0.5>
      scale <0.6,0.55,0.3>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.4,0.1,0.1>
      translate <0.0,0.2,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.4,0.1,0.1>
      translate <0.0,0.0,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.4,0.1,0.1>
      translate <0.0,-0.2,0.25>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.1,0.35,0.1>
      translate <0.55,0.0,0.05>
    }
    superellipsoid {
      <0.75, 0.75>
      scale <0.1,0.35,0.1>
      translate <-0.55,0.0,0.05>
    }
    translate <0,0.0,0.5>
    texture {backpackTexture}
  }
  // bomb emblem
  intersection {
    union {
      sphere {
	<0,0,0>, 1
	scale <0.875,0.925,0.675>
      }
      sphere {
	<0,0,0>, 1
	scale <0.825,0.725,0.675>
	translate <0.00,-0.175,-0.20>
      }
    }
    union {
      cylinder {
        <0,0,0>, <0,0,-1>, 0.175
      }
      box {
        <0.00,-0.025,0>
        <0.35, 0.025,-1>
        rotate z*45
      }
      translate <0.35,0.2,0>
    }
    pigment {
      wood
      color_map {
        [0.000 color White]
        [0.100 color White]
        [0.101 color Gray10]
        [1.000 color Gray10]
      }
      translate <0.3-0.04,0.2+0.04,0.0>
    }
    finish {Shiny}
  }
  // belt
  intersection {
    merge {
      sphere {
	<0,0,0>, 1
	scale <0.875,0.925,0.675>
      }
      sphere {
	<0,0,0>, 1
	scale <0.825,0.725,0.675>
	translate <0.00,-0.175,-0.20>
      }
    }
    union {
      box { <-0.20,-0.50,0>, <0.20,-0.20,-1> }
      intersection {
        plane { -y, 0.45}
        plane {  y,-0.25}
      }
    }
    pigment {color beltColor}
    finish {Dull}
  }
  // belt lock
  intersection {
    merge {
      sphere {
	<0,0,0>, 1
	scale <0.900,0.950,0.700>
      }
      sphere {
	<0,0,0>, 1
	scale <0.800,0.700,0.700>
	translate <0.00,-0.20,-0.20>
      }
    }
    box { <-0.15,-0.45,0>, <0.15,-0.25,-1> }
    texture {backpackTexture}
  }
  texture {bodyTexture}
}


#declare PlayerRightHand =
union {
  // main part
  sphere {
    <0,0,0>, 1
    scale <0.2,0.125,0.25>
  }
  // thumb
  sphere {
    <0,0,0>, 1
    scale <0.1,0.1,0.25>
    rotate y*60
    rotate z*30
    translate <-0.10,-0.05,-0.15>
  }
  // fingers
  sphere {
    <0,0,0>, 1
    scale <0.3,0.125,0.2>
    translate <-0.20,-0.025,0.05>
    rotate z*30
  }
  texture {handsFeetTexture}
  rotate z*-15
}

#declare PlayerRightLowerArm =
union {
 object {
    PlayerRightHand
    translate <-0.525,0,0>
  }
  sphere {
    <-0.4,0,0>, 0.250
  }
  cone {
    <-0.024609375, 0, 0>, 0.286343889659
    <-0.421093750, 0, 0>, 0.2490090482792
  }
}

#declare PlayerRightUpperArm =
union {
  object {
    PlayerRightLowerArm
    rotate rightLowerArmAngle
    translate x*-0.4
  }
  union {
    sphere {
      <0,0,0>, 0.325
    }
    cone {
      <-0.028125000, 0, 0>, 0.3236787310389
      <-0.424609375, 0, 0>, 0.286343889659
    }
    sphere {
      <-0.4,0,0>, 0.2875
    }
  }
}

#declare PlayerRightArm =
union {
  object {
    PlayerRightUpperArm
    rotate rightArmAngle
  }
  intersection {
    plane  { -x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.625, 0.325, 0.325>
  }
  texture {armsLegsTexture}
}

//
// Left arm of player, includings hands
//

#declare PlayerLeftHand =
union {
  sphere {
    <0,0,0>, 1
    scale <0.2,0.125,0.25>
  }
  // thumb
  sphere {
    <0,0,0>, 1
    scale <0.1,0.1,0.25>
    rotate y*-60
    rotate z*-30
    translate <0.10,-0.05,-0.15>
  }
  sphere {
    <0,0,0>, 1
    scale <0.3,0.125,0.2>
    translate <0.20,-0.025,0.05>
    rotate z*-30
  }
  texture {handsFeetTexture}
  rotate z*15
}

#declare PlayerLeftLowerArm =
union {
 object {
    PlayerLeftHand
    translate <0.525,0,0>
  }
  sphere {
    <0.4,0,0>, 0.250
  }
  cone {
    <0.024609375, 0, 0>, 0.286343889659
    <0.421093750, 0, 0>, 0.2490090482792
  }
}

#declare PlayerLeftUpperArm =
union {
  object {
    PlayerLeftLowerArm
    rotate leftLowerArmAngle
    translate x*0.4
  }
  union {
    sphere {
      <0,0,0>, 0.325
    }
    cone {
      <0.028125000, 0, 0>, 0.3236787310389
      <0.424609375, 0, 0>, 0.286343889659
    }
    sphere {
      <0.4,0,0>, 0.2875
    }
  }
}

#declare PlayerLeftArm =
union {
  object {
    PlayerLeftUpperArm
    rotate leftArmAngle
  }
  intersection {
    plane  { x, 0 }
    sphere { <0,0,0>, 1 }
    scale <0.625, 0.325, 0.325>
  }
  texture {armsLegsTexture}
}

//
// legs
//

#declare PlayerFoot =
union {
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { -y, 0 }
    scale <0.425,0.3,0.525>
  }
  intersection {
    sphere { <0,0,0>, 1 }
    plane  { y, 0 }
    scale <0.425,0.1,0.525>
  }
  texture {handsFeetTexture}
}

#declare PlayerLowerRightLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate rightFootAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,-0.4,0>, 0.325
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.325
  }
}

#declare PlayerUpperRightLeg =
union {
  object {
    PlayerLowerRightLeg
    rotate rightLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,0,0>, 0.325
  }
  sphere {
    <0,-0.4,0>, 0.325
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.325
  }
}

#declare PlayerRightLeg =
object {
    PlayerUpperRightLeg
    rotate rightLegAngle
    texture {armsLegsTexture}
}



#declare PlayerLowerLeftLeg =
union {
  object {
    PlayerFoot
    translate <0.0,-0.3,-0.1>
    rotate leftFootAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,-0.4,0>, 0.325
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.325
  }
}

#declare PlayerUpperLeftLeg =
union {
  object {
    PlayerLowerLeftLeg
    rotate leftLowerLegAngle
    translate <0.0,-0.4,0.0>
  }
  sphere {
    <0,0,0>, 0.325
  }
  sphere {
    <0,-0.4,0>, 0.325
  }
  cylinder {
    <0,0,0>, <0,-0.4,0>, 0.325
  }
}

#declare PlayerLeftLeg =
object {
  PlayerUpperLeftLeg
  rotate leftLegAngle
  texture {armsLegsTexture}
}

//
// end file "XBlastFat.inc"
//
