/*   shameless stolen from xawtv-remote :-)          */
/*                                                   */
/*   (c) 2001 Michael Vogt <mvo@debian.org>          */
/*   Licensed under the GNU General Public License   */
/*                                                   */
/*   1 February 2001                                 */
/*     James M. Payne <jpnkids2@netscape.net>        */
/*   Altered functionality to make the applet a      */
/*   static size, add a power button, mute button,   */
/*   and volume buttons, and bitmaps.                */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "remote.h"
#include "pixmaps.h"

#define MY_LABEL_WIDTH 55

const gchar *authors[] = {
   "Michael Vogt <mvogt@acm.org>",
   "James M. Payne <jpnkids2@netscape.net>",
   NULL
  };

struct poptOption options[] = {
  {
      "xawtv-display",
      'x',
      POPT_ARG_STRING,
      &dpyname,
      0,
      N_("display on which xawtv is running"),
      NULL
  },
  {
      NULL
  },
};



/* debug the project ? */
unsigned int debug=0;

/* global handle for .xawtv */
gint timer_tag;
gboolean is_xawtv_running;
int applet_size;

char tmp_mode[255]; /* used for preference dialog */

/* Properties */
char     *dpyname = NULL;     /* xawtvs display */
char     *mode;               /* simple, detailed, tradtitional */
gboolean tooltips;            /* show tooltips */
gboolean warp_pointer;        /* warp_pointer */
gboolean startup_fullscreen;  /* start xawtv in fullscreen-mode */
gboolean mouse_wheel_channel; /* mouse wheel controls channel or volume */
gint     poll_intervall;      /* how often is polled for xawtv (0=disable) */
gchar xawtv_cmd[255];         /* xawtv-cmd */


/* parts from xawtv-remote.c */
Display  *dpy;
Window   win = 0;
Atom     station,remote;


/* public widgets */
GtkWidget *fixed;
GtkWidget *vbox;
GtkWidget *row1, *row2, *row3;

GtkWidget *frame;
GtkWidget *applet;
GtkWidget *label;             /* station label */
GtkTooltips *button_bar_tips; /* tooltips */
GtkWidget* pref_dialog=NULL;

/* Power, Full Screen, and Input buttons */
GtkWidget *pwr_button, *fscr_button, *inpt_button;  

/* Channel buttons (next, prev, back) */
GtkWidget *next_button, *prev_button, *back_button;  
 
/* Volume buttons (up, down, mute) */
GtkWidget *volu_button, *vold_button, *mute_button;  



/* sync with xawtv about current station, this is done every 1s */
gint tick( gpointer data )
{
  static char name[255];

    if(debug)
	printf("tick()\n");
    if(!is_xawtv_running) {
	look_for_xawtv();
	/* FIXME: special case for poll_intervall == 0 (this sucks) */
	if(is_xawtv_running == TRUE)
	  timer_tag = gtk_timeout_add(1000, tick, NULL);
	if(poll_intervall != 0)
	  timer_tag = gtk_timeout_add( poll_intervall*1000, tick, NULL);
    } else {
      is_xawtv_running = get_station_name(dpy, win, station, name);
      if(debug)
	printf("got from get_station_name(): %s\n",name);
      gtk_label_set_text(GTK_LABEL(label), name);
      timer_tag = gtk_timeout_add( 1000, tick, NULL);
    }
    return 0;
}


#ifdef HAVE_PANEL_PIXEL_SIZE
/*this is when the panel size changes*/
static void applet_change_pixel_size(GtkWidget *w, int size, gpointer data)
{
  applet_size = size;

  if(strcmp(mode, "detailed") == 0 || strcmp(mode, "small") == 0) {
    gtk_widget_set_usize(GTK_WIDGET(frame), MY_LABEL_WIDTH+size, size);
    return;
  }

  if(strcmp(mode, "small") == 0) {
    int y_size;

    if(applet_size > PIXEL_SIZE_TINY)
      y_size = PIXEL_SIZE_TINY;
    else
      y_size = applet_size;
    gtk_widget_set_usize(GTK_WIDGET(frame), 
			 applet_size+MY_LABEL_WIDTH, y_size);

    return;
  }
  
  gtk_widget_set_usize(GTK_WIDGET(frame), size, size);
}
#endif


static void startstop_callback (AppletWidget *applet, gpointer data)
{
    Window root,child;
    int rpx,rpy, wpx,wpy,mask;
    char tmp_cmd[255];
    char* cmd[] = {"quit"};

    if(debug)
	printf("start/stop callback\n");

    /* save mousepos, we may need it */
    XQueryPointer(dpy, RootWindowOfScreen(DefaultScreenOfDisplay(dpy)),
		  &root, &child, &rpx, &rpy, &wpx, &wpy, &mask);
    
    /* start/stop now */
    if(is_xawtv_running) {
	/* xawtv is running, stop it */
	pass_cmd(dpy, remote, win, 1, cmd);
	if(warp_pointer)
	    XWarpPointer(dpy, None, root, 0, 0, 0, 0, rpx, rpy);
    } else {
	/* xawtv not running. start it */
	if(dpyname != NULL)
	    setenv("DISPLAY",dpyname,1);

	if(startup_fullscreen) {
	    sprintf(tmp_cmd, "%s -f &", xawtv_cmd);
	    system(tmp_cmd);
	    if(warp_pointer)
		XWarpPointer(dpy, None, root, 0, 0, 0, 0, rpx, rpy);
	} else {
	    sprintf(tmp_cmd, "%s &", xawtv_cmd);
	    system(tmp_cmd);
	}
    }
    timer_tag = gtk_timeout_add( 1000, tick, NULL);
}


static void full_screen_callback (AppletWidget *applet, gpointer data)
{
    Window root,child;
    int rpx,rpy, wpx,wpy,mask;
    char* cmd[] = {"fullscreen"};
    
    if(debug)
	printf("full screen()\n");
    
    XQueryPointer(dpy, RootWindowOfScreen(DefaultScreenOfDisplay(dpy)),
		  &root, &child, &rpx, &rpy, &wpx, &wpy, &mask);
    pass_cmd(dpy, remote, win, 1, cmd);
    if(warp_pointer)
	XWarpPointer(dpy, None, root, 0, 0, 0, 0, rpx, rpy);
}


static void station_callback (AppletWidget *applet, gpointer data)
{
    char* cmd[] = {"setstation",NULL};
    if(debug)
	printf("station_callback: %s\n", (char*)data);
    cmd[1] = data;
    pass_cmd(dpy, remote, win, 2, cmd);
}

static void next_button_callback (GtkObject *object, gpointer data)
{
    char* cmd[] = {"setstation","next"};
    if(debug)
	printf("next_button_callback() \n");
    pass_cmd(dpy, remote, win, 2, cmd);
}

static void prev_button_callback (GtkObject *object, gpointer data)
{
    char* cmd[] = {"setstation","prev"};
    if(debug)
	printf("prev_button_callback()\n");
    pass_cmd(dpy, remote, win, 2, cmd); 
}

static void back_button_callback (GtkObject *object, gpointer data)
{
  char* cmd[] = {"setstation","back"};

  if(debug)
    printf("prev_button_callback()\n");

  pass_cmd(dpy, remote, win, 2, cmd); 
}


static void volu_button_callback (GtkObject *object, gpointer data)
{
  char* cmd[] = {"volume","inc"};

  if(debug)
    printf("volu_button_callback()\n");

  pass_cmd(dpy, remote, win, 2, cmd); 
}

static void vold_button_callback (GtkObject *object, gpointer data)
{
  char* cmd[] = {"volume","dec"};

  if(debug)
    printf("vold_button_callback()\n");

  pass_cmd(dpy, remote, win, 2, cmd); 
}

static void mute_callback (AppletWidget *applet, gpointer data)
{
    char* cmd[] = {"volume","mute"};
    
    if(debug)
	printf("mute_callback()\n");
    pass_cmd(dpy, remote, win, 2, cmd);
}

static void input_callback (AppletWidget *applet, gpointer data)
{
  char* cmd[] = {"setinput","next"};
    
  if(debug)
    printf("input_callback()\n");

  pass_cmd(dpy, remote, win, 2, cmd);
}

/* add mousewheel support */
static void button_press_callback(GtkWidget* widget,
				  GdkEventButton* event,
				  gpointer data)
{
	if(debug)
	    printf("button_press_event(): button=%i, type=%i\n", event->button, event->type);
	if(event->type == GDK_BUTTON_PRESS) {
	    switch ( event->button ) 
		{
		    /* mouse-whell up */
		case 4:
		    if(mouse_wheel_channel)
			next_button_callback(NULL,NULL);
		    else
			volu_button_callback(NULL, NULL);
		    break;
		    /* mouse-whell down */
		case 5: 
		    if(mouse_wheel_channel)
			prev_button_callback(NULL,NULL);
		    else
			vold_button_callback(NULL, NULL);
		    break;
		}
	}
	if((event->type == GDK_2BUTTON_PRESS) && (event->button == 1))
	{
		/* double click */
		startstop_callback(NULL, NULL);
	}
}

static void key_press_callback (GtkWidget* widget, 
				GdkEventKey* event, 
				gpointer data)
{
    if(debug)
	printf("key_press_callback()\n");
    switch ( event->keyval ) 
	{
	case GDK_Page_Up:
	    next_button_callback(NULL,NULL);
	    break;
	case GDK_Page_Down:
	    prev_button_callback(NULL,NULL);
	    break;
	default:
	    break;
	}
}

static void pref_callback(GtkWidget* widget, gpointer data)
{
  
  show_properties();
  if(debug)
    printf("about to call applet_widget_sync_config()\n");
  applet_widget_sync_config(APPLET_WIDGET(applet));
}

static void help_callback(GtkWidget* widget, gpointer data)
{
    GnomeHelpMenuEntry help_entry = { "xawtv_applet",
				      "index.html" };
    gnome_help_display(NULL, &help_entry);
}


/* sesion save signal handler*/
static gint applet_save_session(GtkWidget *w,
				const char *privcfgpath,
				const char *globcfgpath)
{
    if(debug)
	printf("applet_save_session()\n");
    gnome_config_push_prefix(privcfgpath);
    gnome_config_set_string("xawtv_applet/dpyname",dpyname);
    gnome_config_set_string("xawtv_applet/mode",mode);
    gnome_config_set_bool("xawtv_applet/tooltips",tooltips);
    gnome_config_set_bool("xawtv_applet/warp_pointer",warp_pointer);
    gnome_config_set_bool("xawtv_applet/startup_fullscreen",startup_fullscreen);
    gnome_config_set_bool("xawtv_applet/mouse_wheel_channel", mouse_wheel_channel);
    gnome_config_set_string("xawtv_applet/xawtv_cmd", xawtv_cmd);
    gnome_config_set_int("xawtv_applet/poll_intervall", poll_intervall);
    gnome_config_pop_prefix();
    gnome_config_sync();
    /* you need to use the drop_all here since we're all writing to
       one file, without it, things might not work too well */
    gnome_config_drop_all();

    return FALSE;
}

void draw_simple_look(GtkWidget *parent)
{
  GdkBitmap *mask=NULL;
  GtkStyle  *style; 

  /* special */
  style = gtk_widget_get_style(applet);

  /* set applet size */
  gtk_widget_set_usize(GTK_WIDGET(frame), applet_size, applet_size);

  if(debug)
    printf("Simple mode\n");

  /* top-level vbox */
  vbox = gtk_vbox_new(TRUE, 0);
  gtk_container_add(GTK_CONTAINER(parent), vbox);

  /* Create label for station ID. */
  label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

  /* create buttons */
  /* we want tooltips */
  button_bar_tips = gtk_tooltips_new();

  /* Create power button. */
  pwr_button = create_button(parent->window, (gchar **) xpm_power, mask,
			     &style->bg[GTK_STATE_NORMAL], 
			     GTK_SIGNAL_FUNC (startstop_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), pwr_button,
		       _("Turn on/off xawtv"),
		       "This will turn on/off xawtv.
			  If xawtv is not running, it will started,
                          if it is, it will be stopped.");
  
  /* Create next channel button. */
  next_button = create_button(parent->window, (gchar **) xpm_up, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (next_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), next_button,
		       _("Next channel"),
		       "This will switch to the next channel in
                          the channellist.");

  /* Create mute button. */
  mute_button = create_button(parent->window, (gchar **) xpm_mute, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (mute_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), mute_button,
		       _("Mute/unmute"),
		       "This will mute/unmute xawtv");
    
  /* Create volume down button. */
  vold_button = create_button(parent->window, (gchar **) xpm_left, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (vold_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), vold_button,
		       _("Decrease volume"),
		       "This will decrease the volume,");

  /* Create previous channel button. */
  prev_button = create_button(parent->window, (gchar **) xpm_down, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (prev_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), prev_button,
		       _("Previous channel"),
		       "This will switch to the previous channel in
                          the channellist.");

  /* Create volume up button. */
  volu_button = create_button(parent->window, (gchar **) xpm_right, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (volu_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), volu_button,
		       _("Increase volume"),
		       "This will Increase the volume,");
    
  /* see what to do with the tooltips */
  if(tooltips)
    gtk_tooltips_enable(GTK_TOOLTIPS(button_bar_tips));
  else
    gtk_tooltips_disable(GTK_TOOLTIPS(button_bar_tips));  

  /* first button row */
  row1 = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), pwr_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), next_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), mute_button, TRUE, TRUE, 0);

  /* second button row */
  row2 = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row2), vold_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row2), prev_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row2), volu_button, TRUE, TRUE, 0);

  /* cosemtic stuff */
  gtk_frame_set_shadow_type(GTK_FRAME(parent), GTK_SHADOW_IN);
  
  /* add to vbox */
  gtk_container_add(GTK_CONTAINER(vbox), row1);
  gtk_container_add(GTK_CONTAINER(vbox), row2);
}

void draw_traditional_look(GtkWidget *parent)
{
  GdkBitmap *mask=NULL;
  GtkStyle  *style; 

  if(debug)
    printf("traditional mode\n");

  /* special */
  style = gtk_widget_get_style(applet);

  /* set applet size */
  gtk_widget_set_usize(GTK_WIDGET(frame), applet_size, applet_size);

  /* top-level vbox */
  vbox = gtk_vbox_new(TRUE, 0);
  gtk_container_add(GTK_CONTAINER(parent), vbox);
    
  /* Create label for station ID. */
  label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

  /* we want tooltips */
  button_bar_tips = gtk_tooltips_new();

  /* Create next channel button. */
  next_button = create_button(frame->window, (gchar **) xpm_up, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (next_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), next_button,
		       _("Next channel"),
		       "This will switch to the next channel in
                          the channellist.");

  /* Create previous channel button. */
  prev_button = create_button(frame->window, (gchar **) xpm_down, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (prev_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), prev_button,
		       _("Previous channel"),
		       "This will switch to the previous channel in
                          the channellist.");


  /* put buttons */
  row1 = gtk_hbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), next_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), prev_button, TRUE, TRUE, 0);
      
  /* cosmetic stuff */
  gtk_frame_set_shadow_type(GTK_FRAME(parent), GTK_SHADOW_ETCHED_IN);
  gtk_button_set_relief(GTK_BUTTON(prev_button), GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(next_button), GTK_RELIEF_NONE);

  /* add first row */
  gtk_container_add(GTK_CONTAINER(vbox), row1);
}

void draw_detailed_look(GtkWidget *parent)
{
  GtkWidget *hbox;
  GdkBitmap *mask=NULL;
  GtkStyle  *style; 

  if(debug)
    printf("detailed mode\n");

  /* special */
  style = gtk_widget_get_style(applet);

  /* set label size */
  gtk_widget_set_usize(GTK_WIDGET(frame), applet_size+MY_LABEL_WIDTH, applet_size);

  /* create hbox */
  hbox = gtk_hbox_new(TRUE, 0);
  gtk_container_add(GTK_CONTAINER(parent), hbox);

  vbox = gtk_vbox_new(TRUE, 0);
  gtk_box_pack_start(GTK_BOX(hbox), vbox, TRUE, TRUE, 0);

  /* we want tooltips */
  button_bar_tips = gtk_tooltips_new();

  /* Create power button. */
  pwr_button = create_button(parent->window, (gchar **) xpm_power, mask,
			     &style->bg[GTK_STATE_NORMAL], 
			     GTK_SIGNAL_FUNC (startstop_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), pwr_button,
		       _("Turn on/off xawtv"),
		       "This will turn on/off xawtv.
			  If xawtv is not running, it will started,
                          if it is, it will be stopped.");
  
  /* Create next channel button. */
  next_button = create_button(parent->window, (gchar **) xpm_up, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (next_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), next_button,
		       _("Next channel"),
		       "This will switch to the next channel in
                          the channellist.");

  /* Create mute button. */
  mute_button = create_button(parent->window, (gchar **) xpm_mute, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (mute_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), mute_button,
		       _("Mute/unmute"),
		       "This will mute/unmute xawtv");
    
  /* Create volume down button. */
  vold_button = create_button(parent->window, (gchar **) xpm_left, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (vold_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), vold_button,
		       _("Decrease volume"),
		       "This will decrease the volume,");

  /* Create previous channel button. */
  prev_button = create_button(parent->window, (gchar **) xpm_down, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (prev_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), prev_button,
		       _("Previous channel"),
		       "This will switch to the previous channel in
                          the channellist.");

  /* Create volume up button. */
  volu_button = create_button(parent->window, (gchar **) xpm_right, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (volu_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), volu_button,
		       _("Increase volume"),
		       "This will Increase the volume,");
    
  /* Create back button. */
  back_button = create_button(parent->window, (gchar **) xpm_back, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (back_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), back_button,
		       _("Last channel"),
		       "This will switch to the last channel");

  /* Create full screen button. */
  fscr_button = create_button(parent->window, (gchar **) xpm_fullscreen, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (full_screen_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), fscr_button,
		       _("Fullscreen"),
		       "This will switch to fullscreen mode");
  
  /* Create input button. */
  inpt_button = create_button(parent->window, (gchar **) xpm_input, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (input_callback)); 
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), inpt_button,
		       _("Switch video input"),
		       "This will switch the video input source");

  /* see what to do with the tooltips */
  if(tooltips)
    gtk_tooltips_enable(GTK_TOOLTIPS(button_bar_tips));
  else
    gtk_tooltips_disable(GTK_TOOLTIPS(button_bar_tips));

  /* three rows */
  row1 = gtk_hbox_new(TRUE, 0);
  row2 = gtk_hbox_new(TRUE, 0);
  row3 = gtk_hbox_new(TRUE, 0);

  /* first button row */
  gtk_box_pack_start(GTK_BOX(row1), pwr_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), next_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row1), mute_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), row1, TRUE, TRUE, 0);

  /* second button row */
  gtk_box_pack_start(GTK_BOX(row2), vold_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row2), back_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row2), volu_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), row2, TRUE, TRUE, 0);

  /* third button row */
  gtk_box_pack_start(GTK_BOX(row3), fscr_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row3), prev_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(row3), inpt_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(vbox), row3, TRUE, TRUE, 0);

  /* Create label for station ID. */
  label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(hbox), label,       TRUE, TRUE, 0);
      
  /* cosmetic */
  gtk_frame_set_shadow_type(GTK_FRAME(parent), GTK_SHADOW_IN);
}

void draw_small_look(GtkWidget *parent)
{
  GdkBitmap *mask=NULL;
  GtkStyle  *style; 
  int y_size;

  if(debug)
    printf("small mode\n");

  /* special */
  style = gtk_widget_get_style(applet);

  /* set applet size */
  if(applet_size > PIXEL_SIZE_TINY)
    y_size = PIXEL_SIZE_TINY;
  else
    y_size = applet_size;
  gtk_widget_set_usize(GTK_WIDGET(frame), applet_size+MY_LABEL_WIDTH, y_size);

  /* top-level vbox */
  vbox = gtk_vbox_new(TRUE, 0);
  gtk_container_add(GTK_CONTAINER(parent), vbox);
    
  row1 = gtk_hbox_new(FALSE, 0);

  /* put label */
  label = gtk_label_new("");
  gtk_box_pack_start(GTK_BOX(row1), label, TRUE, TRUE, 0);

  /* Create next channel button. */
  next_button = create_button(frame->window, (gchar **) xpm_up, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (next_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), next_button,
		       _("Next channel"),
		       "This will switch to the next channel in
                          the channellist.");
  /* Create previous channel button. */
  prev_button = create_button(frame->window, (gchar **) xpm_down, mask,
			      &style->bg[GTK_STATE_NORMAL], 
			      GTK_SIGNAL_FUNC (prev_button_callback));
  gtk_tooltips_set_tip(GTK_TOOLTIPS (button_bar_tips), prev_button,
		       _("Previous channel"),
		       "This will switch to the previous channel in
                          the channellist.");

  gtk_box_pack_start(GTK_BOX(row1), next_button, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(row1), prev_button, FALSE, FALSE, 0);
  
  /* cosmetic stuff */
  gtk_frame_set_shadow_type(GTK_FRAME(frame), GTK_SHADOW_ETCHED_IN);
  gtk_button_set_relief(GTK_BUTTON(prev_button), GTK_RELIEF_NONE);
  gtk_button_set_relief(GTK_BUTTON(next_button), GTK_RELIEF_NONE);

  /* add first row */
  gtk_container_add(GTK_CONTAINER(vbox), row1);
}

/* create     Simple              Detailed
 *         +-----------+  +---+---+---+-----------+
 *         |  Station  |  |pwr|sup|mut|           | <- Future Station
 *         +---+---+---+  +---+---+---+-----------+
 *         |pwr|sup|mut|  |vdn|sbk|vup|  Station  | <- Future Volume
 *         +---+---+---+  +---+---+---+-----------+ 
 *         |vdn|sdn|vup|  |fsc|sdn|inp|           | <- Future Input
 *         +---+---+---+  +---+---+---+-----------+
 *
 *         Traditional
 *         +-------+     
 *         |Station|
 *         +-------+
 *         | - | + |
 *         +-------+
 *
 * Layout
 */
void place_widgets(GtkWidget *parent, char *mode)
{
  /* first, destroy all old objects */
  gtk_container_foreach(GTK_CONTAINER(frame), 
  			GTK_SIGNAL_FUNC(gtk_widget_destroy), NULL);

  /* start displaying */
  if(strcmp(mode, "simple") == 0)
      draw_simple_look(frame);
  
  if(strcmp(mode, "detailed") == 0)  
    draw_detailed_look(frame);

  if(strcmp(mode, "traditional") == 0)
    draw_traditional_look(frame);

  if(strcmp(mode, "small") == 0)
    draw_small_look(frame);

  gtk_widget_show_all(parent);
}

void about_callback(GtkWidget* widget, gpointer data)
{
    gtk_widget_show(gnome_about_new ("Xawtv Applet", VERSION,
				     "Copyright 2001 Michael Vogt",
				     (const gchar **) authors,
				     _("This applet is a remote control for Xawtv"),
				     NULL));

}

GtkWidget *create_button(GdkWindow *window, gchar **bitmap, 
                         GdkBitmap *mask, GdkColor *transparent_color,
			 GtkSignalFunc func)
{
  GtkWidget *button;
  GdkPixmap *pixmapa;
  GtkWidget *pixmapb;
  
  button = gtk_button_new ();
  gtk_widget_set_usize(button, 15, 15);
  gtk_signal_connect (GTK_OBJECT (button), "clicked", func, NULL);
 		
  pixmapa = gdk_pixmap_create_from_xpm_d (window, &mask, transparent_color,
                                          bitmap);
  pixmapb = gtk_pixmap_new(pixmapa, mask);
  gtk_widget_show (pixmapb);
  gtk_container_add(GTK_CONTAINER (button), pixmapb);
    
  gtk_widget_show (button);
  
  return button;
}

void look_for_xawtv() {
    if(debug)
	printf("look_for_xawtv()\n");
    
    /* find xawtv-window */
    station = XInternAtom(dpy, "_XAWTV_STATION", False);
    remote =  XInternAtom(dpy, "_XAWTV_REMOTE",  False);

   if (0 == (win = find_window(dpy,station)) ) {
	is_xawtv_running = FALSE;
	if(label != NULL)
	    gtk_label_set_text(GTK_LABEL(label), "");
	if(debug) {
	    printf("no xawtv running\n");
	    gtk_label_set_text(GTK_LABEL(label), "test");
	}
	return;
    }
   if(debug)
     printf("xawtv is running (is_xawtv_running=TRUE)\n");
   is_xawtv_running = TRUE;
} 

void init()
{

  /* session managment */
  gnome_config_push_prefix(APPLET_WIDGET(applet)->privcfgpath);
  if(dpyname == NULL) {
    /* read dpyname from config */
    dpyname = gnome_config_get_string("xawtv_applet/dpyname");
    if(debug)
      printf("load dpyname from config: %s\n",dpyname);
  }

  mode = gnome_config_get_string("xawtv_applet/mode=simple");
  tooltips = gnome_config_get_bool("xawtv_applet/tooltips=TRUE");
  warp_pointer = gnome_config_get_bool("xawtv_applet/warp_pointer=FALSE");
  startup_fullscreen = gnome_config_get_bool("xawtv_applet/startup_fullscreen=FALSE");
  mouse_wheel_channel = gnome_config_get_bool("xawtv_applet/mouse_wheel_channel=TRUE");
  poll_intervall = gnome_config_get_int("xawtv_applet/poll_intervall=2");
  strcpy(xawtv_cmd, gnome_config_get_string("xawtv_applet/xawtv_cmd=xawtv"));
  gnome_config_pop_prefix();

  /* open xawtvs display */
  if (NULL == (dpy = XOpenDisplay(dpyname))) {
    fprintf(stderr,"can't open display %s\n", dpyname?dpyname:"");
    gnome_dialog_run(GNOME_DIALOG(gnome_error_dialog(g_strdup_printf(_("Can't open display %s\n"), dpyname?dpyname:"" ))));
    applet_widget_abort_load(APPLET_WIDGET(applet));
    exit(1);
  }

  XSetErrorHandler(x11_error_dev_null);
  look_for_xawtv();
}

int main(int argc, char **argv)
{
  FILE *f;
  char* str;
  char stations_str[255];
  int i;
  poptContext ctx;

  
  /* init some data */
  i=0;

#ifdef ENABLE_NLS
    if(debug)
	    printf("enable NLS \n");
    bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
    textdomain (PACKAGE);
#endif
      
  
  /* create applet */
  applet_widget_init("xawtv_applet", VERSION, argc, argv, options, 0, &ctx);
  applet = applet_widget_new("xawtv_applet");
  if (!applet)
    g_error("Can't create applet!\n");
  
  /* TODO: split it into session management stuff, config-file etc */
  init();

  /* open .xawtv file */ 
  if( (f=open_xawtvrc_file()) == NULL ) {
    gnome_dialog_run(GNOME_DIALOG(gnome_error_dialog(_("can't open ~/.xawtv"))));
    applet_widget_abort_load(APPLET_WIDGET(applet));
    exit(1);
  }

  gtk_widget_set_events (applet, GDK_KEY_PRESS_MASK | GDK_BUTTON_PRESS_MASK);
  gtk_signal_connect (GTK_OBJECT(applet), "key_press_event",
		      GTK_SIGNAL_FUNC (key_press_callback), NULL);
  gtk_signal_connect (GTK_OBJECT(applet), "button_press_event",
		      GTK_SIGNAL_FUNC (button_press_callback), NULL);
     
#ifdef HAVE_PANEL_PIXEL_SIZE
  /*we have to bind change_pixel_size before we do applet_widget_add 
    since we need to get an initial change_pixel_size signal to set our
    initial size, and we get that during the _add call*/
  gtk_signal_connect(GTK_OBJECT(applet),"change_pixel_size",
		     GTK_SIGNAL_FUNC(applet_change_pixel_size),
		     NULL);
#endif

    frame = gtk_frame_new(NULL);

    /* now place the widgets 
     *(they are automaticly created inside place_widgets) 
     */
    place_widgets(frame, mode);

    
    /* bind the session save signal */
    gtk_signal_connect(GTK_OBJECT(applet),"save_session",
                       GTK_SIGNAL_FUNC(applet_save_session),
                       NULL);
    
    /* Start/Stop */
    applet_widget_register_callback(APPLET_WIDGET(applet),
				    "Start_Stop",
				    _("Start/Stop TV"),
				    startstop_callback,
				    NULL);

    /* "Mute" */
    applet_widget_register_callback(APPLET_WIDGET(applet),
				    "Mute",
				    _("Mute"),
				    mute_callback,
				    NULL);

    /* "Full Screen" */
    applet_widget_register_callback(APPLET_WIDGET(applet),
				    "FullScreen",
				    _("Full Screen"),
				    full_screen_callback,
				    NULL);

    /* add "Stations" submenu */
    applet_widget_register_callback_dir(APPLET_WIDGET (applet),
					"stations",
					_("Stations"));

    /* build stations menu, parse .xawtv */
    while( (str = read_station(f)) != NULL  ) {
        char* tmp = malloc(strlen(str));
        strcpy(tmp, str);
	sprintf(stations_str, "stations/%i",i++);
	if(debug)
	    printf("stations_str: %s | str: %s\n",stations_str, str);
	applet_widget_register_callback (APPLET_WIDGET (applet),
					 stations_str,
					 str,
					 station_callback,
					 tmp);
    }
   

    /* "Properties" */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					  "Properties...",
					  GNOME_STOCK_MENU_PREF,
					  _("Properties..."),
					  GTK_SIGNAL_FUNC(pref_callback),
					  NULL);

    applet_widget_register_stock_callback (APPLET_WIDGET (applet),
					   "help",
					   GNOME_STOCK_PIXMAP_HELP,
					   _("Help"),
					   GTK_SIGNAL_FUNC(help_callback), 
					   NULL);

    
    /* "About" */
    applet_widget_register_stock_callback(APPLET_WIDGET(applet),
					  "about",
					  GNOME_STOCK_MENU_ABOUT,
					  _("About..."),
					  GTK_SIGNAL_FUNC(about_callback),
					  NULL);

    /* add the widget to the applet-widget and show it */
    applet_widget_add(APPLET_WIDGET (applet), frame);
    gtk_widget_show(applet); 

    /* prevent multiple timers */
    if ( timer_tag == 0 && poll_intervall != 0 ) 
	timer_tag = gtk_timeout_add( poll_intervall*1000, tick, NULL);

    
    /* special corba main loop */
    applet_widget_gtk_main ();
    
    return 0;
}

