<?php

/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.30
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

// Try to load our extension if it's not already loaded.
if (!extension_loaded("xapian")) {
  if (strtolower(substr(PHP_OS, 0, 3)) === 'win') {
    if (!dl('php_xapian.dll')) return;
  } else {
    // PHP_SHLIB_SUFFIX is available as of PHP 4.3.0, for older PHP assume 'so'.
    // It gives 'dylib' on MacOS X which is for libraries, modules are 'so'.
    if (PHP_SHLIB_SUFFIX === 'PHP_SHLIB_SUFFIX' || PHP_SHLIB_SUFFIX === 'dylib') {
      if (!dl('xapian.so')) return;
    } else {
      if (!dl('xapian.'.PHP_SHLIB_SUFFIX)) return;
    }
  }
}



abstract class Xapian {
	static function version_string() {
		return version_string();
	}

	static function major_version() {
		return major_version();
	}

	static function minor_version() {
		return minor_version();
	}

	static function revision() {
		return revision();
	}

	const DB_CREATE_OR_OPEN = DB_CREATE_OR_OPEN;

	const DB_CREATE = DB_CREATE;

	const DB_CREATE_OR_OVERWRITE = DB_CREATE_OR_OVERWRITE;

	const DB_OPEN = DB_OPEN;

	static function auto_open($path,$action=null) {
		switch (func_num_args()) {
		case 1: $r=auto_open($path); break;
		default: $r=auto_open($path,$action);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case "_p_Xapian__WritableDatabase": return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function auto_open_stub($file) {
		$r=auto_open_stub($file);
		return is_resource($r) ? new XapianDatabase($r) : $r;
	}

	static function quartz_open($dir,$action=null,$block_size=8192) {
		switch (func_num_args()) {
		case 1: $r=quartz_open($dir); break;
		default: $r=quartz_open($dir,$action,$block_size);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case "_p_Xapian__WritableDatabase": return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function flint_open($dir,$action=null,$block_size=8192) {
		switch (func_num_args()) {
		case 1: $r=flint_open($dir); break;
		default: $r=flint_open($dir,$action,$block_size);
		}
		if (!is_resource($r)) return $r;
		switch (get_resource_type($r)) {
		case "_p_Xapian__WritableDatabase": return new XapianWritableDatabase($r);
		default: return new XapianDatabase($r);
		}
	}

	static function inmemory_open() {
		$r=inmemory_open();
		return is_resource($r) ? new XapianWritableDatabase($r) : $r;
	}

	static function muscat36_open_da($R,$T,$heavy_duty_or_values=true,$heavy_duty=true) {
		$r=muscat36_open_da($R,$T,$heavy_duty_or_values,$heavy_duty);
		return is_resource($r) ? new XapianDatabase($r) : $r;
	}

	static function muscat36_open_db($DB,$cache_size_or_values=null,$cache_size=null) {
		switch (func_num_args()) {
		case 1: $r=muscat36_open_db($DB); break;
		case 2: $r=muscat36_open_db($DB,$cache_size_or_values); break;
		default: $r=muscat36_open_db($DB,$cache_size_or_values,$cache_size);
		}
		return is_resource($r) ? new XapianDatabase($r) : $r;
	}

	static function remote_open($host_or_program,$port_or_args,$timeout=10000,$connect_timeout=null) {
		switch (func_num_args()) {
		case 2: case 3: $r=remote_open($host_or_program,$port_or_args,$timeout); break;
		default: $r=remote_open($host_or_program,$port_or_args,$timeout,$connect_timeout);
		}
		return is_resource($r) ? new XapianDatabase($r) : $r;
	}

	static function remote_open_writable($host_or_program,$port_or_args,$timeout=10000,$connect_timeout=null) {
		switch (func_num_args()) {
		case 2: case 3: $r=remote_open_writable($host_or_program,$port_or_args,$timeout); break;
		default: $r=remote_open_writable($host_or_program,$port_or_args,$timeout,$connect_timeout);
		}
		return is_resource($r) ? new XapianWritableDatabase($r) : $r;
	}
}

/* PHP Proxy Classes */
class XapianPositionIterator {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_PositionIterator(); break;
		default: $r=new_PositionIterator($other);
		}
		$this->_cPtr=$r;
	}

	function get_termpos() {
		return PositionIterator_get_termpos($this->_cPtr);
	}

	function next() {
		PositionIterator_next($this->_cPtr);
	}

	function equals($other) {
		return PositionIterator_equals($this->_cPtr,$other);
	}

	function skip_to($pos) {
		PositionIterator_skip_to($this->_cPtr,$pos);
	}

	function get_description() {
		return PositionIterator_get_description($this->_cPtr);
	}
}

class XapianPostingIterator {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_PostingIterator(); break;
		default: $r=new_PostingIterator($other);
		}
		$this->_cPtr=$r;
	}

	function get_docid() {
		return PostingIterator_get_docid($this->_cPtr);
	}

	function next() {
		PostingIterator_next($this->_cPtr);
	}

	function equals($other) {
		return PostingIterator_equals($this->_cPtr,$other);
	}

	function skip_to($did) {
		PostingIterator_skip_to($this->_cPtr,$did);
	}

	function get_doclength() {
		return PostingIterator_get_doclength($this->_cPtr);
	}

	function get_wdf() {
		return PostingIterator_get_wdf($this->_cPtr);
	}

	function positionlist_begin() {
		$r=PostingIterator_positionlist_begin($this->_cPtr);
		return is_resource($r) ? new XapianPositionIterator($r) : $r;
	}

	function positionlist_end() {
		$r=PostingIterator_positionlist_end($this->_cPtr);
		return is_resource($r) ? new XapianPositionIterator($r) : $r;
	}

	function get_description() {
		return PostingIterator_get_description($this->_cPtr);
	}
}

class XapianTermIterator {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_TermIterator(); break;
		default: $r=new_TermIterator($other);
		}
		$this->_cPtr=$r;
	}

	function get_term() {
		return TermIterator_get_term($this->_cPtr);
	}

	function next() {
		TermIterator_next($this->_cPtr);
	}

	function equals($other) {
		return TermIterator_equals($this->_cPtr,$other);
	}

	function skip_to($tname) {
		TermIterator_skip_to($this->_cPtr,$tname);
	}

	function get_wdf() {
		return TermIterator_get_wdf($this->_cPtr);
	}

	function get_termfreq() {
		return TermIterator_get_termfreq($this->_cPtr);
	}

	function positionlist_begin() {
		$r=TermIterator_positionlist_begin($this->_cPtr);
		return is_resource($r) ? new XapianPositionIterator($r) : $r;
	}

	function positionlist_end() {
		$r=TermIterator_positionlist_end($this->_cPtr);
		return is_resource($r) ? new XapianPositionIterator($r) : $r;
	}

	function get_description() {
		return TermIterator_get_description($this->_cPtr);
	}
}

class XapianValueIterator {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_ValueIterator(); break;
		default: $r=new_ValueIterator($other);
		}
		$this->_cPtr=$r;
	}

	function get_value() {
		return ValueIterator_get_value($this->_cPtr);
	}

	function next() {
		ValueIterator_next($this->_cPtr);
	}

	function equals($other) {
		return ValueIterator_equals($this->_cPtr,$other);
	}

	function get_valueno() {
		return ValueIterator_get_valueno($this->_cPtr);
	}

	function get_description() {
		return ValueIterator_get_description($this->_cPtr);
	}
}

class XapianDocument {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_Document(); break;
		default: $r=new_Document($other);
		}
		$this->_cPtr=$r;
	}

	function get_value($valueno) {
		return Document_get_value($this->_cPtr,$valueno);
	}

	function add_value($valueno,$value) {
		Document_add_value($this->_cPtr,$valueno,$value);
	}

	function remove_value($valueno) {
		Document_remove_value($this->_cPtr,$valueno);
	}

	function clear_values() {
		Document_clear_values($this->_cPtr);
	}

	function get_data() {
		return Document_get_data($this->_cPtr);
	}

	function set_data($data) {
		Document_set_data($this->_cPtr,$data);
	}

	function add_posting($tname,$tpos,$wdfinc=1) {
		Document_add_posting($this->_cPtr,$tname,$tpos,$wdfinc);
	}

	function add_term($tname,$wdfinc=1) {
		Document_add_term($this->_cPtr,$tname,$wdfinc);
	}

	function add_term_nopos($tname,$wdfinc=1) {
		Document_add_term_nopos($this->_cPtr,$tname,$wdfinc);
	}

	function remove_posting($tname,$tpos,$wdfdec=1) {
		Document_remove_posting($this->_cPtr,$tname,$tpos,$wdfdec);
	}

	function remove_term($tname) {
		Document_remove_term($this->_cPtr,$tname);
	}

	function clear_terms() {
		Document_clear_terms($this->_cPtr);
	}

	function termlist_count() {
		return Document_termlist_count($this->_cPtr);
	}

	function termlist_begin() {
		$r=Document_termlist_begin($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function termlist_end() {
		$r=Document_termlist_end($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function values_count() {
		return Document_values_count($this->_cPtr);
	}

	function values_begin() {
		$r=Document_values_begin($this->_cPtr);
		return is_resource($r) ? new XapianValueIterator($r) : $r;
	}

	function values_end() {
		$r=Document_values_end($this->_cPtr);
		return is_resource($r) ? new XapianValueIterator($r) : $r;
	}

	function get_description() {
		return Document_get_description($this->_cPtr);
	}
}

class XapianMSet {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_MSet(); break;
		default: $r=new_MSet($other);
		}
		$this->_cPtr=$r;
	}

	function fetch($begin_or_item=null,$end=null) {
		switch (func_num_args()) {
		case 0: MSet_fetch($this->_cPtr); break;
		case 1: MSet_fetch($this->_cPtr,$begin_or_item); break;
		default: MSet_fetch($this->_cPtr,$begin_or_item,$end);
		}
	}

	function convert_to_percent($wt_or_item) {
		return MSet_convert_to_percent($this->_cPtr,$wt_or_item);
	}

	function get_termfreq($tname) {
		return MSet_get_termfreq($this->_cPtr,$tname);
	}

	function get_termweight($tname) {
		return MSet_get_termweight($this->_cPtr,$tname);
	}

	function get_firstitem() {
		return MSet_get_firstitem($this->_cPtr);
	}

	function get_matches_lower_bound() {
		return MSet_get_matches_lower_bound($this->_cPtr);
	}

	function get_matches_estimated() {
		return MSet_get_matches_estimated($this->_cPtr);
	}

	function get_matches_upper_bound() {
		return MSet_get_matches_upper_bound($this->_cPtr);
	}

	function get_max_possible() {
		return MSet_get_max_possible($this->_cPtr);
	}

	function get_max_attained() {
		return MSet_get_max_attained($this->_cPtr);
	}

	function size() {
		return MSet_size($this->_cPtr);
	}

	function is_empty() {
		return MSet_is_empty($this->_cPtr);
	}

	function begin() {
		$r=MSet_begin($this->_cPtr);
		return is_resource($r) ? new XapianMSetIterator($r) : $r;
	}

	function end() {
		$r=MSet_end($this->_cPtr);
		return is_resource($r) ? new XapianMSetIterator($r) : $r;
	}

	function back() {
		$r=MSet_back($this->_cPtr);
		return is_resource($r) ? new XapianMSetIterator($r) : $r;
	}

	function get_hit($i) {
		$r=MSet_get_hit($this->_cPtr,$i);
		return is_resource($r) ? new XapianMSetIterator($r) : $r;
	}

	function get_document_percentage($i) {
		return MSet_get_document_percentage($this->_cPtr,$i);
	}

	function get_document($i) {
		$r=MSet_get_document($this->_cPtr,$i);
		return is_resource($r) ? new XapianDocument($r) : $r;
	}

	function get_docid($i) {
		return MSet_get_docid($this->_cPtr,$i);
	}

	function get_document_id($i) {
		return MSet_get_document_id($this->_cPtr,$i);
	}

	function get_description() {
		return MSet_get_description($this->_cPtr);
	}
}

class XapianMSetIterator {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_MSetIterator(); break;
		default: $r=new_MSetIterator($other);
		}
		$this->_cPtr=$r;
	}

	function get_docid() {
		return MSetIterator_get_docid($this->_cPtr);
	}

	function next() {
		MSetIterator_next($this->_cPtr);
	}

	function prev() {
		MSetIterator_prev($this->_cPtr);
	}

	function equals($other) {
		return MSetIterator_equals($this->_cPtr,$other);
	}

	function get_document() {
		$r=MSetIterator_get_document($this->_cPtr);
		return is_resource($r) ? new XapianDocument($r) : $r;
	}

	function get_rank() {
		return MSetIterator_get_rank($this->_cPtr);
	}

	function get_weight() {
		return MSetIterator_get_weight($this->_cPtr);
	}

	function get_collapse_count() {
		return MSetIterator_get_collapse_count($this->_cPtr);
	}

	function get_percent() {
		return MSetIterator_get_percent($this->_cPtr);
	}

	function get_description() {
		return MSetIterator_get_description($this->_cPtr);
	}
}

class XapianESet {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_ESet(); break;
		default: $r=new_ESet($other);
		}
		$this->_cPtr=$r;
	}

	function get_ebound() {
		return ESet_get_ebound($this->_cPtr);
	}

	function size() {
		return ESet_size($this->_cPtr);
	}

	function is_empty() {
		return ESet_is_empty($this->_cPtr);
	}

	function begin() {
		$r=ESet_begin($this->_cPtr);
		return is_resource($r) ? new XapianESetIterator($r) : $r;
	}

	function end() {
		$r=ESet_end($this->_cPtr);
		return is_resource($r) ? new XapianESetIterator($r) : $r;
	}

	function back() {
		$r=ESet_back($this->_cPtr);
		return is_resource($r) ? new XapianESetIterator($r) : $r;
	}

	function get_description() {
		return ESet_get_description($this->_cPtr);
	}
}

class XapianESetIterator {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_ESetIterator(); break;
		default: $r=new_ESetIterator($other);
		}
		$this->_cPtr=$r;
	}

	function get_termname() {
		return ESetIterator_get_termname($this->_cPtr);
	}

	function next() {
		ESetIterator_next($this->_cPtr);
	}

	function prev() {
		ESetIterator_prev($this->_cPtr);
	}

	function equals($other) {
		return ESetIterator_equals($this->_cPtr,$other);
	}

	function get_weight() {
		return ESetIterator_get_weight($this->_cPtr);
	}

	function get_description() {
		return ESetIterator_get_description($this->_cPtr);
	}
}

class XapianRSet {
	public $_cPtr=null;

	function __construct($other=null) {
		switch (func_num_args()) {
		case 0: $r=new_RSet(); break;
		default: $r=new_RSet($other);
		}
		$this->_cPtr=$r;
	}

	function size() {
		return RSet_size($this->_cPtr);
	}

	function is_empty() {
		return RSet_is_empty($this->_cPtr);
	}

	function add_document($did_or_i) {
		RSet_add_document($this->_cPtr,$did_or_i);
	}

	function remove_document($did_or_i) {
		RSet_remove_document($this->_cPtr,$did_or_i);
	}

	function contains($did_or_i) {
		return RSet_contains($this->_cPtr,$did_or_i);
	}

	function get_description() {
		return RSet_get_description($this->_cPtr);
	}
}

class XapianEnquire {
	public $_cPtr=null;

	function __construct($databases) {
		$this->_cPtr=new_Enquire($databases);
	}

	function set_query($query,$qlen=0) {
		Enquire_set_query($this->_cPtr,$query,$qlen);
	}

	function get_query() {
		$r=Enquire_get_query($this->_cPtr);
		return is_resource($r) ? new XapianQuery($r) : $r;
	}

	function set_weighting_scheme($weight) {
		Enquire_set_weighting_scheme($this->_cPtr,$weight);
	}

	function set_collapse_key($collapse_key) {
		Enquire_set_collapse_key($this->_cPtr,$collapse_key);
	}

	const ASCENDING = Enquire_ASCENDING;

	const DESCENDING = Enquire_DESCENDING;

	const DONT_CARE = Enquire_DONT_CARE;

	function set_docid_order($order) {
		Enquire_set_docid_order($this->_cPtr,$order);
	}

	function set_sort_forward($sort_forward) {
		Enquire_set_sort_forward($this->_cPtr,$sort_forward);
	}

	function set_cutoff($percent_cutoff,$weight_cutoff=0) {
		Enquire_set_cutoff($this->_cPtr,$percent_cutoff,$weight_cutoff);
	}

	function set_sorting($sort_key,$sort_bands,$sort_by_relevance=false) {
		Enquire_set_sorting($this->_cPtr,$sort_key,$sort_bands,$sort_by_relevance);
	}

	function set_sort_by_relevance() {
		Enquire_set_sort_by_relevance($this->_cPtr);
	}

	function set_sort_by_value($sort_key,$ascending=true) {
		Enquire_set_sort_by_value($this->_cPtr,$sort_key,$ascending);
	}

	function set_sort_by_value_then_relevance($sort_key,$ascending=true) {
		Enquire_set_sort_by_value_then_relevance($this->_cPtr,$sort_key,$ascending);
	}

	function set_sort_by_relevance_then_value($sort_key,$ascending=true) {
		Enquire_set_sort_by_relevance_then_value($this->_cPtr,$sort_key,$ascending);
	}

	function set_bias($bias_weight,$bias_halflife) {
		Enquire_set_bias($this->_cPtr,$bias_weight,$bias_halflife);
	}

	function get_mset($first,$maxitems,$checkatleast_or_omrset=0,$omrset_or_mdecider=null,$mdecider=null) {
		$r=Enquire_get_mset($this->_cPtr,$first,$maxitems,$checkatleast_or_omrset,$omrset_or_mdecider,$mdecider);
		return is_resource($r) ? new XapianMSet($r) : $r;
	}

	function get_eset($maxitems,$omrset,$flags=0,$k=1.0,$edecider=null) {
		$r=Enquire_get_eset($this->_cPtr,$maxitems,$omrset,$flags,$k,$edecider);
		return is_resource($r) ? new XapianESet($r) : $r;
	}

	function get_matching_terms_begin($did_or_i) {
		$r=Enquire_get_matching_terms_begin($this->_cPtr,$did_or_i);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function get_matching_terms_end($did_or_i) {
		$r=Enquire_get_matching_terms_end($this->_cPtr,$did_or_i);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function register_match_decider($name,$mdecider=null) {
		Enquire_register_match_decider($this->_cPtr,$name,$mdecider);
	}

	function get_matching_terms($hit) {
		return Enquire_get_matching_terms($this->_cPtr,$hit);
	}

	function get_description() {
		return Enquire_get_description($this->_cPtr);
	}
}

abstract class XapianWeight {
	public $_cPtr=null;
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function name() {
		return Weight_name($this->_cPtr);
	}

	function serialise() {
		return Weight_serialise($this->_cPtr);
	}

	function unserialise($s) {
		$r=Weight_unserialise($this->_cPtr,$s);
		return is_resource($r) ? new XapianWeight($r) : $r;
	}

	function get_sumpart($wdf,$len) {
		return Weight_get_sumpart($this->_cPtr,$wdf,$len);
	}

	function get_maxpart() {
		return Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($len) {
		return Weight_get_sumextra($this->_cPtr,$len);
	}

	function get_maxextra() {
		return Weight_get_maxextra($this->_cPtr);
	}

	function get_sumpart_needs_doclength() {
		return Weight_get_sumpart_needs_doclength($this->_cPtr);
	}
}

class XapianBoolWeight extends XapianWeight {
	public $_cPtr=null;

	function clone_object() {
		$r=BoolWeight_clone_object($this->_cPtr);
		return is_resource($r) ? new XapianBoolWeight($r) : $r;
	}

	function __construct() {
		$this->_cPtr=new_BoolWeight();
	}

	function name() {
		return BoolWeight_name($this->_cPtr);
	}

	function serialise() {
		return BoolWeight_serialise($this->_cPtr);
	}

	function unserialise($s) {
		$r=BoolWeight_unserialise($this->_cPtr,$s);
		return is_resource($r) ? new XapianBoolWeight($r) : $r;
	}

	function get_sumpart($wdf,$len) {
		return BoolWeight_get_sumpart($this->_cPtr,$wdf,$len);
	}

	function get_maxpart() {
		return BoolWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($len) {
		return BoolWeight_get_sumextra($this->_cPtr,$len);
	}

	function get_maxextra() {
		return BoolWeight_get_maxextra($this->_cPtr);
	}

	function get_sumpart_needs_doclength() {
		return BoolWeight_get_sumpart_needs_doclength($this->_cPtr);
	}
}

class XapianBM25Weight extends XapianWeight {
	public $_cPtr=null;

	function __construct($k1_=null,$k2_=null,$k3_=null,$b_=null,$min_normlen_=null) {
		switch (func_num_args()) {
		case 0: $r=new_BM25Weight(); break;
		case 1: $r=new_BM25Weight($k1_); break;
		case 2: $r=new_BM25Weight($k1_,$k2_); break;
		case 3: $r=new_BM25Weight($k1_,$k2_,$k3_); break;
		case 4: $r=new_BM25Weight($k1_,$k2_,$k3_,$b_); break;
		default: $r=new_BM25Weight($k1_,$k2_,$k3_,$b_,$min_normlen_);
		}
		$this->_cPtr=$r;
	}

	function clone_object() {
		$r=BM25Weight_clone_object($this->_cPtr);
		return is_resource($r) ? new XapianBM25Weight($r) : $r;
	}

	function name() {
		return BM25Weight_name($this->_cPtr);
	}

	function serialise() {
		return BM25Weight_serialise($this->_cPtr);
	}

	function unserialise($s) {
		$r=BM25Weight_unserialise($this->_cPtr,$s);
		return is_resource($r) ? new XapianBM25Weight($r) : $r;
	}

	function get_sumpart($wdf,$len) {
		return BM25Weight_get_sumpart($this->_cPtr,$wdf,$len);
	}

	function get_maxpart() {
		return BM25Weight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($len) {
		return BM25Weight_get_sumextra($this->_cPtr,$len);
	}

	function get_maxextra() {
		return BM25Weight_get_maxextra($this->_cPtr);
	}

	function get_sumpart_needs_doclength() {
		return BM25Weight_get_sumpart_needs_doclength($this->_cPtr);
	}
}

class XapianTradWeight extends XapianWeight {
	public $_cPtr=null;

	function __construct($k=null) {
		switch (func_num_args()) {
		case 0: $r=new_TradWeight(); break;
		default: $r=new_TradWeight($k);
		}
		$this->_cPtr=$r;
	}

	function clone_object() {
		$r=TradWeight_clone_object($this->_cPtr);
		return is_resource($r) ? new XapianTradWeight($r) : $r;
	}

	function name() {
		return TradWeight_name($this->_cPtr);
	}

	function serialise() {
		return TradWeight_serialise($this->_cPtr);
	}

	function unserialise($s) {
		$r=TradWeight_unserialise($this->_cPtr,$s);
		return is_resource($r) ? new XapianTradWeight($r) : $r;
	}

	function get_sumpart($wdf,$len) {
		return TradWeight_get_sumpart($this->_cPtr,$wdf,$len);
	}

	function get_maxpart() {
		return TradWeight_get_maxpart($this->_cPtr);
	}

	function get_sumextra($len) {
		return TradWeight_get_sumextra($this->_cPtr,$len);
	}

	function get_maxextra() {
		return TradWeight_get_maxextra($this->_cPtr);
	}

	function get_sumpart_needs_doclength() {
		return TradWeight_get_sumpart_needs_doclength($this->_cPtr);
	}
}

class XapianDatabase {
	public $_cPtr=null;

	function add_database($database) {
		Database_add_database($this->_cPtr,$database);
	}

	function __construct($path_or_other=null) {
		switch (func_num_args()) {
		case 0: $r=new_Database(); break;
		default: $r=new_Database($path_or_other);
		}
		$this->_cPtr=$r;
	}

	function reopen() {
		Database_reopen($this->_cPtr);
	}

	function get_description() {
		return Database_get_description($this->_cPtr);
	}

	function postlist_begin($tname) {
		$r=Database_postlist_begin($this->_cPtr,$tname);
		return is_resource($r) ? new XapianPostingIterator($r) : $r;
	}

	function postlist_end($tname) {
		$r=Database_postlist_end($this->_cPtr,$tname);
		return is_resource($r) ? new XapianPostingIterator($r) : $r;
	}

	function termlist_begin($did) {
		$r=Database_termlist_begin($this->_cPtr,$did);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function termlist_end($did) {
		$r=Database_termlist_end($this->_cPtr,$did);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function positionlist_begin($did,$tname) {
		$r=Database_positionlist_begin($this->_cPtr,$did,$tname);
		return is_resource($r) ? new XapianPositionIterator($r) : $r;
	}

	function positionlist_end($did,$tname) {
		$r=Database_positionlist_end($this->_cPtr,$did,$tname);
		return is_resource($r) ? new XapianPositionIterator($r) : $r;
	}

	function allterms_begin() {
		$r=Database_allterms_begin($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function allterms_end() {
		$r=Database_allterms_end($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function get_doccount() {
		return Database_get_doccount($this->_cPtr);
	}

	function get_lastdocid() {
		return Database_get_lastdocid($this->_cPtr);
	}

	function get_avlength() {
		return Database_get_avlength($this->_cPtr);
	}

	function get_termfreq($tname) {
		return Database_get_termfreq($this->_cPtr,$tname);
	}

	function term_exists($tname) {
		return Database_term_exists($this->_cPtr,$tname);
	}

	function get_collection_freq($tname) {
		return Database_get_collection_freq($this->_cPtr,$tname);
	}

	function get_doclength($docid) {
		return Database_get_doclength($this->_cPtr,$docid);
	}

	function keep_alive() {
		Database_keep_alive($this->_cPtr);
	}

	function get_document($did) {
		$r=Database_get_document($this->_cPtr,$did);
		return is_resource($r) ? new XapianDocument($r) : $r;
	}
}

class XapianWritableDatabase extends XapianDatabase {
	public $_cPtr=null;

	function __construct($path_or_other=null,$action=null) {
		switch (func_num_args()) {
		case 0: $r=new_WritableDatabase(); break;
		case 1: $r=new_WritableDatabase($path_or_other); break;
		default: $r=new_WritableDatabase($path_or_other,$action);
		}
		$this->_cPtr=$r;
	}

	function flush() {
		WritableDatabase_flush($this->_cPtr);
	}

	function begin_transaction($flushed=true) {
		WritableDatabase_begin_transaction($this->_cPtr,$flushed);
	}

	function commit_transaction() {
		WritableDatabase_commit_transaction($this->_cPtr);
	}

	function cancel_transaction() {
		WritableDatabase_cancel_transaction($this->_cPtr);
	}

	function add_document($document) {
		return WritableDatabase_add_document($this->_cPtr,$document);
	}

	function delete_document($did_or_unique_term) {
		WritableDatabase_delete_document($this->_cPtr,$did_or_unique_term);
	}

	function replace_document($did_or_unique_term,$document) {
		return WritableDatabase_replace_document($this->_cPtr,$did_or_unique_term,$document);
	}

	function get_description() {
		return WritableDatabase_get_description($this->_cPtr);
	}
}

class XapianQuery {
	public $_cPtr=null;

	const OP_AND = Query_OP_AND;

	const OP_OR = Query_OP_OR;

	const OP_AND_NOT = Query_OP_AND_NOT;

	const OP_XOR = Query_OP_XOR;

	const OP_AND_MAYBE = Query_OP_AND_MAYBE;

	const OP_FILTER = Query_OP_FILTER;

	const OP_NEAR = Query_OP_NEAR;

	const OP_PHRASE = Query_OP_PHRASE;

	const OP_ELITE_SET = Query_OP_ELITE_SET;

	function __construct($tname_or_op__or_copyme_or_op=null,$wqf_or_left_or_subqs_or_q=1,$term_pos_or_right_or_param=0) {
		switch (func_num_args()) {
		case 0: $r=new_Query(); break;
		default: $r=new_Query($tname_or_op__or_copyme_or_op,$wqf_or_left_or_subqs_or_q,$term_pos_or_right_or_param);
		}
		$this->_cPtr=$r;
	}

	function get_length() {
		return Query_get_length($this->_cPtr);
	}

	function get_terms_begin() {
		$r=Query_get_terms_begin($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function get_terms_end() {
		$r=Query_get_terms_end($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function is_empty() {
		return Query_is_empty($this->_cPtr);
	}

	function get_description() {
		return Query_get_description($this->_cPtr);
	}
}

abstract class XapianStopper {
	public $_cPtr=null;
	function __construct($h) {
		$this->_cPtr=$h;
	}

	function apply($term) {
		return Stopper_apply($this->_cPtr,$term);
	}

	function get_description() {
		return Stopper_get_description($this->_cPtr);
	}
}

class XapianSimpleStopper extends XapianStopper {
	public $_cPtr=null;

	function __construct() {
		$this->_cPtr=new_SimpleStopper();
	}

	function add($word) {
		SimpleStopper_add($this->_cPtr,$word);
	}

	function apply($term) {
		return SimpleStopper_apply($this->_cPtr,$term);
	}

	function get_description() {
		return SimpleStopper_get_description($this->_cPtr);
	}
}

class XapianQueryParser {
	public $_cPtr=null;

	const FLAG_BOOLEAN = QueryParser_FLAG_BOOLEAN;

	const FLAG_PHRASE = QueryParser_FLAG_PHRASE;

	const FLAG_LOVEHATE = QueryParser_FLAG_LOVEHATE;

	const FLAG_BOOLEAN_ANY_CASE = QueryParser_FLAG_BOOLEAN_ANY_CASE;

	const FLAG_WILDCARD = QueryParser_FLAG_WILDCARD;

	const STEM_NONE = QueryParser_STEM_NONE;

	const STEM_SOME = QueryParser_STEM_SOME;

	const STEM_ALL = QueryParser_STEM_ALL;

	function __construct() {
		$this->_cPtr=new_QueryParser();
	}

	function set_stemmer($stemmer) {
		QueryParser_set_stemmer($this->_cPtr,$stemmer);
	}

	function set_stemming_strategy($strategy) {
		QueryParser_set_stemming_strategy($this->_cPtr,$strategy);
	}

	function set_stopper($stop=null) {
		QueryParser_set_stopper($this->_cPtr,$stop);
	}

	function set_default_op($default_op_) {
		QueryParser_set_default_op($this->_cPtr,$default_op_);
	}

	function get_default_op() {
		return QueryParser_get_default_op($this->_cPtr);
	}

	function set_database($db_) {
		QueryParser_set_database($this->_cPtr,$db_);
	}

	function parse_query($q,$flags=null) {
		switch (func_num_args()) {
		case 1: $r=QueryParser_parse_query($this->_cPtr,$q); break;
		default: $r=QueryParser_parse_query($this->_cPtr,$q,$flags);
		}
		return is_resource($r) ? new XapianQuery($r) : $r;
	}

	function add_prefix($field,$prefix) {
		QueryParser_add_prefix($this->_cPtr,$field,$prefix);
	}

	function add_boolean_prefix($field,$prefix) {
		QueryParser_add_boolean_prefix($this->_cPtr,$field,$prefix);
	}

	function stoplist_begin() {
		$r=QueryParser_stoplist_begin($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function stoplist_end() {
		$r=QueryParser_stoplist_end($this->_cPtr);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function unstem_begin($term) {
		$r=QueryParser_unstem_begin($this->_cPtr,$term);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function unstem_end($term) {
		$r=QueryParser_unstem_end($this->_cPtr,$term);
		return is_resource($r) ? new XapianTermIterator($r) : $r;
	}

	function get_description() {
		return QueryParser_get_description($this->_cPtr);
	}
}

class XapianStem {
	public $_cPtr=null;

	function __construct($language) {
		$this->_cPtr=new_Stem($language);
	}

	function apply($word) {
		return Stem_apply($this->_cPtr,$word);
	}

	function stem_word($word) {
		return Stem_stem_word($this->_cPtr,$word);
	}

	function get_description() {
		return Stem_get_description($this->_cPtr);
	}

	static function get_available_languages() {
		return Stem_get_available_languages();
	}
}


?>
