/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.Context;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.ProcInstInfo;
import com.icl.saxon.om.ProcInstParser;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

class ProcInstImpl
extends NodeImpl
implements ProcInstInfo,
ProcessingInstruction {
    String target;
    String content;
    Name name;
    String systemId;
    int lineNumber = -1;

    public ProcInstImpl(String string, String string2) {
        this.name = new Name(string);
        this.target = string;
        this.content = string2;
    }

    public final Name getExpandedName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.target;
    }

    public String getValue() {
        return this.content;
    }

    public final short getNodeType() {
        return 7;
    }

    public void setLocation(String string, int n) {
        this.systemId = string;
        this.lineNumber = n;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void copy(Outputter outputter) throws SAXException {
        outputter.writePI(this.target, this.content);
    }

    public void defaultAction(Context context) {
    }

    public String getPath() {
        String string = ((NodeInfo)this.getParentNode()).getPath();
        return (string.equals("/") ? "" : string) + "/processing-instruction()[" + this.getNumberSimple() + "]";
    }

    public String getPseudoAttribute(String string) {
        return ProcInstParser.getPseudoAttribute(this.content, string);
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.content;
    }

    public void setData(String string) throws DOMException {
        this.disallowUpdate();
    }
}

