/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.Context;
import com.icl.saxon.Mode;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.om.TextInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.NodeImpl;
import com.icl.saxon.tree.TextImpl;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

abstract class ParentNodeImpl
extends NodeImpl {
    private Object children = null;
    protected int sequence;

    ParentNodeImpl() {
    }

    public long getSequenceNumber() {
        return (long)this.sequence << 32;
    }

    public int getNumberOfChildren() {
        if (this.children == null) {
            return 0;
        }
        if (this.children instanceof NodeInfo) {
            return 1;
        }
        return ((NodeInfo[])this.children).length;
    }

    public NodeInfo[] getAllChildNodes() {
        if (this.children == null) {
            return NodeImpl.emptyArray;
        }
        if (this.children instanceof NodeImpl) {
            NodeInfo[] nodeInfoArray = new NodeInfo[]{(NodeImpl)this.children};
            return nodeInfoArray;
        }
        return (NodeInfo[])this.children;
    }

    public Node getFirstChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        return ((NodeInfo[])this.children)[0];
    }

    public Node getLastChild() {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return (NodeImpl)this.children;
        }
        NodeInfo[] nodeInfoArray = (NodeInfo[])this.children;
        return nodeInfoArray[nodeInfoArray.length - 1];
    }

    protected final NodeInfo getNthChild(int n) {
        if (this.children == null) {
            return null;
        }
        if (this.children instanceof NodeImpl) {
            return n == 0 ? (NodeImpl)this.children : null;
        }
        NodeInfo[] nodeInfoArray = (NodeInfo[])this.children;
        if (n < 0 || n >= nodeInfoArray.length) {
            return null;
        }
        return nodeInfoArray[n];
    }

    public String getValue() {
        StringBuffer stringBuffer = null;
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            if (nodeInfo instanceof TextImpl) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer();
                }
                ((TextImpl)nodeInfo).appendValue(stringBuffer);
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        if (stringBuffer == null) {
            return "";
        }
        return stringBuffer.toString();
    }

    public void copyStringValue(Outputter outputter) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            if (nodeInfo instanceof TextInfo) {
                nodeInfo.copyStringValue(outputter);
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
    }

    public void defaultAction(Context context) throws SAXException {
        Mode mode = context.getMode();
        context.getController().applyTemplates(context, null, mode, null);
    }

    public void useChildrenArray(NodeImpl[] nodeImplArray) {
        this.children = nodeImplArray;
    }

    public void addChild(NodeImpl nodeImpl, int n) {
        NodeImpl[] nodeImplArray;
        if (this.children == null) {
            nodeImplArray = new NodeImpl[10];
        } else if (this.children instanceof NodeImpl) {
            nodeImplArray = new NodeImpl[10];
            nodeImplArray[0] = (NodeImpl)this.children;
        } else {
            nodeImplArray = (NodeImpl[])this.children;
        }
        if (n >= nodeImplArray.length) {
            NodeImpl[] nodeImplArray2 = new NodeImpl[nodeImplArray.length * 2];
            System.arraycopy(nodeImplArray, 0, nodeImplArray2, 0, nodeImplArray.length);
            nodeImplArray = nodeImplArray2;
        }
        nodeImplArray[n] = nodeImpl;
        nodeImpl.parent = this;
        nodeImpl.index = n;
        this.children = nodeImplArray;
    }

    public void removeChild(int n) {
        if (this.children instanceof NodeImpl) {
            this.children = null;
        } else {
            ((NodeImpl[])this.children)[n] = null;
        }
    }

    public void renumberChildren() {
        int n = 0;
        if (this.children == null) {
            return;
        }
        if (this.children instanceof NodeImpl) {
            ((NodeImpl)this.children).parent = this;
            ((NodeImpl)this.children).index = 0;
        } else {
            NodeImpl[] nodeImplArray = (NodeImpl[])this.children;
            int n2 = 0;
            while (n2 < nodeImplArray.length) {
                if (nodeImplArray[n2] != null) {
                    nodeImplArray[n2].parent = this;
                    nodeImplArray[n2].index = n;
                    nodeImplArray[n] = nodeImplArray[n2];
                    ++n;
                }
                ++n2;
            }
            this.compact(n);
        }
    }

    public void dropChildren() {
        NodeInfo nodeInfo = this.getNextInDocument(this);
        while (nodeInfo != null) {
            if (nodeInfo instanceof TextImpl) {
                ((TextImpl)nodeInfo).truncateToStart();
                break;
            }
            nodeInfo = nodeInfo.getNextInDocument(this);
        }
        this.children = null;
    }

    public void compact(int n) {
        if (n == 0) {
            this.children = null;
        } else if (n == 1) {
            if (this.children instanceof NodeImpl[]) {
                this.children = ((NodeImpl[])this.children)[0];
            }
        } else {
            NodeImpl[] nodeImplArray = new NodeImpl[n];
            System.arraycopy(this.children, 0, nodeImplArray, 0, n);
            this.children = nodeImplArray;
        }
    }

    public String getNodeValue() {
        return null;
    }
}

