/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.Context;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NodeImpl;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class NamespaceImpl
extends NodeImpl
implements NamespaceInfo {
    private String prefix;
    private String uri;
    private int index;
    private static Vector emptyVector = new Vector();

    public NamespaceImpl(ElementImpl elementImpl, String string, String string2, int n) throws SAXException {
        this.parent = elementImpl;
        this.prefix = string;
        this.uri = string2;
        this.index = n;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof NamespaceImpl)) {
            return false;
        }
        if (this == nodeInfo) {
            return true;
        }
        NamespaceImpl namespaceImpl = (NamespaceImpl)nodeInfo;
        return this.parent.isSameNode(namespaceImpl.parent) && this.prefix.equals(namespaceImpl.prefix);
    }

    public String getNamespacePrefix() {
        return this.prefix;
    }

    public String getNamespaceURI() {
        return this.uri;
    }

    public void setNamespacePrefix(String string) {
        this.prefix = string;
    }

    public void setNamespaceURI(String string) {
        this.uri = string;
    }

    public final short getNodeType() {
        return 9;
    }

    public String getValue() {
        return this.uri;
    }

    public Name getExpandedName() {
        return new Name(this.prefix);
    }

    public String getNodeName() {
        return this.prefix;
    }

    public Node getNextSibling() {
        return null;
    }

    public Node getPreviousSibling() {
        return null;
    }

    public NodeInfo getPreviousInDocument() {
        return null;
    }

    public NodeInfo getNextInDocument() {
        return null;
    }

    public int getNumberSingle(Pattern pattern, Pattern pattern2) throws SAXException {
        throw new SAXException("getNumberSingle() is not supported for namespace nodes");
    }

    public int getNumberAny(Pattern pattern, Pattern pattern2) throws SAXException {
        throw new SAXException("getNumberAny() is not supported for namespace nodes");
    }

    public Vector getNumberMulti(Pattern pattern, Pattern pattern2) throws SAXException {
        throw new SAXException("getNumberMulti() is not supported for namespace nodes");
    }

    public String getSequentialKey() {
        return this.parent.getSequentialKey() + "^" + this.prefix;
    }

    public void copy(Outputter outputter) throws SAXException {
    }

    public void defaultAction(Context context) {
    }

    public long getSequenceNumber() {
        return this.parent.getSequenceNumber() + (long)this.index;
    }

    public String getPath() {
        return this.parent.getPath() + "/namespace::" + this.prefix;
    }

    public String toString() {
        return "Namespace " + this.prefix;
    }
}

